/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.toolkit.modules.concurrency.internal;

import de.rcenvironment.toolkit.modules.concurrency.api.AsyncExceptionListener;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import de.rcenvironment.toolkit.modules.concurrency.api.RunnablesGroup;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import de.rcenvironment.toolkit.modules.concurrency.internal.CallablesGroupImpl;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RunnablesGroupImpl
extends CallablesGroupImpl<RuntimeException>
implements RunnablesGroup {
    private static final Log sharedLog = LogFactory.getLog(CallablesGroupImpl.class);

    public RunnablesGroupImpl(AsyncTaskService asyncTaskService) {
        super(asyncTaskService);
    }

    @Override
    public void add(final Runnable task) {
        this.add(new Callable<RuntimeException>(){

            @Override
            @TaskDescription(value="Internal RunnablesGroup task delegate")
            public RuntimeException call() throws Exception {
                try {
                    task.run();
                    return null;
                }
                catch (Throwable e) {
                    return this.wrapIfNecessary(e);
                }
            }

            private RuntimeException wrapIfNecessary(Throwable e) {
                if (e instanceof RuntimeException) {
                    sharedLog.debug((Object)"Caught asynchronous exception", e);
                    return (RuntimeException)e;
                }
                sharedLog.error((Object)"Non-RTE throwable caught:", e);
                return new RuntimeException(e);
            }
        });
    }

    @Override
    public List<RuntimeException> executeParallel() {
        return super.executeParallel(new AsyncExceptionListener(){

            @Override
            public void onAsyncException(Exception e) {
                sharedLog.error((Object)"Uncaught exception in RunnablesGroup", (Throwable)e);
            }
        });
    }
}

