/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette;

import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.gui.palette.ToolGroupAssignment;
import de.rcenvironment.core.gui.palette.toolidentification.ToolIdentification;
import de.rcenvironment.core.gui.palette.toolidentification.ToolType;
import de.rcenvironment.core.gui.palette.view.PaletteViewContentProvider;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.GroupNode;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PaletteViewStorage {
    protected final ConfigurationService configService;
    private final PaletteViewContentProvider contentProvider;
    private final Log log = LogFactory.getLog(this.getClass());
    private Path assignmentFile;
    private Path expandedGroupsFile;
    private Path customizedGroupsFile;
    private ToolGroupAssignment assignment;

    public PaletteViewStorage(PaletteViewContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.assignment = contentProvider.getAssignment();
        this.configService = (ConfigurationService)ServiceRegistry.createAccessFor((Object)this).getService(ConfigurationService.class);
        this.createStorageIfAbsent();
    }

    private void createStorageIfAbsent() {
        if (this.configService != null) {
            Path storeConfigurationPath = Paths.get(this.configService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTERNAL_DATA).toString(), "paletteViewStorage");
            this.assignmentFile = Paths.get(storeConfigurationPath.toString(), "toolGroupAssignment.dat");
            this.expandedGroupsFile = Paths.get(storeConfigurationPath.toString(), "expandedGroups.dat");
            this.customizedGroupsFile = Paths.get(storeConfigurationPath.toString(), "customizedGroups.dat");
            if (!storeConfigurationPath.toFile().exists()) {
                storeConfigurationPath.toFile().mkdir();
            }
            try {
                if (!this.assignmentFile.toFile().exists() && this.assignmentFile.toFile().createNewFile()) {
                    this.log.debug((Object)StringUtils.format((String)"Created customized assignments file: %s", (Object[])new Object[]{this.assignmentFile.toFile().toString()}));
                }
                if (!this.expandedGroupsFile.toFile().exists() && this.expandedGroupsFile.toFile().createNewFile()) {
                    this.log.debug((Object)StringUtils.format((String)"Created expanded groups file: %s", (Object[])new Object[]{this.expandedGroupsFile.toFile().toString()}));
                }
                if (!this.customizedGroupsFile.toFile().exists() && this.customizedGroupsFile.toFile().createNewFile()) {
                    this.log.debug((Object)StringUtils.format((String)"Created customized groups file: %s", (Object[])new Object[]{this.customizedGroupsFile.toFile().toString()}));
                }
            }
            catch (IOException e) {
                this.log.error((Object)"Error creating palette view storage files.", (Throwable)e);
            }
        } else {
            this.log.error((Object)StringUtils.format((String)"Could not create %s because ConfigurationService was not available.", (Object[])new Object[]{"paletteViewStorage"}));
        }
    }

    public List<String> loadFilesFromStorage() {
        this.loadCustomizedGroups();
        boolean assignmentLoaded = this.loadCustomizedAssignments();
        if (assignmentLoaded) {
            return this.loadExpandedGroups();
        }
        return new ArrayList<String>();
    }

    protected boolean loadCustomizedAssignments() {
        if (!this.assignmentFileExists()) {
            return false;
        }
        Optional<List<String>> optional = this.readAssignmentFile();
        if (!optional.isPresent()) {
            return false;
        }
        this.log.debug((Object)StringUtils.format((String)"Loaded custom group assignments from file '%s'.", (Object[])new Object[]{this.assignmentFile}));
        List<String> lines = optional.get();
        boolean returnValue = false;
        try {
            HashMap<ToolIdentification, String[]> customizedAssignment = new HashMap<ToolIdentification, String[]>();
            for (String line : lines) {
                String divider = ",";
                String[] splittedLine = line.split(";");
                String[] qualifiedGroupArray = splittedLine[1].split("/");
                String[] toolIdentificationString = splittedLine[0].split(divider);
                String toolID = toolIdentificationString[0];
                String displayName = toolIdentificationString[1];
                String type = toolIdentificationString[2];
                ToolIdentification toolIdentification = type.equals(ToolType.INTEGRATED_TOOL.toString()) ? ToolIdentification.createIntegratedToolIdentification(toolID, displayName) : (type.equals(ToolType.INTEGRATED_WORKFLOW.toString()) ? ToolIdentification.createIntegratedWorkflowIdentification(toolID, displayName) : ToolIdentification.createStandardComponentIdentification(toolID, displayName));
                customizedAssignment.put(toolIdentification, qualifiedGroupArray);
                this.log.debug((Object)StringUtils.format((String)"Restored custom group assignment: '%s' (%s) -> '%s'.", (Object[])new Object[]{displayName, toolID, splittedLine[1]}));
            }
            this.assignment.setCustomizedAssignments(customizedAssignment);
            returnValue = true;
        }
        catch (PatternSyntaxException e) {
            this.log.warn((Object)StringUtils.format((String)"Assignment of tools to groups could not be parsed correctly: %s. Default Palette View Configuration is loaded.", (Object[])new Object[]{this.assignmentFile.toString()}), (Throwable)e);
        }
        return returnValue;
    }

    protected Optional<List<String>> readAssignmentFile() {
        try {
            return Optional.of(Files.readAllLines(this.assignmentFile));
        }
        catch (IOException e) {
            this.log.error((Object)StringUtils.format((String)"Assignment of tools to groups could not be read: %s. Default Palette View Configuration is loaded.", (Object[])new Object[]{this.assignmentFile.toString()}), (Throwable)e);
            return Optional.empty();
        }
    }

    protected boolean assignmentFileExists() {
        return this.assignmentFile.toFile().exists();
    }

    private void loadCustomizedGroups() {
        if (!this.customizedGroupsFile.toFile().exists()) {
            this.log.error((Object)StringUtils.format((String)"Customized groups file '%s' does not exist.", (Object[])new Object[]{this.customizedGroupsFile.toString()}));
            return;
        }
        List<Object> lines = new ArrayList();
        try {
            lines = Files.readAllLines(this.customizedGroupsFile);
        }
        catch (IOException iOException) {
            this.log.error((Object)StringUtils.format((String)"Customized groups file: %s could not be read from profile dir: internal/%s", (Object[])new Object[]{this.customizedGroupsFile.toString(), "paletteViewStorage"}), (Throwable)iOException);
        }
        this.log.debug((Object)StringUtils.format((String)"Loaded custom groups from file '%s'.", (Object[])new Object[]{this.customizedGroupsFile}));
        for (String string : lines) {
            if (string.trim().isEmpty()) continue;
            String[] qualifiedGroupString = this.assignment.createPathArray(string.trim());
            PaletteTreeNode groupNode = this.contentProvider.getOrCreateGroupNode(qualifiedGroupString);
            groupNode.getGroupNode().setCustomGroup(true);
            this.log.debug((Object)StringUtils.format((String)"Restored custom group '%s'.", (Object[])new Object[]{string.trim()}));
        }
    }

    private List<String> loadExpandedGroups() {
        if (!this.expandedGroupsFile.toFile().exists() || this.expandedGroupsFile.toFile().length() == 0L) {
            return new ArrayList<String>();
        }
        List<Object> lines = new ArrayList();
        try {
            lines = Files.readAllLines(this.expandedGroupsFile);
            this.log.debug((Object)StringUtils.format((String)"Loaded expanded groups from file '%s'.", (Object[])new Object[]{this.expandedGroupsFile}));
        }
        catch (IOException e) {
            this.log.error((Object)StringUtils.format((String)"Expanded groups could not be set. File: '%s' could not be read.", (Object[])new Object[]{this.expandedGroupsFile}), (Throwable)e);
        }
        try {
            String[] firstLine = ((String)lines.get(0)).split(":");
            this.contentProvider.getPaletteView().setShowEmptyGroups(Boolean.valueOf(firstLine[1]));
            lines.remove(0);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            this.log.warn((Object)"Configuration of \"Unhide empty groups\" on Palette View could not be parsed correctly. Checkbox is unchecked.");
        }
        return lines;
    }

    public void storeConfigurationFiles() {
        this.writeCustomizedAssignmentToFile();
        this.writeCustomizedGroupsFile();
        this.writeExpandedGroupsFile();
    }

    private void writeCustomizedAssignmentToFile() {
        List<String> linesToWrite = this.getAssignmentFileLinesToWrite();
        try {
            Files.deleteIfExists(this.assignmentFile);
            Files.write(this.assignmentFile, linesToWrite, StandardOpenOption.CREATE);
            this.log.debug((Object)StringUtils.format((String)"Stored group assignments to file '%s'.", (Object[])new Object[]{this.assignmentFile}));
        }
        catch (IOException e) {
            this.log.error((Object)StringUtils.format((String)"Assignment of tools to groups could not be saved. Could not write: %s into profile dir: internal/%s", (Object[])new Object[]{this.assignmentFile.toString(), "paletteViewStorage"}), (Throwable)e);
        }
    }

    protected List<String> getAssignmentFileLinesToWrite() {
        Map<ToolIdentification, String[]> assignmentMap = this.assignment.getCustomizedAssignments();
        ArrayList<String> linesToWrite = new ArrayList<String>();
        String divider = ",";
        for (Map.Entry<ToolIdentification, String[]> entry : assignmentMap.entrySet()) {
            ToolIdentification toolIdentification = entry.getKey();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(String.valueOf(toolIdentification.getToolID()) + divider);
            stringBuilder.append(String.valueOf(toolIdentification.getToolName()) + divider);
            stringBuilder.append(toolIdentification.getType().toString());
            stringBuilder.append(";");
            String[] values = entry.getValue();
            stringBuilder.append(this.assignment.createQualifiedGroupName(values));
            linesToWrite.add(stringBuilder.toString());
            this.log.debug((Object)StringUtils.format((String)"Generated storage data for custom group assignment: '%s' (%s) -> '%s'", (Object[])new Object[]{toolIdentification.getToolName(), toolIdentification.getToolID(), this.assignment.createQualifiedGroupName(values)}));
        }
        return linesToWrite;
    }

    private void writeCustomizedGroupsFile() {
        PaletteTreeNode root = this.contentProvider.getRootNode();
        List groups = root.getAllSubGroups().stream().filter(GroupNode::isCustomGroup).collect(Collectors.toList());
        ArrayList<String> linesToWrite = new ArrayList<String>();
        for (GroupNode group : groups) {
            linesToWrite.add(group.getQualifiedGroupName().replace("\\/", "/"));
            this.log.debug((Object)StringUtils.format((String)"Generated storage data for custom group '%s'.", (Object[])new Object[]{group.getQualifiedGroupName()}));
        }
        try {
            Files.deleteIfExists(this.customizedGroupsFile);
            Files.write(this.customizedGroupsFile, linesToWrite, StandardOpenOption.CREATE);
            this.log.debug((Object)StringUtils.format((String)"Stored custom groups to file '%s'", (Object[])new Object[]{this.customizedGroupsFile}));
        }
        catch (IOException e) {
            this.log.error((Object)StringUtils.format((String)"Customized groups could not be saved. Could not write file: %s", (Object[])new Object[]{this.customizedGroupsFile.toString()}), (Throwable)e);
        }
    }

    private void writeExpandedGroupsFile() {
        ArrayList<String> linesToWrite = new ArrayList<String>();
        linesToWrite.add("Unhide empty groups checked:" + this.contentProvider.getPaletteView().isShowEmptyGroups());
        linesToWrite.addAll(this.contentProvider.getPaletteView().getExpandedGroupNameList());
        try {
            Files.deleteIfExists(this.expandedGroupsFile);
            Files.write(this.expandedGroupsFile, linesToWrite, StandardOpenOption.CREATE);
            this.log.debug((Object)StringUtils.format((String)"Stored expanded groups to file '%s'", (Object[])new Object[]{this.expandedGroupsFile}));
        }
        catch (IOException e) {
            this.log.error((Object)StringUtils.format((String)"Expanded groups could not be saved. Could not write file: %s", (Object[])new Object[]{this.expandedGroupsFile.toString()}), (Throwable)e);
        }
    }
}

