/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.views;

import java.util.Observable;
import java.util.Observer;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.BookmarkManager;
import org.eclipse.help.ui.internal.HelpUIResources;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.views.HyperlinkTreePart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class BookmarksPart
extends HyperlinkTreePart
implements Observer {
    private Action deleteAction;

    public BookmarksPart(Composite parent, FormToolkit toolkit, IToolBarManager tbm) {
        super(parent, toolkit, tbm);
        BaseHelpSystem.getBookmarkManager().addObserver((Observer)this);
    }

    @Override
    public void dispose() {
        BaseHelpSystem.getBookmarkManager().deleteObserver((Observer)this);
        super.dispose();
    }

    @Override
    protected void configureTreeViewer() {
        this.treeViewer.setContentProvider((IContentProvider)new BookmarksProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new BookmarksLabelProvider());
        this.treeViewer.setAutoExpandLevel(-1);
        this.deleteAction = new Action(""){

            public void run() {
                Object obj = BookmarksPart.this.treeViewer.getStructuredSelection().getFirstElement();
                if (obj instanceof BookmarkManager.Bookmark) {
                    BookmarkManager.Bookmark b = (BookmarkManager.Bookmark)obj;
                    BaseHelpSystem.getBookmarkManager().removeBookmark(b);
                }
            }
        };
        this.deleteAction.setText(Messages.BookmarksPart_delete);
        this.deleteAction.setEnabled(false);
    }

    @Override
    protected void handleSelectionChanged(IStructuredSelection sel) {
        Object obj = sel.getFirstElement();
        this.deleteAction.setEnabled(obj != null && obj instanceof BookmarkManager.Bookmark);
        super.handleSelectionChanged(sel);
    }

    @Override
    public boolean fillContextMenu(IMenuManager manager) {
        boolean value = super.fillContextMenu(manager);
        ITreeSelection selection = this.treeViewer.getStructuredSelection();
        boolean canDeleteAll = false;
        int count = BaseHelpSystem.getBookmarkManager().getBookmarks().length;
        boolean bl = canDeleteAll = count > 0;
        if (this.canDelete((IStructuredSelection)selection)) {
            if (value) {
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)this.deleteAction);
            value = true;
        }
        if (canDeleteAll) {
            Action action = new Action(""){

                public void run() {
                    BusyIndicator.showWhile((Display)BookmarksPart.this.getControl().getDisplay(), () -> BaseHelpSystem.getBookmarkManager().removeAllBookmarks());
                }
            };
            action.setText(Messages.BookmarksPart_deleteAll);
            manager.add((IAction)action);
            value = true;
        }
        if (value) {
            manager.add((IContributionItem)new Separator());
        }
        return value;
    }

    private boolean canDelete(IStructuredSelection ssel) {
        Object obj = ssel.getFirstElement();
        return obj instanceof BookmarkManager.Bookmark;
    }

    @Override
    protected void doOpen(Object obj) {
        IHelpResource res;
        if (obj instanceof BookmarkManager) {
            this.treeViewer.setExpandedState(obj, !this.treeViewer.getExpandedState(obj));
        } else if (obj instanceof IHelpResource && (res = (IHelpResource)obj).getHref() != null) {
            this.parent.showURL(res.getHref());
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.treeViewer.getControl().getDisplay().asyncExec(() -> this.asyncUpdate(o, arg));
    }

    private void asyncUpdate(Observable o, Object arg) {
        BookmarkManager.BookmarkEvent event = (BookmarkManager.BookmarkEvent)arg;
        switch (event.getType()) {
            case 2: {
                this.treeViewer.add((Object)BaseHelpSystem.getBookmarkManager(), (Object)event.getBookmark());
                break;
            }
            case 3: {
                this.treeViewer.remove((Object)event.getBookmark());
                break;
            }
            case 1: 
            case 5: {
                this.treeViewer.refresh();
            }
        }
    }

    @Override
    public IAction getGlobalAction(String id) {
        if (id.equals(ActionFactory.DELETE.getId())) {
            return this.deleteAction;
        }
        return super.getGlobalAction(id);
    }

    @Override
    protected boolean canAddBookmarks() {
        return false;
    }

    @Override
    public void toggleRoleFilter() {
    }

    @Override
    public void refilter() {
    }

    @Override
    public void saveState(IMemento memento) {
    }

    class BookmarksLabelProvider
    extends LabelProvider {
        BookmarksLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof BookmarkManager) {
                return Messages.BookmarksPart_savedTopics;
            }
            if (obj instanceof IHelpResource) {
                return ((IHelpResource)obj).getLabel();
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof BookmarkManager) {
                return HelpUIResources.getImage("obj16/bookmarks_view.gif");
            }
            if (obj instanceof IHelpResource) {
                return HelpUIResources.getImage("obj16/bookmark_obj.gif");
            }
            return super.getImage(obj);
        }
    }

    class BookmarksProvider
    implements ITreeContentProvider {
        BookmarksProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == BookmarksPart.this) {
                return new Object[]{BaseHelpSystem.getBookmarkManager()};
            }
            if (parentElement instanceof BookmarkManager) {
                return ((BookmarkManager)parentElement).getBookmarks();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

