/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.runtime.formatter.StrictAware;
import gherkin.formatter.Formatter;
import gherkin.formatter.NiceAppendable;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RerunFormatter
implements Formatter,
Reporter,
StrictAware {
    private final NiceAppendable out;
    private String featureLocation;
    private Scenario scenario;
    private boolean isTestFailed = false;
    private Map<String, ArrayList<Integer>> featureAndFailedLinesMapping = new HashMap<String, ArrayList<Integer>>();
    private boolean isStrict = false;

    public RerunFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
    }

    public void uri(String uri) {
        this.featureLocation = uri;
    }

    public void feature(Feature feature) {
    }

    public void background(Background background) {
    }

    public void scenario(Scenario scenario) {
        this.scenario = scenario;
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
    }

    public void examples(Examples examples) {
    }

    public void step(Step step) {
    }

    public void eof() {
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void done() {
        this.reportFailedScenarios();
    }

    private void reportFailedScenarios() {
        Set<Map.Entry<String, ArrayList<Integer>>> entries = this.featureAndFailedLinesMapping.entrySet();
        boolean firstFeature = true;
        for (Map.Entry<String, ArrayList<Integer>> entry : entries) {
            if (entry.getValue().isEmpty()) continue;
            if (!firstFeature) {
                this.out.append((CharSequence)" ");
            }
            this.out.append((CharSequence)entry.getKey());
            firstFeature = false;
            for (Integer line : entry.getValue()) {
                this.out.append((CharSequence)":").append((CharSequence)line.toString());
            }
        }
    }

    public void close() {
        this.out.close();
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.isTestFailed = false;
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        if (this.isTestFailed) {
            this.recordTestFailed();
        }
    }

    public void before(Match match, Result result) {
        if (this.isTestFailed(result)) {
            this.isTestFailed = true;
        }
    }

    public void result(Result result) {
        if (this.isTestFailed(result)) {
            this.isTestFailed = true;
        }
    }

    private boolean isTestFailed(Result result) {
        String status = result.getStatus();
        return "failed".equals(status) || this.isStrict && (Result.UNDEFINED.getStatus().equals(status) || "pending".equals(status));
    }

    private void recordTestFailed() {
        ArrayList<Integer> failedScenarios = this.featureAndFailedLinesMapping.get(this.featureLocation);
        if (failedScenarios == null) {
            failedScenarios = new ArrayList();
            this.featureAndFailedLinesMapping.put(this.featureLocation, failedScenarios);
        }
        failedScenarios.add(this.scenario.getLine());
    }

    public void after(Match match, Result result) {
        if (this.isTestFailed(result)) {
            this.isTestFailed = true;
        }
    }

    public void match(Match match) {
    }

    public void embedding(String mimeType, byte[] data) {
    }

    public void write(String text) {
    }

    @Override
    public void setStrict(boolean strict) {
        this.isStrict = strict;
    }
}

