/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.input.InputProvider;
import com.googlecode.lanterna.input.Key;
import com.googlecode.lanterna.input.KeyMappingProfile;
import com.googlecode.lanterna.terminal.AbstractTerminal;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import com.googlecode.lanterna.terminal.XTerm8bitIndexedColorUtils;
import com.googlecode.lanterna.terminal.swing.TerminalAppearance;
import com.googlecode.lanterna.terminal.swing.TerminalPalette;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class SwingTerminal
extends AbstractTerminal
implements InputProvider {
    private final TerminalRenderer terminalRenderer;
    private final Timer blinkTimer;
    private JFrame terminalFrame;
    private TerminalAppearance appearance;
    private TerminalCharacter[][] characterMap;
    private TerminalPosition textPosition;
    private TerminalCharacterColor currentForegroundColor;
    private TerminalCharacterColor currentBackgroundColor;
    private boolean currentlyBold;
    private boolean currentlyBlinking;
    private boolean currentlyUnderlined;
    private boolean blinkVisible;
    private boolean cursorVisible;
    private Queue<Key> keyQueue;
    private final Object resizeMutex;

    public SwingTerminal() {
        this(160, 40);
    }

    public SwingTerminal(TerminalSize terminalSize) {
        this(terminalSize.getColumns(), terminalSize.getRows());
    }

    public SwingTerminal(int widthInColumns, int heightInRows) {
        this(TerminalAppearance.DEFAULT_APPEARANCE, widthInColumns, heightInRows);
    }

    public SwingTerminal(TerminalAppearance appearance) {
        this(appearance, 160, 40);
    }

    public SwingTerminal(TerminalAppearance appearance, int widthInColumns, int heightInRows) {
        this.appearance = appearance;
        this.terminalRenderer = new TerminalRenderer();
        this.blinkTimer = new Timer(500, new BlinkAction());
        this.textPosition = new TerminalPosition(0, 0);
        this.characterMap = new TerminalCharacter[heightInRows][widthInColumns];
        this.currentForegroundColor = new CharacterANSIColor(Terminal.Color.WHITE);
        this.currentBackgroundColor = new CharacterANSIColor(Terminal.Color.BLACK);
        this.currentlyBold = false;
        this.currentlyBlinking = false;
        this.currentlyUnderlined = false;
        this.blinkVisible = false;
        this.cursorVisible = true;
        this.keyQueue = new ConcurrentLinkedQueue<Key>();
        this.resizeMutex = new Object();
        this.onResized(widthInColumns, heightInRows);
        this.clearScreen();
    }

    public JFrame getJFrame() {
        return this.terminalFrame;
    }

    @Override
    public void addInputProfile(KeyMappingProfile profile) {
    }

    @Override
    public void applyBackgroundColor(Terminal.Color color) {
        this.currentBackgroundColor = new CharacterANSIColor(color);
    }

    @Override
    public void applyBackgroundColor(int r, int g, int b) {
        this.currentBackgroundColor = new Character24bitColor(new Color(r, g, b));
    }

    @Override
    public void applyBackgroundColor(int index) {
        this.currentBackgroundColor = new CharacterIndexedColor(index);
    }

    @Override
    public void applyForegroundColor(Terminal.Color color) {
        this.currentForegroundColor = new CharacterANSIColor(color);
    }

    @Override
    public void applyForegroundColor(int r, int g, int b) {
        this.currentForegroundColor = new Character24bitColor(new Color(r, g, b));
    }

    @Override
    public void applyForegroundColor(int index) {
        this.currentForegroundColor = new CharacterIndexedColor(index);
    }

    @Override
    public void applySGR(Terminal.SGR ... options) {
        for (Terminal.SGR sgr : options) {
            if (sgr == Terminal.SGR.RESET_ALL) {
                this.currentlyBold = false;
                this.currentlyBlinking = false;
                this.currentlyUnderlined = false;
                this.currentForegroundColor = new CharacterANSIColor(Terminal.Color.DEFAULT);
                this.currentBackgroundColor = new CharacterANSIColor(Terminal.Color.BLACK);
                continue;
            }
            if (sgr == Terminal.SGR.ENTER_BOLD) {
                this.currentlyBold = true;
                continue;
            }
            if (sgr == Terminal.SGR.EXIT_BOLD) {
                this.currentlyBold = false;
                continue;
            }
            if (sgr == Terminal.SGR.ENTER_BLINK) {
                this.currentlyBlinking = true;
                continue;
            }
            if (sgr == Terminal.SGR.EXIT_BLINK) {
                this.currentlyBlinking = false;
                continue;
            }
            if (sgr == Terminal.SGR.ENTER_UNDERLINE) {
                this.currentlyUnderlined = true;
                continue;
            }
            if (sgr != Terminal.SGR.EXIT_UNDERLINE) continue;
            this.currentlyUnderlined = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearScreen() {
        Object object = this.resizeMutex;
        synchronized (object) {
            for (int y = 0; y < this.size().getRows(); ++y) {
                for (int x = 0; x < this.size().getColumns(); ++x) {
                    this.characterMap[y][x] = new TerminalCharacter(' ', new CharacterANSIColor(Terminal.Color.DEFAULT), new CharacterANSIColor(Terminal.Color.BLACK), false, false, false);
                }
            }
            this.moveCursor(0, 0);
        }
    }

    @Override
    public void enterPrivateMode() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingTerminal.this.terminalFrame = new JFrame("Terminal");
                SwingTerminal.this.terminalFrame.addComponentListener(new FrameResizeListener());
                SwingTerminal.this.terminalFrame.getContentPane().setLayout(new BorderLayout());
                SwingTerminal.this.terminalFrame.getContentPane().add((Component)SwingTerminal.this.terminalRenderer, "Center");
                SwingTerminal.this.terminalFrame.addKeyListener(new KeyCapturer());
                SwingTerminal.this.terminalFrame.pack();
                SwingTerminal.this.terminalFrame.setDefaultCloseOperation(0);
                SwingTerminal.this.terminalFrame.setLocationByPlatform(true);
                SwingTerminal.this.terminalFrame.setVisible(true);
                SwingTerminal.this.terminalFrame.setFocusTraversalKeysEnabled(false);
                SwingTerminal.this.terminalFrame.pack();
                SwingTerminal.this.blinkTimer.start();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected " + e.getClass().getSimpleName() + " while creating SwingTerminal JFrame", e);
            }
        }
    }

    @Override
    public void exitPrivateMode() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SwingTerminal.this.terminalFrame == null) {
                    return;
                }
                SwingTerminal.this.blinkTimer.stop();
                SwingTerminal.this.terminalFrame.setVisible(false);
                SwingTerminal.this.terminalFrame.dispose();
                SwingTerminal.this.terminalFrame = null;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                throw new RuntimeException("Unexpected " + e.getClass().getSimpleName() + " while disposing SwingTerminal JFrame", e);
            }
        }
    }

    @Override
    public void moveCursor(int x, int y) {
        if (x < 0) {
            x = 0;
        }
        if (x >= this.size().getColumns()) {
            x = this.size().getColumns() - 1;
        }
        if (y < 0) {
            y = 0;
        }
        if (y >= this.size().getRows()) {
            y = this.size().getRows() - 1;
        }
        this.textPosition.setColumn(x);
        this.textPosition.setRow(y);
        this.refreshScreen();
    }

    @Override
    public void setCursorVisible(boolean visible) {
        this.cursorVisible = visible;
        this.refreshScreen();
    }

    @Override
    public synchronized void putCharacter(char c) {
        this.characterMap[this.textPosition.getRow()][this.textPosition.getColumn()] = new TerminalCharacter(c, this.currentForegroundColor, this.currentBackgroundColor, this.currentlyBold, this.currentlyBlinking, this.currentlyUnderlined);
        if (this.textPosition.getColumn() == this.size().getColumns() - 1 && this.textPosition.getRow() == this.size().getRows() - 1) {
            this.moveCursor(0, this.textPosition.getRow());
        }
        if (this.textPosition.getColumn() == this.size().getColumns() - 1) {
            this.moveCursor(0, this.textPosition.getRow() + 1);
        } else {
            this.moveCursor(this.textPosition.getColumn() + 1, this.textPosition.getRow());
        }
    }

    @Override
    public TerminalSize queryTerminalSize() {
        return this.getTerminalSize();
    }

    @Override
    public TerminalSize getTerminalSize() {
        return this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resize(int newSizeColumns, int newSizeRows) {
        TerminalCharacter[][] newCharacterMap = new TerminalCharacter[newSizeRows][newSizeColumns];
        for (int y = 0; y < newSizeRows; ++y) {
            for (int x = 0; x < newSizeColumns; ++x) {
                newCharacterMap[y][x] = new TerminalCharacter(' ', new CharacterANSIColor(Terminal.Color.WHITE), new CharacterANSIColor(Terminal.Color.BLACK), false, false, false);
            }
        }
        Object object = this.resizeMutex;
        synchronized (object) {
            for (int y = 0; y < this.size().getRows() && y < newSizeRows; ++y) {
                for (int x = 0; x < this.size().getColumns() && x < newSizeColumns; ++x) {
                    newCharacterMap[y][x] = this.characterMap[y][x];
                }
            }
            this.characterMap = newCharacterMap;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SwingTerminal.this.terminalFrame != null) {
                        SwingTerminal.this.terminalFrame.pack();
                    }
                }
            });
            this.onResized(newSizeColumns, newSizeRows);
        }
    }

    @Override
    public Key readInput() {
        return this.keyQueue.poll();
    }

    @Override
    public void flush() {
    }

    public void setTerminalPalette(TerminalPalette palette) {
        this.appearance = this.appearance.withPalette(palette);
        this.refreshScreen();
    }

    private void refreshScreen() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingTerminal.this.terminalRenderer.repaint();
            }
        });
    }

    private TerminalSize size() {
        return this.getLastKnownSize();
    }

    private static class Character24bitColor
    extends TerminalCharacterColor {
        private final Color c;

        Character24bitColor(Color c) {
            this.c = c;
        }

        @Override
        public Color getColor(boolean brightHint, boolean foregroundHint) {
            return this.c;
        }
    }

    private class CharacterIndexedColor
    extends TerminalCharacterColor {
        private final int index;

        CharacterIndexedColor(int index) {
            this.index = index;
        }

        @Override
        public Color getColor(boolean brightHint, boolean foregroundHint) {
            return XTerm8bitIndexedColorUtils.getAWTColor(this.index, SwingTerminal.this.appearance.getColorPalette());
        }
    }

    private class CharacterANSIColor
    extends TerminalCharacterColor {
        private final Terminal.Color color;

        CharacterANSIColor(Terminal.Color color) {
            this.color = color;
        }

        @Override
        public Color getColor(boolean brightHint, boolean foregroundHint) {
            switch (this.color) {
                case BLACK: {
                    if (brightHint) {
                        return SwingTerminal.this.appearance.getColorPalette().getBrightBlack();
                    }
                    return SwingTerminal.this.appearance.getColorPalette().getNormalBlack();
                }
                case BLUE: {
                    if (brightHint) {
                        return SwingTerminal.this.appearance.getColorPalette().getBrightBlue();
                    }
                    return SwingTerminal.this.appearance.getColorPalette().getNormalBlue();
                }
                case CYAN: {
                    if (brightHint) {
                        return SwingTerminal.this.appearance.getColorPalette().getBrightCyan();
                    }
                    return SwingTerminal.this.appearance.getColorPalette().getNormalCyan();
                }
                case DEFAULT: {
                    if (foregroundHint) {
                        if (brightHint) {
                            return SwingTerminal.this.appearance.getColorPalette().getDefaultBrightColor();
                        }
                        return SwingTerminal.this.appearance.getColorPalette().getDefaultColor();
                    }
                    return SwingTerminal.this.appearance.getColorPalette().getNormalBlack();
                }
                case GREEN: {
                    if (brightHint) {
                        return SwingTerminal.this.appearance.getColorPalette().getBrightGreen();
                    }
                    return SwingTerminal.this.appearance.getColorPalette().getNormalGreen();
                }
                case MAGENTA: {
                    if (brightHint) {
                        return SwingTerminal.this.appearance.getColorPalette().getBrightMagenta();
                    }
                    return SwingTerminal.this.appearance.getColorPalette().getNormalMagenta();
                }
                case RED: {
                    if (brightHint) {
                        return SwingTerminal.this.appearance.getColorPalette().getBrightRed();
                    }
                    return SwingTerminal.this.appearance.getColorPalette().getNormalRed();
                }
                case WHITE: {
                    if (brightHint) {
                        return SwingTerminal.this.appearance.getColorPalette().getBrightWhite();
                    }
                    return SwingTerminal.this.appearance.getColorPalette().getNormalWhite();
                }
                case YELLOW: {
                    if (brightHint) {
                        return SwingTerminal.this.appearance.getColorPalette().getBrightYellow();
                    }
                    return SwingTerminal.this.appearance.getColorPalette().getNormalYellow();
                }
            }
            return Color.PINK;
        }
    }

    private static abstract class TerminalCharacterColor {
        private TerminalCharacterColor() {
        }

        public abstract Color getColor(boolean var1, boolean var2);
    }

    private static class TerminalCharacter {
        private final char character;
        private final TerminalCharacterColor foreground;
        private final TerminalCharacterColor background;
        private final boolean bold;
        private final boolean blinking;
        private final boolean underlined;

        TerminalCharacter(char character, TerminalCharacterColor foreground, TerminalCharacterColor background, boolean bold, boolean blinking, boolean underlined) {
            this.character = character;
            this.foreground = foreground;
            this.background = background;
            this.bold = bold;
            this.blinking = blinking;
            this.underlined = underlined;
        }

        public boolean isBold() {
            return this.bold;
        }

        public boolean isBlinking() {
            return this.blinking;
        }

        public boolean isUnderlined() {
            return this.underlined;
        }

        private Color getForegroundAsAWTColor(boolean useBrightOnBold) {
            return this.foreground.getColor(this.isBold() && useBrightOnBold, true);
        }

        private Color getBackgroundAsAWTColor() {
            return this.background.getColor(false, false);
        }

        public String toString() {
            return Character.toString(this.character);
        }
    }

    private class TerminalRenderer
    extends JComponent {
        @Override
        public Dimension getPreferredSize() {
            FontMetrics fontMetrics = this.getGraphics().getFontMetrics(SwingTerminal.this.appearance.getNormalTextFont());
            int screenWidth = SwingTerminal.this.size().getColumns() * fontMetrics.charWidth(' ');
            int screenHeight = SwingTerminal.this.size().getRows() * fontMetrics.getHeight();
            return new Dimension(screenWidth, screenHeight);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D graphics2D = (Graphics2D)g.create();
            graphics2D.setFont(SwingTerminal.this.appearance.getNormalTextFont());
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = this.getGraphics().getFontMetrics(SwingTerminal.this.appearance.getNormalTextFont());
            int charWidth = fontMetrics.charWidth(' ');
            int charHeight = fontMetrics.getHeight();
            for (int row = 0; row < SwingTerminal.this.size().getRows(); ++row) {
                for (int col = 0; col < SwingTerminal.this.size().getColumns(); ++col) {
                    boolean needToResetFont = false;
                    TerminalCharacter character = SwingTerminal.this.characterMap[row][col];
                    if (SwingTerminal.this.cursorVisible && row == SwingTerminal.this.textPosition.getRow() && col == SwingTerminal.this.textPosition.getColumn()) {
                        graphics2D.setColor(character.getForegroundAsAWTColor(SwingTerminal.this.appearance.useBrightColorsOnBold()));
                    } else {
                        graphics2D.setColor(character.getBackgroundAsAWTColor());
                    }
                    graphics2D.fillRect(col * charWidth, row * charHeight, charWidth, charHeight);
                    if (SwingTerminal.this.cursorVisible && row == SwingTerminal.this.textPosition.getRow() && col == SwingTerminal.this.textPosition.getColumn() || character.isBlinking() && !SwingTerminal.this.blinkVisible) {
                        graphics2D.setColor(character.getBackgroundAsAWTColor());
                    } else {
                        graphics2D.setColor(character.getForegroundAsAWTColor(SwingTerminal.this.appearance.useBrightColorsOnBold()));
                    }
                    if (character.isBold()) {
                        graphics2D.setFont(SwingTerminal.this.appearance.getBoldTextFont());
                        needToResetFont = true;
                    }
                    if (character.isUnderlined()) {
                        graphics2D.drawLine(col * charWidth, (row + 1) * charHeight - 1, (col + 1) * charWidth, (row + 1) * charHeight - 1);
                    }
                    if (!graphics2D.getFont().canDisplay(character.character)) {
                        graphics2D.setFont(SwingTerminal.this.appearance.getCJKFont());
                        needToResetFont = true;
                    }
                    graphics2D.drawString(character.toString(), col * charWidth, (row + 1) * charHeight - fontMetrics.getDescent());
                    if (!needToResetFont) continue;
                    graphics2D.setFont(SwingTerminal.this.appearance.getNormalTextFont());
                }
            }
            graphics2D.dispose();
        }
    }

    private class FrameResizeListener
    extends ComponentAdapter {
        private int lastWidth = -1;
        private int lastHeight = -1;

        private FrameResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (e.getComponent() == null || !(e.getComponent() instanceof JFrame)) {
                return;
            }
            JFrame frame = (JFrame)e.getComponent();
            Container contentPane = frame.getContentPane();
            int newWidth = contentPane.getWidth();
            int newHeight = contentPane.getHeight();
            FontMetrics fontMetrics = frame.getGraphics().getFontMetrics(SwingTerminal.this.appearance.getNormalTextFont());
            int consoleWidth = newWidth / fontMetrics.charWidth(' ');
            int consoleHeight = newHeight / fontMetrics.getHeight();
            if (consoleWidth == this.lastWidth && consoleHeight == this.lastHeight) {
                return;
            }
            this.lastWidth = consoleWidth;
            this.lastHeight = consoleHeight;
            SwingTerminal.this.resize(consoleWidth, consoleHeight);
        }
    }

    private class KeyCapturer
    extends KeyAdapter {
        private Set<Character> typedIgnore = new HashSet<Character>(Arrays.asList(Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\b'), Character.valueOf('\u001b')));

        private KeyCapturer() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            boolean ctrlDown;
            char character = e.getKeyChar();
            boolean altDown = (e.getModifiersEx() & 0x200) != 0;
            boolean bl = ctrlDown = (e.getModifiersEx() & 0x80) != 0;
            if (!this.typedIgnore.contains(Character.valueOf(character))) {
                if (ctrlDown) {
                    character = (char)(96 + character);
                }
                SwingTerminal.this.keyQueue.add(new Key(character, ctrlDown, altDown));
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.Enter));
            } else if (e.getKeyCode() == 27) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.Escape));
            } else if (e.getKeyCode() == 8) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.Backspace));
            } else if (e.getKeyCode() == 37) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.ArrowLeft));
            } else if (e.getKeyCode() == 39) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.ArrowRight));
            } else if (e.getKeyCode() == 38) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.ArrowUp));
            } else if (e.getKeyCode() == 40) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.ArrowDown));
            } else if (e.getKeyCode() == 155) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.Insert));
            } else if (e.getKeyCode() == 127) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.Delete));
            } else if (e.getKeyCode() == 36) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.Home));
            } else if (e.getKeyCode() == 35) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.End));
            } else if (e.getKeyCode() == 33) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.PageUp));
            } else if (e.getKeyCode() == 34) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.PageDown));
            } else if (e.getKeyCode() == 112) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F1));
            } else if (e.getKeyCode() == 113) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F2));
            } else if (e.getKeyCode() == 114) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F3));
            } else if (e.getKeyCode() == 115) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F4));
            } else if (e.getKeyCode() == 116) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F5));
            } else if (e.getKeyCode() == 117) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F6));
            } else if (e.getKeyCode() == 118) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F7));
            } else if (e.getKeyCode() == 119) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F8));
            } else if (e.getKeyCode() == 120) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F9));
            } else if (e.getKeyCode() == 121) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F10));
            } else if (e.getKeyCode() == 122) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F11));
            } else if (e.getKeyCode() == 123) {
                SwingTerminal.this.keyQueue.add(new Key(Key.Kind.F12));
            } else if (e.getKeyCode() == 9) {
                if (e.isShiftDown()) {
                    SwingTerminal.this.keyQueue.add(new Key(Key.Kind.ReverseTab));
                } else {
                    SwingTerminal.this.keyQueue.add(new Key(Key.Kind.Tab));
                }
            } else {
                boolean ctrlDown;
                boolean altDown = (e.getModifiersEx() & 0x200) != 0;
                boolean bl = ctrlDown = (e.getModifiersEx() & 0x80) != 0;
                if (altDown && ctrlDown && e.getKeyCode() >= 65 && e.getKeyCode() <= 90) {
                    char asLowerCase = Character.toLowerCase((char)e.getKeyCode());
                    SwingTerminal.this.keyQueue.add(new Key(asLowerCase, true, true));
                }
            }
        }
    }

    private class BlinkAction
    implements ActionListener {
        private BlinkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingTerminal.this.blinkVisible = !SwingTerminal.this.blinkVisible;
            SwingTerminal.this.terminalRenderer.repaint();
        }
    }
}

