/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.common;

import de.rcenvironment.components.parametricstudy.common.Dimension;
import de.rcenvironment.components.parametricstudy.common.Measure;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class StudyStructure
implements Serializable {
    private static final long serialVersionUID = 2860262690175198142L;
    private final Set<Dimension> dimensions = new HashSet<Dimension>();
    private final Set<Measure> measures = new HashSet<Measure>();

    public Collection<Dimension> getDimensions() {
        return Collections.unmodifiableCollection(this.dimensions);
    }

    public Dimension getDimension(String name) {
        for (Dimension dimension : this.dimensions) {
            if (!name.equals(dimension.getName())) continue;
            return dimension;
        }
        return null;
    }

    public Collection<Measure> getMeasures() {
        return Collections.unmodifiableCollection(this.measures);
    }

    public Measure getMeasure(String name) {
        for (Measure measure : this.measures) {
            if (!name.equals(measure.getName())) continue;
            return measure;
        }
        return null;
    }

    public void addDimension(Dimension dimension) {
        this.dimensions.add(dimension);
    }

    public void addMeasure(Measure measure) {
        this.measures.add(measure);
    }
}

