/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.sshconnection.internal;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SshConnectionSetupCommandPlugin
implements CommandPlugin {
    private static final String CMD_SSH = "ssh";
    private SshConnectionService sshConnectionService;

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken(CMD_SSH);
        String subCmd = context.consumeNextToken();
        if (subCmd == null) {
            this.performList(context);
        } else {
            List parameters = context.consumeRemainingTokens();
            if ("add".equals(subCmd)) {
                this.performAdd(context, parameters);
            } else if ("list".equals(subCmd)) {
                this.performList(context);
            } else if ("start".equals(subCmd)) {
                this.performStart(context, parameters);
            } else if ("stop".equals(subCmd)) {
                this.performStop(context, parameters);
            } else {
                throw CommandException.unknownCommand((CommandContext)context);
            }
        }
    }

    private void performAdd(CommandContext context, List<String> parameters) throws CommandException {
        String keyfileLocation;
        String username;
        int port;
        String host;
        if (parameters.size() < 5 || parameters.size() > 5) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        String connectionName = parameters.get(0);
        SshConnectionContext contextSSH = new SshConnectionContext(null, connectionName, null, host = parameters.get(1), port = Integer.parseInt(parameters.get(2)), username = parameters.get(3), keyfileLocation = parameters.get(4), false, false, false, false);
        if (this.sshConnectionService.sshConnectionAlreadyExists(contextSSH)) {
            context.println((Object)StringUtils.format((String)"Connection setup to host '%s:%d' already exists.", (Object[])new Object[]{contextSSH.getDestinationHost(), contextSSH.getPort()}));
            return;
        }
        ConcurrencyUtils.getAsyncTaskService().execute("Create new SSH Connection.", () -> {
            String id = this.sshConnectionService.addSshConnection(contextSSH);
            context.println((Object)("Added SSH connection setup, created id " + id));
        });
    }

    private void performList(CommandContext context) {
        Collection<SshConnectionSetup> setups = this.sshConnectionService.getAllSshConnectionSetups();
        for (SshConnectionSetup setup : setups) {
            context.println((Object)StringUtils.format((String)"%s: %s:%s username: %s, keyfile: %s (id: %s)", (Object[])new Object[]{setup.getDisplayName(), setup.getHost(), setup.getPort(), setup.getUsername(), setup.getKeyfileLocation(), setup.getId()}));
        }
    }

    private void performStart(CommandContext context, List<String> parameters) throws CommandException {
        if (parameters.size() < 1) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        String connectionId = parameters.get(0);
        ConcurrencyUtils.getAsyncTaskService().execute("Start SSH Connection.", () -> this.sshConnectionService.connectSession(connectionId));
    }

    private void performStop(CommandContext context, List<String> parameters) throws CommandException {
        if (parameters.size() < 1) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        String connectionId = parameters.get(0);
        this.sshConnectionService.disconnectSession(connectionId);
    }

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(CMD_SSH, "", false, "short form of \"ssh list\"", new String[0]));
        contributions.add(new CommandDescription("ssh add", "<displayName> <host> <port> <username> <keyfileLocation>", false, "add a new ssh connection", new String[]{"(Example: TODO)"}));
        contributions.add(new CommandDescription("ssh list", "", false, "lists all ssh connections, including ids and connection states", new String[0]));
        contributions.add(new CommandDescription("ssh start", "<id>", false, "starts/connects an ssh connection (use \" ssh list\" to get the id)", new String[0]));
        contributions.add(new CommandDescription("ssh stop", "<id>", false, "stops/disconnects an ssh connection (use \" ssh list\" to get the id)", new String[0]));
        return contributions;
    }

    public void bindSshConnectionSetupService(SshConnectionService newInstance) {
        this.sshConnectionService = newInstance;
    }
}

