/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.rpc.spi.LocalServiceResolver;
import de.rcenvironment.core.utils.common.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OSGiLocalServiceResolver
implements LocalServiceResolver {
    private static final int SINGLETON_SERVICE_RESOLUTION_NUM_ATTEMPTS = 10;
    private static final int SERVICE_RESOLUTION_RETRY_DELAY_MSEC = 1000;
    private static final String ERROR_GET_SERVICE = "Failed to acquire OSGi service ";
    private final Log log = LogFactory.getLog(this.getClass());
    private BundleContext bundleContext;
    private final int retryCount;

    public OSGiLocalServiceResolver() {
        this.retryCount = 10;
    }

    public OSGiLocalServiceResolver(int retryCount) {
        this.retryCount = retryCount;
    }

    public void activate(BundleContext context) {
        this.bundleContext = context;
    }

    @Override
    public Object getLocalService(String serviceName) {
        return this.getLocalSingletonService(serviceName, this.retryCount, 1000);
    }

    protected Object getLocalSingletonService(String service, int numAttempts, int delayBetweenAttemptsMsec) {
        ServiceReference[] serviceReferences = null;
        int attempt = 1;
        while (attempt <= numAttempts) {
            try {
                serviceReferences = this.bundleContext.getServiceReferences(service, null);
            }
            catch (InvalidSyntaxException e) {
                this.log.error((Object)(ERROR_GET_SERVICE + service), (Throwable)e);
                return null;
            }
            if (serviceReferences != null && serviceReferences.length > 0) {
                if (serviceReferences.length > 1) {
                    this.log.error((Object)("More than one OSGi service reference matched (request: service=" + service + ")"));
                    return null;
                }
                Object serviceObject = this.bundleContext.getService(serviceReferences[0]);
                if (serviceObject != null) {
                    return serviceObject;
                }
            }
            if (++attempt > numAttempts) continue;
            this.log.warn((Object)StringUtils.format((String)"Failed to acquire OSGi service on attempt #%d; it may not have started yet, retrying after %d msec (request: service=%s)", (Object[])new Object[]{attempt - 1, delayBetweenAttemptsMsec, service}));
            try {
                Thread.sleep(delayBetweenAttemptsMsec);
            }
            catch (InterruptedException interruptedException) {
                this.log.error((Object)"Interrupted while waiting for retry");
                return null;
            }
        }
        this.log.error((Object)(ERROR_GET_SERVICE + service + " - service not available; made " + numAttempts + " attempt(s)"));
        return null;
    }
}

