/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.routing.internal;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.model.internal.NetworkGraphImpl;
import de.rcenvironment.core.communication.routing.InstanceRestartAndPresenceService;
import de.rcenvironment.core.communication.routing.InstanceSessionNetworkStatus;
import de.rcenvironment.core.communication.spi.NetworkTopologyChangeListener;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import de.rcenvironment.toolkit.modules.concurrency.api.TaskDescription;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

class NetworkTopologyChangeTracker
implements InstanceRestartAndPresenceService {
    private Set<InstanceNodeSessionId> lastReachableNodes = Collections.unmodifiableSet(new HashSet());
    private final AsyncOrderedCallbackManager<NetworkTopologyChangeListener> callbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_CANCEL_LISTENER);
    private NetworkGraphImpl cachedReachableNetworkGraph;

    NetworkTopologyChangeTracker() {
    }

    public synchronized boolean updateReachableNetwork(final NetworkGraphImpl reachableNetworkGraph) {
        Set<InstanceNodeSessionId> reachableNodeIds = reachableNetworkGraph.getNodeIds();
        HashSet<InstanceNodeSessionId> addedNodes = new HashSet<InstanceNodeSessionId>(reachableNodeIds);
        addedNodes.removeAll(this.lastReachableNodes);
        HashSet<InstanceNodeSessionId> removedNodes = new HashSet<InstanceNodeSessionId>(this.lastReachableNodes);
        removedNodes.removeAll(reachableNodeIds);
        this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<NetworkTopologyChangeListener>(){

            @TaskDescription(value="Communication Layer: Topology change callback (1p)")
            public void performCallback(NetworkTopologyChangeListener listener) {
                listener.onReachableNetworkChanged(reachableNetworkGraph);
            }
        });
        this.cachedReachableNetworkGraph = reachableNetworkGraph;
        if (!addedNodes.isEmpty() || !removedNodes.isEmpty()) {
            final Set<InstanceNodeSessionId> newReachableNodesCopy = Collections.unmodifiableSet(reachableNodeIds);
            final Set<InstanceNodeSessionId> addedNodesCopy = Collections.unmodifiableSet(addedNodes);
            final Set<InstanceNodeSessionId> removedNodesCopy = Collections.unmodifiableSet(removedNodes);
            this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<NetworkTopologyChangeListener>(){

                @TaskDescription(value="Communication Layer: Topology change callback (3p)")
                public void performCallback(NetworkTopologyChangeListener listener) {
                    listener.onReachableNodesChanged(newReachableNodesCopy, addedNodesCopy, removedNodesCopy);
                }
            });
            this.lastReachableNodes = newReachableNodesCopy;
            this.sendLegacyListenerNotification();
            return true;
        }
        this.sendLegacyListenerNotification();
        return false;
    }

    public synchronized Set<InstanceNodeSessionId> getCurrentReachableNodes() {
        return this.lastReachableNodes;
    }

    @Override
    public InstanceSessionNetworkStatus queryInstanceSessionNetworkStatus(InstanceNodeSessionId lookupId) {
        InstanceNodeSessionId firstMatch = null;
        for (InstanceNodeSessionId iterated : this.lastReachableNodes) {
            if (!iterated.isSameInstanceNodeAs(lookupId)) continue;
            if (firstMatch == null) {
                firstMatch = iterated;
                continue;
            }
            InstanceNodeSessionId otherMatch = firstMatch.isSameInstanceNodeSessionAs(lookupId) ? iterated : firstMatch;
            return new InstanceSessionNetworkStatus(lookupId, InstanceSessionNetworkStatus.State.ID_COLLISION, otherMatch);
        }
        if (firstMatch != null) {
            if (firstMatch.isSameInstanceNodeSessionAs(lookupId)) {
                return new InstanceSessionNetworkStatus(lookupId, InstanceSessionNetworkStatus.State.PRESENT, null);
            }
            return new InstanceSessionNetworkStatus(lookupId, InstanceSessionNetworkStatus.State.PRESENT_WITH_DIFFERENT_SESSION, firstMatch);
        }
        return new InstanceSessionNetworkStatus(lookupId, InstanceSessionNetworkStatus.State.NOT_PRESENT, null);
    }

    public synchronized void addListener(NetworkTopologyChangeListener listener) {
        final Set<InstanceNodeSessionId> lastReachableNodesCopy = this.lastReachableNodes;
        final NetworkGraphImpl networkGraphCopy = this.cachedReachableNetworkGraph;
        this.callbackManager.addListenerAndEnqueueCallback((Object)listener, (AsyncCallback)new AsyncCallback<NetworkTopologyChangeListener>(){

            public void performCallback(NetworkTopologyChangeListener listener) {
                listener.onReachableNodesChanged(lastReachableNodesCopy, lastReachableNodesCopy, new HashSet<InstanceNodeSessionId>());
                if (networkGraphCopy != null) {
                    listener.onReachableNetworkChanged(networkGraphCopy);
                } else {
                    LogFactory.getLog(this.getClass()).debug((Object)("Topology listener " + listener.getClass().getName() + " registered before an initial network graph was set; skipping initial callback"));
                }
            }
        });
    }

    public synchronized void removeListener(NetworkTopologyChangeListener listener) {
        this.callbackManager.removeListener((Object)listener);
    }

    private void sendLegacyListenerNotification() {
        this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<NetworkTopologyChangeListener>(){

            @TaskDescription(value="Communication Layer: Topology change callback (0p)")
            public void performCallback(NetworkTopologyChangeListener listener) {
                listener.onNetworkTopologyChanged();
            }
        });
    }
}

