/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.internal;

import de.rcenvironment.core.communication.uplink.network.api.MessageBlockPriority;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class UplinkProtocolConfiguration {
    private static final UplinkProtocolConfiguration DEFAULT_CONFIGURATION;
    private static volatile UplinkProtocolConfiguration sharedCurrentConfiguration;
    private static final int DEFAULT_MAX_BUFFERED_MESSAGES_FOR_PRIORITY_HIGH = 10;
    private static final int DEFAULT_MAX_BUFFERED_MESSAGES_FOR_PRIORITY_DEFAULT = 100;
    private static final int DEFAULT_MAX_BUFFERED_MESSAGES_FOR_PRIORITY_LOW_BLACK_BOX_FORWARDING = 20;
    private static final int DEFAULT_MAX_BUFFERED_MESSAGES_FOR_PRIORITY_LOW_NON_BLOCKABLE = 50;
    private static final int DEFAULT_MAX_BUFFERED_MESSAGES_FOR_PRIORITY_LOW_BLOCKABLE = 10;
    private static final int DEFAULT_MAX_BUFFERED_INCOMING_MESSAGES_PER_SESSION = 3;
    private static final int DEFAULT_HANDSHAKE_RESPONSE_TIMEOUT_MSEC = 3000;
    private static final int DEFAULT_HEARTBEAT_SERVER_TO_CLIENT_SEND_INTERVAL_AVERAGE_MSEC = 30000;
    private static final int DEFAULT_HEARTBEAT_SERVER_TO_CLIENT_SEND_INTERVAL_SPREAD_MSEC = 2000;
    private static final int DEFAULT_HEARTBEAT_RESPONSE_TIME_WARNING_THRESHOLD_MSEC = 5000;
    private static final int DEFAULT_CHANNEL_REQUEST_ROUNDTRIP_TIMEOUT = 30000;
    private static final int DEFAULT_DOCUMENTATION_REQUEST_ROUNDTRIP_TIMEOUT = 30000;
    private int maxBufferedIncomingMessagesPerSession = 3;
    private int handshakeResponseTimeout = 3000;
    private int heartbeatServerToClientSendIntervalAverage = 30000;
    private int heartbeatServerToClientSendIntervalSpread = 2000;
    private int heartbeatResponseTimeWarningThreshold = 5000;
    private Map<MessageBlockPriority, Integer> maxBufferedMessagesPerPriority = new HashMap<MessageBlockPriority, Integer>();

    static {
        sharedCurrentConfiguration = DEFAULT_CONFIGURATION = UplinkProtocolConfiguration.newBuilder().build();
    }

    public static UplinkProtocolConfiguration getCurrent() {
        return sharedCurrentConfiguration;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static void override(Builder builder) {
        sharedCurrentConfiguration = builder.build();
    }

    public static void resetToDefaults() {
        sharedCurrentConfiguration = DEFAULT_CONFIGURATION;
    }

    public int getHandshakeResponseTimeout() {
        return this.handshakeResponseTimeout;
    }

    public int getHeartbeatServerToClientSendIntervalAverage() {
        return this.heartbeatServerToClientSendIntervalAverage;
    }

    public int getHeartbeatServerToClientSendIntervalSpread() {
        return this.heartbeatServerToClientSendIntervalSpread;
    }

    public int getHeartbeatResponseTimeWarningThreshold() {
        return this.heartbeatResponseTimeWarningThreshold;
    }

    public int getChannelRequestRoundtripTimeout() {
        return 30000;
    }

    public int getToolDocumentationRequestRoundtripTimeout() {
        return 30000;
    }

    public Map<MessageBlockPriority, Integer> getMaxBufferedOutgoingMessagesPerSessionAndPriority() {
        return this.maxBufferedMessagesPerPriority;
    }

    public int getMaxBufferedIncomingMessagesPerSession() {
        return this.maxBufferedIncomingMessagesPerSession;
    }

    public static final class Builder {
        private UplinkProtocolConfiguration instance = new UplinkProtocolConfiguration();

        private Builder() {
            this.setMaxBufferedMessagesForPriority(MessageBlockPriority.HIGH, 10);
            this.setMaxBufferedMessagesForPriority(MessageBlockPriority.DEFAULT, 100);
            this.setMaxBufferedMessagesForPriority(MessageBlockPriority.FORWARDING, 20);
            this.setMaxBufferedMessagesForPriority(MessageBlockPriority.LOW_NON_BLOCKABLE, 50);
            this.setMaxBufferedMessagesForPriority(MessageBlockPriority.LOW_BLOCKABLE, 10);
        }

        public UplinkProtocolConfiguration build() {
            UplinkProtocolConfiguration temp = this.instance;
            this.instance = null;
            temp.maxBufferedMessagesPerPriority = Collections.unmodifiableMap(temp.maxBufferedMessagesPerPriority);
            return temp;
        }

        public Builder setHandshakeResponseTimeout(int handshakeResponseTimeout) {
            this.instance.handshakeResponseTimeout = handshakeResponseTimeout;
            return this;
        }

        public Builder setHeartbeatServerToClientSendIntervalAverage(int heartbeatServerToClientSendIntervalAverage) {
            this.instance.heartbeatServerToClientSendIntervalAverage = heartbeatServerToClientSendIntervalAverage;
            return this;
        }

        public Builder setHeartbeatServerToClientSendIntervalSpread(int heartbeatServerToClientSendIntervalSpread) {
            this.instance.heartbeatServerToClientSendIntervalSpread = heartbeatServerToClientSendIntervalSpread;
            return this;
        }

        public Builder setHeartbeatResponseTimeWarningThreshold(int heartbeatResponseTimeWarningThreshold) {
            this.instance.heartbeatResponseTimeWarningThreshold = heartbeatResponseTimeWarningThreshold;
            return this;
        }

        public Builder setMaxBufferedMessagesForPriority(MessageBlockPriority priority, int maxMessages) {
            this.instance.maxBufferedMessagesPerPriority.put(priority, maxMessages);
            return this;
        }

        public Builder setMaxBufferedIncomingMessagesPerSession(int maxBufferedIncomingMessagesPerSession) {
            this.instance.maxBufferedIncomingMessagesPerSession = maxBufferedIncomingMessagesPerSession;
            return this;
        }
    }
}

