/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.parts.ConnectionPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowExecutionInformationPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowLabelPart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowNodePart;
import de.rcenvironment.core.gui.workflow.parts.WorkflowPart;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.viewers.IStructuredSelection;

public class WorkflowEditorHelpContextProvider
implements IContextProvider {
    private GraphicalViewer viewer;
    private ToolIntegrationContextRegistry toolIntegrationRegistry;

    public WorkflowEditorHelpContextProvider(GraphicalViewer viewer) {
        this.viewer = viewer;
        ServiceRegistryAccess serviceRegistryAccess = this.createServiceRegistryAccess();
        this.toolIntegrationRegistry = (ToolIntegrationContextRegistry)serviceRegistryAccess.getService(ToolIntegrationContextRegistry.class);
    }

    protected ServiceRegistryAccess createServiceRegistryAccess() {
        return ServiceRegistry.createAccessFor((Object)this);
    }

    public IContext getContext(Object arg0) {
        Object object = this.getSelectedElement();
        if (object instanceof WorkflowNodePart) {
            WorkflowNodePart nodePart = (WorkflowNodePart)object;
            String componentIdentifier = this.getComponentIdentifier(nodePart);
            if (componentIdentifier.startsWith("de.rcenvironment.integration.workflow")) {
                return this.getContextFromHelpSystem("de.rcenvironment.workflow");
            }
            if (this.toolIntegrationRegistry.hasTIContextMatchingPrefix(componentIdentifier)) {
                return this.getContextFromHelpSystem("de.rcenvironment.integration.*");
            }
            if (componentIdentifier.contains("de.rcenvironment.remoteaccess")) {
                return this.getContextFromHelpSystem("de.rcenvironment.remoteaccess.*");
            }
            return this.getContextFromHelpSystem(componentIdentifier.substring(0, componentIdentifier.lastIndexOf("/")));
        }
        if (object instanceof ConnectionPart) {
            return this.getContextFromHelpSystem("de.rcenvironment.connectionEditorContext");
        }
        if (object instanceof WorkflowLabelPart) {
            return this.getContextFromHelpSystem("de.rcenvironment.workflowLabelContext");
        }
        if (object instanceof WorkflowPart) {
            return this.getContextFromHelpSystem("de.rcenvironment.workflowEditorContext");
        }
        if (object instanceof WorkflowExecutionInformationPart) {
            return this.getContextFromHelpSystem("de.rcenvironment.runtimeWorkflowEditorContext");
        }
        return this.getContextFromHelpSystem("de.rcenvironment.rce.gui.workflow.editor");
    }

    protected String getComponentIdentifier(WorkflowNodePart nodePart) {
        return ((WorkflowNode)nodePart.getModel()).getComponentDescription().getIdentifier();
    }

    protected Object getSelectedElement() {
        return ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    protected IContext getContextFromHelpSystem(String contextId) {
        return HelpSystem.getContext((String)contextId);
    }

    public int getContextChangeMask() {
        return 1;
    }

    public String getSearchExpression(Object arg0) {
        return null;
    }
}

