/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.outputwriter.gui;

import de.rcenvironment.components.outputwriter.common.OutputLocation;
import de.rcenvironment.components.outputwriter.common.OutputWriterComponentConstants;
import de.rcenvironment.components.outputwriter.common.OutputWriterValidatorHelper;
import de.rcenvironment.components.outputwriter.gui.Messages;
import de.rcenvironment.components.outputwriter.gui.OutputWriterGuiUtils;
import de.rcenvironment.components.outputwriter.gui.WarningErrorLabel;
import de.rcenvironment.core.gui.utils.incubator.AlphanumericalTextContraintListener;
import de.rcenvironment.core.gui.workflow.executor.properties.WhitespaceShowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class OutputLocationEditDialog
extends Dialog {
    private static final char SPACE = ' ';
    private static final String SEMICOLON = ";";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final int GROUPS_MIN_WIDTH = 550;
    private static final int HEADER_HEIGHT = 30;
    private static final int FORMAT_HEIGHT = 50;
    private static final char[] FORBIDDEN_CHARS = new char[]{'/', '\\', ':', '*', '?', '\"', '>', '<', '|'};
    private static final int MINUS_ONE = -1;
    private static final String COLON = ":";
    private String chosenFilename;
    private String chosenFolderForSaving;
    private OutputWriterComponentConstants.HandleExistingFile chosenHandle;
    private List<String> chosenInputSet;
    private String chosenHeader;
    private String chosenFormatString;
    private String title;
    private final Set<String> paths;
    private final List<String> possibleInputs;
    private final List<String> inputsSelectedByOthers;
    private final List<String> otherOutputLocationFileNamesWithPaths;
    private List<String> generalHeaderPlaceholderList;
    private List<String> generalFormatPlaceholderList;
    private CCombo formatPlaceholderCombo;
    private CCombo headerPlaceholderCombo;
    private WarningErrorLabel warningLabel;

    public OutputLocationEditDialog(Shell parentShell, String title, Set<String> paths, List<String> possibleInputs, List<String> inputsSelectedByOthers, List<String> otherOutputLocationFileNamesWithPaths) {
        super(parentShell);
        this.setShellStyle(67696);
        this.title = title;
        this.paths = paths;
        this.possibleInputs = possibleInputs;
        Collections.sort(this.possibleInputs);
        this.inputsSelectedByOthers = inputsSelectedByOthers;
        this.otherOutputLocationFileNamesWithPaths = otherOutputLocationFileNamesWithPaths;
        this.chosenFilename = "";
        this.chosenFolderForSaving = "[root]";
        this.chosenHandle = OutputWriterComponentConstants.DEFAULT_HANDLE_EXISTING_FILE;
        this.chosenInputSet = new ArrayList<String>();
        this.chosenHeader = "";
        this.chosenFormatString = "";
        this.generalHeaderPlaceholderList = new ArrayList<String>();
        this.generalFormatPlaceholderList = new ArrayList<String>();
        this.generalHeaderPlaceholderList.add("[Linebreak]");
        this.generalHeaderPlaceholderList.add("[Timestamp]");
        this.generalHeaderPlaceholderList.add("[Execution count]");
    }

    public String getChosenFilename() {
        return this.chosenFilename;
    }

    public OutputWriterComponentConstants.HandleExistingFile getChosenHandle() {
        return this.chosenHandle;
    }

    public List<String> getChosenInputSet() {
        return this.chosenInputSet;
    }

    public String getChosenHeader() {
        return this.chosenHeader;
    }

    public String getChosenFormatString() {
        return this.chosenFormatString;
    }

    public String getChosenFolderForSaving() {
        return this.chosenFolderForSaving;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        GridData g = new GridData(1808);
        g.horizontalAlignment = 2;
        container.setLayoutData((Object)g);
        this.createFileAndFolderSettings(container);
        Group inputsGroup = new Group(container, 16384);
        GridData gr = new GridData(768);
        inputsGroup.setLayoutData((Object)gr);
        gr.minimumWidth = 550;
        inputsGroup.setText(Messages.groupTitleInputs);
        RowLayout rowlayout = new RowLayout();
        inputsGroup.setLayout((Layout)rowlayout);
        boolean listEmpty = true;
        for (final String input : this.possibleInputs) {
            if (this.inputsSelectedByOthers.contains(input)) continue;
            listEmpty = false;
            final Button item = new Button((Composite)inputsGroup, 32);
            item.setText(input);
            if (this.chosenInputSet.contains(input)) {
                item.setSelection(true);
            }
            item.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent arg0) {
                    if (item.getSelection()) {
                        OutputLocationEditDialog.this.chosenInputSet.add(input);
                    } else {
                        OutputLocationEditDialog.this.chosenInputSet.remove(input);
                    }
                    OutputLocationEditDialog.this.refreshPlaceholders();
                    OutputLocationEditDialog.this.refreshFormatPlaceholderList();
                    OutputLocationEditDialog.this.updateWarningLabel();
                }

                public void widgetDefaultSelected(SelectionEvent arg0) {
                    this.widgetSelected(arg0);
                }
            });
        }
        if (listEmpty) {
            Label dummyLabel = new Label((Composite)inputsGroup, 0);
            dummyLabel.setText("");
            Label infoLabel = new Label((Composite)inputsGroup, 0);
            infoLabel.setText(Messages.emptyInputTable);
        }
        this.createFormatSection(container);
        return container;
    }

    protected void createFileAndFolderSettings(Composite container) {
        Group configGroup = new Group(container, 0x1000000);
        GridData g = new GridData(768);
        configGroup.setLayoutData((Object)g);
        g.minimumWidth = 550;
        configGroup.setText(Messages.groupTitleTargetFile);
        configGroup.setLayout((Layout)new GridLayout(2, false));
        Label fileNameLabel = new Label((Composite)configGroup, 0);
        fileNameLabel.setText(String.valueOf(Messages.outputLocFilename) + COLON);
        Text fileName = new Text((Composite)configGroup, 2052);
        fileName.setLayoutData((Object)new GridData(4, 4, true, false));
        fileName.setText(this.chosenFilename);
        fileName.addListener(25, (Listener)new AlphanumericalTextContraintListener(FORBIDDEN_CHARS));
        fileName.addModifyListener(ignoredEvent -> {
            this.chosenFilename = fileName.getText();
            this.setOKButtonActivation();
        });
        new Label((Composite)configGroup, 0).setText("");
        Composite placeholderComp = new Composite((Composite)configGroup, 0);
        GridLayout placeholderCompLayout = new GridLayout(2, false);
        placeholderCompLayout.marginWidth = 0;
        placeholderComp.setLayout((Layout)placeholderCompLayout);
        placeholderComp.setLayoutData((Object)new GridData(768));
        CCombo placeholderCombo = OutputWriterGuiUtils.createPlaceholderCombo(placeholderComp, OutputWriterComponentConstants.WORDLIST_OUTPUT);
        OutputWriterGuiUtils.createPlaceholderInsertButton(placeholderComp, placeholderCombo, fileName);
        new Label((Composite)configGroup, 0).setText(String.valueOf(Messages.targetFolder) + COLON);
        Combo directoryCombo = new Combo((Composite)configGroup, 8);
        directoryCombo.setLayoutData((Object)new GridData(768));
        if (!this.paths.contains("[root]")) {
            directoryCombo.add("[root]");
        }
        for (String path : this.paths) {
            directoryCombo.add(path);
        }
        int index = -1;
        String[] stringArray = directoryCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            if (item.equals(this.chosenFolderForSaving)) {
                index = directoryCombo.indexOf(item);
            }
            ++n2;
        }
        if (index >= 0) {
            directoryCombo.select(index);
        } else {
            directoryCombo.select(0);
        }
        this.chosenFolderForSaving = directoryCombo.getText();
        new Label((Composite)configGroup, 0).setText(String.valueOf(Messages.subFolder) + COLON);
        final Text additionalFolder = new Text((Composite)configGroup, 2052);
        additionalFolder.setMessage(Messages.optionalMessage);
        additionalFolder.setLayoutData((Object)new GridData(4, 4, true, false));
        additionalFolder.addModifyListener(event -> {
            this.chosenFolderForSaving = !((Text)event.getSource()).getText().isEmpty() ? "[root]" + File.separator + ((Text)event.getSource()).getText() : "[root]";
            this.setOKButtonActivation();
        });
        new Label((Composite)configGroup, 0).setText("");
        new Label((Composite)configGroup, 0).setText(Messages.onlyOneSubfolderMessage);
        new Label((Composite)configGroup, 0).setText("");
        Composite dirPlaceholderComp = new Composite((Composite)configGroup, 0);
        GridLayout dirPlaceholderCompLayout = new GridLayout(2, false);
        dirPlaceholderCompLayout.marginWidth = 0;
        dirPlaceholderComp.setLayout((Layout)dirPlaceholderCompLayout);
        dirPlaceholderComp.setLayoutData((Object)new GridData(768));
        final CCombo dirPlaceholderCombo = OutputWriterGuiUtils.createPlaceholderCombo(dirPlaceholderComp, OutputWriterComponentConstants.WORDLIST_OUTPUT);
        final Button dirInsertButton = OutputWriterGuiUtils.createPlaceholderInsertButton(dirPlaceholderComp, dirPlaceholderCombo, additionalFolder);
        if (directoryCombo.getSelectionIndex() > 0) {
            additionalFolder.setEnabled(false);
            dirPlaceholderCombo.setEnabled(false);
            dirInsertButton.setEnabled(false);
        }
        directoryCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                OutputLocationEditDialog.this.chosenFolderForSaving = ((Combo)arg0.getSource()).getText();
                additionalFolder.setEnabled(((Combo)arg0.getSource()).getText().equals("[root]"));
                dirPlaceholderCombo.setEnabled(((Combo)arg0.getSource()).getText().equals("[root]"));
                dirInsertButton.setEnabled(((Combo)arg0.getSource()).getText().equals("[root]"));
                OutputLocationEditDialog.this.setOKButtonActivation();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
                OutputLocationEditDialog.this.setOKButtonActivation();
            }
        });
        additionalFolder.addListener(25, (Listener)new AlphanumericalTextContraintListener(FORBIDDEN_CHARS));
    }

    protected void createFormatSection(Composite container) {
        Group configGroup = new Group(container, 0x1000000);
        GridData g = new GridData(1808);
        configGroup.setLayoutData((Object)g);
        g.minimumWidth = 550;
        configGroup.setText(Messages.groupTitleFormat);
        GridLayout configGroupLayout = new GridLayout(2, false);
        configGroup.setLayout((Layout)configGroupLayout);
        Label headerLabel = new Label((Composite)configGroup, 0);
        headerLabel.setText(String.valueOf(Messages.header) + COLON + "\n" + Messages.headerMessage);
        final StyledText header = new StyledText((Composite)configGroup, 2626);
        GridData headerGridData = new GridData(768);
        headerGridData.heightHint = 30;
        header.setLayoutData((Object)headerGridData);
        header.setText(this.chosenHeader);
        header.addModifyListener(event -> {
            this.chosenHeader = header.getText();
            this.setOKButtonActivation();
            this.updateWarningLabel();
        });
        header.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (!(header.getText().isEmpty() || e.keyCode != 13 && e.keyCode != 10)) {
                    header.setText(OutputLocationEditDialog.this.cleanCarriageReturn(header.getText()));
                    header.setSelection(header.getText().length());
                }
            }
        });
        WhitespaceShowListener headerWhitespaceListener = new WhitespaceShowListener(header);
        header.addPaintListener((PaintListener)headerWhitespaceListener);
        headerWhitespaceListener.setEnabled(true);
        headerWhitespaceListener.drawStyledText();
        new Label((Composite)configGroup, 0).setText("");
        Composite headerPlaceholderComp = new Composite((Composite)configGroup, 0);
        GridLayout headerPlaceholderCompLayout = new GridLayout(2, false);
        headerPlaceholderCompLayout.marginWidth = 0;
        headerPlaceholderComp.setLayout((Layout)headerPlaceholderCompLayout);
        headerPlaceholderComp.setLayoutData((Object)new GridData(768));
        this.headerPlaceholderCombo = OutputWriterGuiUtils.createPlaceholderCombo(headerPlaceholderComp, new String[0]);
        OutputWriterGuiUtils.createPlaceholderInsertButton(headerPlaceholderComp, this.headerPlaceholderCombo, header);
        Label formatStringLabel = new Label((Composite)configGroup, 0);
        formatStringLabel.setText(String.valueOf(Messages.format) + COLON + "\n" + Messages.formatMessage);
        final StyledText formatString = new StyledText((Composite)configGroup, 2626);
        GridData formatGridData = new GridData(1808);
        formatGridData.heightHint = 50;
        formatString.setLayoutData((Object)formatGridData);
        formatString.setText(this.chosenFormatString);
        formatString.addModifyListener(ignoredEvent -> {
            this.chosenFormatString = formatString.getText();
            this.setOKButtonActivation();
            this.updateWarningLabel();
        });
        formatString.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (formatString.getText().length() > 0 && (e.keyCode == 13 || e.keyCode == 10)) {
                    formatString.setText(OutputLocationEditDialog.this.cleanCarriageReturn(formatString.getText()));
                    formatString.setSelection(formatString.getText().length());
                }
            }
        });
        WhitespaceShowListener formatWhitespaceListener = new WhitespaceShowListener(formatString);
        formatString.addPaintListener((PaintListener)formatWhitespaceListener);
        formatWhitespaceListener.setEnabled(true);
        formatWhitespaceListener.drawStyledText();
        new Label((Composite)configGroup, 0).setText("");
        Composite formatPlaceholderComp = new Composite((Composite)configGroup, 0);
        GridLayout formatPlaceholderCompLayout = new GridLayout(2, false);
        formatPlaceholderCompLayout.marginWidth = 0;
        formatPlaceholderComp.setLayout((Layout)formatPlaceholderCompLayout);
        formatPlaceholderComp.setLayoutData((Object)new GridData(768));
        this.formatPlaceholderCombo = OutputWriterGuiUtils.createPlaceholderCombo(formatPlaceholderComp, new String[0]);
        OutputWriterGuiUtils.createPlaceholderInsertButton(formatPlaceholderComp, this.formatPlaceholderCombo, formatString);
        this.refreshPlaceholders();
        this.refreshFormatPlaceholderList();
        new Label((Composite)configGroup, 0).setText(String.valueOf(Messages.handleExisting) + COLON);
        final Combo existingFileCombo = new Combo((Composite)configGroup, 8);
        existingFileCombo.setLayoutData((Object)new GridData(768));
        String[] handlingOptions = new String[]{Messages.handleAppend, Messages.handleAutoRename, Messages.handleOverride};
        existingFileCombo.setItems(handlingOptions);
        switch (this.chosenHandle) {
            case APPEND: {
                existingFileCombo.select(existingFileCombo.indexOf(Messages.handleAppend));
                break;
            }
            case OVERRIDE: {
                existingFileCombo.select(existingFileCombo.indexOf(Messages.handleOverride));
                break;
            }
            case AUTORENAME: {
                existingFileCombo.select(existingFileCombo.indexOf(Messages.handleAutoRename));
                break;
            }
            default: {
                existingFileCombo.select(existingFileCombo.indexOf(Messages.handleAppend));
                LogFactory.getLog(((Object)((Object)this)).getClass()).error((Object)"Handling existing files: Option can not be selected.");
            }
        }
        existingFileCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (existingFileCombo.getText().equals(Messages.handleAppend)) {
                    OutputLocationEditDialog.this.chosenHandle = OutputWriterComponentConstants.HandleExistingFile.APPEND;
                } else if (existingFileCombo.getText().equals(Messages.handleAutoRename)) {
                    OutputLocationEditDialog.this.chosenHandle = OutputWriterComponentConstants.HandleExistingFile.AUTORENAME;
                } else if (existingFileCombo.getText().equals(Messages.handleOverride)) {
                    OutputLocationEditDialog.this.chosenHandle = OutputWriterComponentConstants.HandleExistingFile.OVERRIDE;
                } else {
                    OutputLocationEditDialog.this.chosenHandle = OutputWriterComponentConstants.HandleExistingFile.APPEND;
                    LogFactory.getLog(this.getClass()).error((Object)"Handling existing files: Option does not exist.");
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        new Label((Composite)configGroup, 0).setText("");
        new Label((Composite)configGroup, 0).setText(Messages.previousIterationMessage);
        this.createWarningLabel(configGroup);
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        this.setOKButtonActivation();
        this.updateWarningLabel();
    }

    protected Boolean validateTargetFileName() {
        boolean isValid = !this.chosenFilename.isEmpty();
        isValid = isValid && !this.otherOutputLocationFileNamesWithPaths.contains(String.valueOf(this.chosenFolderForSaving) + File.separator + this.chosenFilename);
        List<String> forbiddenFilenames = Arrays.asList(OutputWriterComponentConstants.PROBLEMATICFILENAMES_WIN);
        isValid = isValid && !forbiddenFilenames.contains(this.chosenFilename.toUpperCase());
        this.getButton(0).setEnabled(isValid);
        return isValid;
    }

    protected void refreshPlaceholders() {
        ArrayList<String> placeholderList = new ArrayList<String>();
        ArrayList<String> headerPlaceholderList = new ArrayList<String>();
        headerPlaceholderList.add("[Linebreak]");
        headerPlaceholderList.add("[Timestamp]");
        headerPlaceholderList.add("[Execution count]");
        Collections.sort(this.chosenInputSet);
        for (String input : this.chosenInputSet) {
            placeholderList.add("[" + input + "]");
        }
        placeholderList.add("[Linebreak]");
        placeholderList.add("[Timestamp]");
        placeholderList.add("[Execution count]");
        this.formatPlaceholderCombo.setItems(placeholderList.toArray(new String[placeholderList.size()]));
        this.formatPlaceholderCombo.select(0);
        this.headerPlaceholderCombo.setItems(headerPlaceholderList.toArray(new String[headerPlaceholderList.size()]));
        this.headerPlaceholderCombo.select(0);
    }

    public void initializeValues(OutputLocation out) {
        this.chosenFilename = out.getFilename();
        this.chosenFolderForSaving = out.getFolderForSaving();
        this.chosenFormatString = out.getFormatString();
        this.chosenInputSet = new ArrayList<String>(out.getInputs());
        this.chosenHandle = out.getHandleExistingFile();
        this.chosenHeader = out.getHeader();
    }

    private String cleanCarriageReturn(String tmp) {
        tmp = tmp.replaceAll("\r", "");
        tmp = tmp.replaceAll("\n", "");
        tmp = tmp.replace(Matcher.quoteReplacement("[Linebreak]"), Matcher.quoteReplacement("[Linebreak]" + LINE_SEP));
        return tmp;
    }

    private void refreshFormatPlaceholderList() {
        this.generalFormatPlaceholderList = new ArrayList<String>();
        this.generalFormatPlaceholderList.add("[Linebreak]");
        this.generalFormatPlaceholderList.add("[Timestamp]");
        this.generalFormatPlaceholderList.add("[Execution count]");
        for (String input : this.chosenInputSet) {
            String inputPlaceholder = "[" + input + "]";
            if (this.generalFormatPlaceholderList.contains(inputPlaceholder)) continue;
            this.generalFormatPlaceholderList.add(inputPlaceholder);
        }
    }

    private void setOKButtonActivation() {
        List headerValidationErrors = OutputWriterValidatorHelper.getValidationErrors((String)this.chosenHeader);
        List formatValidationErrors = OutputWriterValidatorHelper.getValidationErrors((String)this.chosenFormatString);
        boolean headerValidationFailed = !headerValidationErrors.isEmpty();
        boolean formatValidationFailed = !formatValidationErrors.isEmpty();
        boolean targetFileNameValidationFailed = this.validateTargetFileName() == false;
        boolean validationFailed = headerValidationFailed || formatValidationFailed || targetFileNameValidationFailed;
        Button okButton = this.getButton(0);
        okButton.setEnabled(!validationFailed);
    }

    private void updateWarningLabel() {
        StringBuilder errorMessageBuilder;
        StringBuilder warningMessageBuilder;
        StringBuilder warningBuilder;
        boolean formatValidationFailed;
        this.warningLabel.clearWarnings();
        this.warningLabel.clearErrors();
        List headerValidationErrors = OutputWriterValidatorHelper.getValidationErrors((String)this.chosenHeader);
        List formatValidationErrors = OutputWriterValidatorHelper.getValidationErrors((String)this.chosenFormatString);
        boolean headerValidationFailed = !headerValidationErrors.isEmpty();
        boolean bl = formatValidationFailed = !formatValidationErrors.isEmpty();
        if (!headerValidationFailed) {
            warningBuilder = new StringBuilder();
            warningBuilder.append("Contains unknown placeholder: ");
            List headerValidationWarnings = OutputWriterValidatorHelper.getValidationWarnings((StringBuilder)warningBuilder, (String)this.chosenHeader, this.generalHeaderPlaceholderList);
            if (!headerValidationWarnings.isEmpty()) {
                warningMessageBuilder = new StringBuilder();
                warningMessageBuilder.append("Header section:\n");
                warningMessageBuilder.append(String.join((CharSequence)"; ", headerValidationWarnings));
                this.warningLabel.addWarning(warningMessageBuilder.toString());
            }
        } else {
            errorMessageBuilder = new StringBuilder();
            errorMessageBuilder.append("Header section:\n");
            errorMessageBuilder.append(String.join((CharSequence)"; ", headerValidationErrors));
            this.warningLabel.addError(errorMessageBuilder.toString());
        }
        if (!formatValidationFailed) {
            warningBuilder = new StringBuilder();
            warningBuilder.append("Contains unknown placeholder: ");
            List formatValidationWarnings = OutputWriterValidatorHelper.getValidationWarnings((StringBuilder)warningBuilder, (String)this.chosenFormatString, this.generalFormatPlaceholderList);
            if (!formatValidationWarnings.isEmpty()) {
                warningMessageBuilder = new StringBuilder();
                warningMessageBuilder.append("Format section:\n");
                warningMessageBuilder.append(String.join((CharSequence)"; ", formatValidationWarnings));
                this.warningLabel.addWarning(warningMessageBuilder.toString());
            }
        } else {
            errorMessageBuilder = new StringBuilder();
            errorMessageBuilder.append("Format section:\n");
            errorMessageBuilder.append(String.join((CharSequence)"; ", formatValidationErrors));
            this.warningLabel.addError(errorMessageBuilder.toString());
        }
    }

    private void createWarningLabel(Group configGroup) {
        new Label((Composite)configGroup, 0).setText("");
        this.warningLabel = new WarningErrorLabel((Composite)configGroup, 0);
    }
}

