/*
 * Copyright 2006-2021 DLR, Germany
 * 
 * SPDX-License-Identifier: EPL-1.0
 * 
 * https://rcenvironment.de/
 */
 
package de.rcenvironment.core.component.model.endpoint.api;

/**
 * Constants used in JSON files to describe endpoints.
 * 
 * @author Doreen Seider
 */
public final class EndpointDefinitionConstants {

    /** JSON key used in .json definition file. */
    public static final String DEFAULT_DYNAMIC_ENDPOPINT_IDENTIFIER = "default";
    
    /** JSON key used in .json definition file. */
    public static final String KEY_DEFAULT_INPUT_HANDLING = "defaultInputHandling";
    
    /** JSON key used in .json definition file. */
    public static final String KEY_INPUT_HANDLING_OPTIONS = "inputHandlingOptions";
    
    /** JSON key used in .json definition file. */
    public static final String KEY_DEFAULT_EXECUTION_CONSTRAINT = "defaultInputExecutionConstraint";
    
    /** JSON key used in .json definition file. */
    public static final String KEY_EXECUTION_CONSTRAINT_OPTIONS = "inputExecutionConstraintOptions";
    
    /** JSON key used in .json definition file. */
    public static final String KEY_DATATYPES = "dataTypes";
    
    /** JSON key used in .json definition file. */
    public static final String KEY_DEFAULT_DATATYPE = "defaultDataType";
    
    /** JSON key used in .json definition file. */
    public static final String KEY_METADATA = "metaData";

    /** JSON key used in .json definition file. */
    public static final String JSON_KEY_STATIC_INPUTS = "staticInputs";

    /** JSON key used in .json definition file. */
    public static final String JSON_KEY_DYNAMIC_INPUTS = "dynamicInputs";

    /** JSON key used in .json definition file. */
    public static final String JSON_KEY_STATIC_OUTPUTS = "staticOutputs";

    /** JSON key used in .json definition file. */
    public static final String JSON_KEY_DYNAMIC_OUTPUTS = "dynamicOutputs";
    
    /** JSON key used in .json definition file. */
    public static final String JSON_KEY_STATIC_INPUTS_META_DATA = "staticInputMetaData";

    /** JSON key used in .json definition file. */
    public static final String JSON_KEY_DYNAMIC_INPUTS_META_DATA = "dynamicInputMetaData";

    /** JSON key used in .json definition file. */
    public static final String JSON_KEY_STATIC_OUTPUTS_META_DATA = "staticOutputMetaData";

    /** JSON key used in .json definition file. */
    public static final String JSON_KEY_DYNAMIC_OUTPUTS_META_DATA = "dynamicOutputMetaData";
    
    /** JSON key used in .json definition file. */
    public static final String JSON_KEY_STATIC_INPUT_GROUPS = "staticInputGroups";
    
    /** JSON key used in .json definition file. */
    public static final String JSON_KEY_DYNAMIC_INPUT_GROUPS = "dynamicInputGroups";
    
    /** Constant. */
    public static final String KEY_NAME = "name";
    
    /** Constant. */
    public static final String KEY_IDENTIFIER = "identifier";
    
    /** Constant. */
    public static final String KEY_GROUP = "group";
    
    /** Constant. */
    public static final String KEY_VISIBILITY = "visibility";

    /** Constant. */
    public static final String KEY_GUI_NAME = "guiName";

    /** Constant. */
    public static final String KEY_GUI_POSITION = "guiPosition";

    /** Constant. */
    public static final String KEY_GUIGROUP = "guiGroup";
    
    private EndpointDefinitionConstants()  {}
    
}
