/*
 * Decompiled with CFR 0.152.
 */
package cucumber.java.runtime.osgi;

import cucumber.runtime.ClassFinder;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiClassFinder
implements ClassFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(OsgiClassFinder.class);
    private final BundleContext bundleContext;

    public OsgiClassFinder(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public <T> Collection<Class<? extends T>> getDescendants(Class<T> parentType, String packageName) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Looking for sub classes of " + parentType.getName() + " in '" + packageName + "' package");
        }
        String searchPath = packageName.replace('.', '/');
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            try {
                result.addAll(this.findClassesInBundle(bundle, searchPath, parentType));
            }
            catch (Exception e) {
                LOGGER.error("Failed to inspect bundle " + bundle.getSymbolicName() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        result.trimToSize();
        return result;
    }

    public <T> Class<? extends T> loadClass(String className) throws ClassNotFoundException {
        int n = 0;
        Bundle[] bundleArray = this.bundleContext.getBundles();
        int n2 = bundleArray.length;
        if (n < n2) {
            Bundle bundle = bundleArray[n];
            return bundle.loadClass(className);
        }
        throw new ClassNotFoundException("Couldn't load class from bundles: " + className);
    }

    private <T> Collection<Class<? extends T>> findClassesInBundle(Bundle bundle, String searchPath, Class<T> parentType) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        Enumeration resources = bundle.findEntries(searchPath, "*.class", true);
        if (resources == null) {
            return Collections.emptyList();
        }
        for (URL url : Collections.list(resources)) {
            String className = OsgiClassFinder.pathToClassName(url.getPath());
            try {
                Class<T> castClass = this.loadClassFromBundle(parentType, bundle, className);
                if (castClass == null) continue;
                result.add(castClass);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load class " + className, (Throwable)e);
            }
        }
        return result;
    }

    private <T> Class<? extends T> loadClassFromBundle(Class<T> parentType, Bundle bundle, String className) throws ClassNotFoundException {
        Class clazz = bundle.loadClass(className);
        if (clazz != null && !parentType.equals(clazz) && parentType.isAssignableFrom(clazz)) {
            return clazz.asSubclass(parentType);
        }
        return null;
    }

    private static String pathToClassName(String path) {
        return path.substring(1, path.length() - 6).replace('/', '.');
    }
}

