/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.extras.testscriptrunner.definitions.common.RceTestLifeCycleHooks;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.AssertOutputStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.CommonStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.ComponentStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.InstanceCommandStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.InstanceInstantiationStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.InstanceNetworkingStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.InstanceStateStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.definitions.impl.WorkflowStepDefinitions;
import de.rcenvironment.extras.testscriptrunner.internal.CucumberTestFrameworkAdapter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestScriptRunnerCommandPlugin
implements CommandPlugin {
    private static final String USAGE_INFO_PARAMETER_PART = "<comma-separated test ids>|--all <build id>";
    private static final String SEPARATOR_TEXT_LINE = "-----------------------------------------------------------------------------------------------";
    private ConfigurationSegment configuration;
    private File scriptLocationRoot;
    private final CucumberTestFrameworkAdapter testFrameworkAdapter;
    private final Log log = LogFactory.getLog(this.getClass());
    private final File reportsRootDir;

    public TestScriptRunnerCommandPlugin() throws IOException {
        this.testFrameworkAdapter = new CucumberTestFrameworkAdapter(AssertOutputStepDefinitions.class, CommonStepDefinitions.class, ComponentStepDefinitions.class, InstanceCommandStepDefinitions.class, InstanceInstantiationStepDefinitions.class, InstanceNetworkingStepDefinitions.class, InstanceStateStepDefinitions.class, RceTestLifeCycleHooks.class, WorkflowStepDefinitions.class);
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            TempFileServiceAccess.setupUnitTestEnvironment();
        }
        this.reportsRootDir = TempFileServiceAccess.getInstance().createManagedTempDir("tsr_reports");
    }

    protected void bindConfigurationService(ConfigurationService configurationService) {
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.configuration = configurationService.getConfigurationSegment("testScriptRunner");
        String scriptLocation = this.configuration.getString("scriptLocation");
        if (!StringUtils.isNullorEmpty((String)scriptLocation)) {
            this.scriptLocationRoot = new File(scriptLocation);
        } else {
            try {
                this.scriptLocationRoot = configurationService.getUnpackedFilesLocation("testScripts");
            }
            catch (ConfigurationException e) {
                this.log.error((Object)"Failed to locate the default script file location, and no explicit path setting found - disabling TestScriptRunner", (Throwable)e);
                this.scriptLocationRoot = null;
                return;
            }
        }
        this.log.debug((Object)("Using test script folder " + this.scriptLocationRoot));
    }

    public void execute(CommandContext context) throws CommandException {
        if (this.scriptLocationRoot == null) {
            throw CommandException.executionError((String)"The run-test feature is disabled because it was not correctly configured", (CommandContext)context);
        }
        String mainCommand = context.consumeNextToken();
        if (!"run-test".equals(mainCommand) && !"run-tests".equals(mainCommand)) {
            throw CommandException.unknownCommand((CommandContext)context);
        }
        try {
            this.performRunTests(context);
        }
        catch (IOException e) {
            throw CommandException.executionError((String)e.getMessage(), (CommandContext)context);
        }
    }

    private void performRunTests(CommandContext context) throws IOException, CommandException {
        if (context.getOriginalTokens().size() != 3) {
            throw CommandException.syntaxError((String)"Wrong number of parameters\n  Usage: run-test[s] <comma-separated test ids>|--all <build id>\n  Example: run-test Test03 snapshots/trunk", (CommandContext)context);
        }
        String tagNameFilter = context.consumeNextToken();
        if ("--all".equals(tagNameFilter)) {
            tagNameFilter = null;
        }
        String buildUnderTestId = context.consumeNextToken();
        CucumberTestFrameworkAdapter.ExecutionResult result = this.testFrameworkAdapter.executeTestScripts(this.scriptLocationRoot, tagNameFilter, context.getOutputReceiver(), buildUnderTestId, this.reportsRootDir);
        List<String> reportLines = result.getReportFileLines();
        if (reportLines != null) {
            context.println((Object)"");
            context.println((Object)"Test run complete, content of report file:");
            context.println((Object)SEPARATOR_TEXT_LINE);
            for (String line : reportLines) {
                context.println((Object)line);
            }
            context.println((Object)SEPARATOR_TEXT_LINE);
        } else {
            context.println((Object)"Test run complete (no report file found)");
        }
        List<String> stdOutLines = result.getCapturedStdOutLines();
        if (!stdOutLines.isEmpty()) {
            context.println((Object)"");
            context.println((Object)"Captured Output:");
            context.println((Object)SEPARATOR_TEXT_LINE);
            for (String line : stdOutLines) {
                context.println((Object)line);
            }
            context.println((Object)SEPARATOR_TEXT_LINE);
        }
    }

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> result = new ArrayList<CommandDescription>();
        result.add(new CommandDescription("run-test", USAGE_INFO_PARAMETER_PART, true, null, new String[0]));
        result.add(new CommandDescription("run-tests", "", true, "(alias of \"run-test\")", new String[0]));
        return result;
    }
}

