/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.internal;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.configuration.ConfigurationException;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.configuration.ConfigurationServiceMessage;
import de.rcenvironment.core.configuration.ConfigurationServiceMessageEvent;
import de.rcenvironment.core.configuration.ConfigurationServiceMessageEventListener;
import de.rcenvironment.core.configuration.WritableConfigurationSegment;
import de.rcenvironment.core.configuration.bootstrap.BootstrapConfiguration;
import de.rcenvironment.core.configuration.bootstrap.RuntimeDetection;
import de.rcenvironment.core.configuration.bootstrap.profile.Profile;
import de.rcenvironment.core.configuration.bootstrap.profile.ProfileException;
import de.rcenvironment.core.configuration.internal.ConfigurationStoreImpl;
import de.rcenvironment.core.configuration.internal.GeneralSettings;
import de.rcenvironment.core.configuration.internal.Messages;
import de.rcenvironment.core.configuration.internal.UnpackedFilesDirectoryResolver;
import de.rcenvironment.core.utils.common.AuditLog;
import de.rcenvironment.core.utils.common.AuditLogFileBackend;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.OSFamily;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.common.VersionUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public class ConfigurationServiceImpl
implements ConfigurationService {
    protected static final String CONFIGURATION_SUBDIRECTORY_PATH = "configuration";
    protected static final String INTEGRATION_SUBDIRECTORY_PATH = "integration";
    protected static final String RELATIVE_PATH_TO_STORAGE_ROOT = "storage";
    protected static final String RELATIVE_PATH_TO_INTERNAL_DATA_ROOT = "internal";
    protected static final String RELATIVE_PATH_TO_OUTPUT_ROOT = "output";
    protected static final String MAIN_CONFIGURATION_FILENAME = "configuration.json";
    protected static final String JDBC_SUBDIRECTORY_PATH = "extras/database_connectors";
    private static final boolean AUTO_EXPORT_CONFIGURATION_ON_STARTUP = false;
    private static final String SPACE_CHARACTER = " ";
    private File parentTempDirectoryRoot;
    private final Map<ConfigurationService.ConfigurablePathId, File> configurablePathMap = new HashMap<ConfigurationService.ConfigurablePathId, File>();
    private final Map<ConfigurationService.ConfigurablePathListId, List<File>> configurablePathListMap = new HashMap<ConfigurationService.ConfigurablePathListId, List<File>>();
    private final ObjectMapper mapper;
    private Map<String, String> substitutionProperties = new HashMap<String, String>();
    private final List<ConfigurationServiceMessageEventListener> errorListeners = new LinkedList<ConfigurationServiceMessageEventListener>();
    private final Log log = LogFactory.getLog(this.getClass());
    private List<File> readableConfigurationDirs;
    private Profile profile;
    private boolean isUsingIntendedProfileDirectory;
    private BootstrapConfiguration bootstrapSettings;
    private ConfigurationStoreImpl configurationStore;
    private File configurationStoreFile;
    private ConfigurationSegment currentRootConfiguration;
    private GeneralSettings generalSettings;
    private String resolvedInstanceName;
    private boolean usingDefaultConfigurationValues = false;
    private UnpackedFilesDirectoryResolver unpackedFilesDirectoryResolver;

    public ConfigurationServiceImpl() {
        this.mapper = JsonUtils.getDefaultObjectMapper();
        this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }

    public void activate(BundleContext context) {
        this.bootstrapSettings = BootstrapConfiguration.getInstance();
        if (RuntimeDetection.isImplicitServiceActivationDenied()) {
            return;
        }
        this.initializeProfileDirFromBootstrapSettings();
        this.initializeConfigurablePaths();
        this.loadRootConfiguration(false);
        this.exportConfigIfConfigured(false);
        this.initializeGeneralSettings();
        this.initializeAuditLog();
        this.initializeParentTempDirectoryRoot(this.generalSettings.getTempDirectoryOverride());
        this.initializeInstanceTempDirectoryRoot();
        this.unpackedFilesDirectoryResolver = new UnpackedFilesDirectoryResolver(context, this.getConfigurablePath(ConfigurationService.ConfigurablePathId.INSTALLATION_DATA_ROOT));
    }

    private synchronized void loadRootConfiguration(boolean isReload) {
        if (!isReload) {
            this.configurationStoreFile = new File(this.getProfileDirectory(), MAIN_CONFIGURATION_FILENAME);
            if (!this.configurationStoreFile.exists()) {
                File sampleFileLocation = new File(this.getConfigurablePath(ConfigurationService.ConfigurablePathId.INSTALLATION_DATA_ROOT), "examples/configuration/configuration.json.default_configuration.sample");
                this.log.info((Object)("No configuration file found; creating a new one at " + this.configurationStoreFile.getAbsolutePath()));
                if (sampleFileLocation.isFile()) {
                    try {
                        FileUtils.copyFile((File)sampleFileLocation, (File)this.configurationStoreFile);
                        this.log.info((Object)("Successfully created a default configuration file at " + this.configurationStoreFile.getAbsolutePath()));
                    }
                    catch (IOException iOException) {
                        this.log.error((Object)("Failed to copy sample configuration file from " + sampleFileLocation.getAbsolutePath() + " to " + this.configurationStoreFile.getAbsolutePath()));
                    }
                } else {
                    this.log.error((Object)("Expected configuration sample file not found at " + sampleFileLocation.getAbsolutePath()));
                }
            }
            this.configurationStore = new ConfigurationStoreImpl(this.configurationStoreFile);
        }
        try {
            this.currentRootConfiguration = this.configurationStore.getSnapshotOfRootSegment();
        }
        catch (IOException e) {
            this.log.error((Object)StringUtils.format((String)"Failed to load configuration file %s: %s", (Object[])new Object[]{this.configurationStoreFile.getAbsolutePath(), e.toString()}));
        }
        if (this.currentRootConfiguration == null) {
            this.log.error((Object)StringUtils.format((String)"No configuration file found, or it could not be loaded; using default values", (Object[])new Object[0]));
            this.currentRootConfiguration = this.configurationStore.createEmptyPlaceholder();
            this.usingDefaultConfigurationValues = true;
        }
        this.log.debug((Object)"(Re-)loaded root configuration");
    }

    private void exportConfigIfConfigured(boolean isReload) {
    }

    @Override
    public File getProfileDirectory() {
        return this.profile.getProfileDirectory();
    }

    @Override
    public File getProfileConfigurationFile() {
        return new File(this.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_ROOT), MAIN_CONFIGURATION_FILENAME);
    }

    @Override
    public boolean isUsingIntendedProfileDirectory() {
        return this.isUsingIntendedProfileDirectory;
    }

    @Override
    public boolean isIntendedProfileDirectorySuccessfullyLocked() {
        return this.bootstrapSettings.getOriginalProfile().isLocked();
    }

    @Override
    public boolean hasIntendedProfileDirectoryValidVersion() {
        Profile originalProfile = this.bootstrapSettings.getOriginalProfile();
        try {
            return originalProfile.hasCurrentVersion();
        }
        catch (ProfileException e) {
            this.log.error((Object)String.format("Could not determine version of profile \"%s\".", originalProfile.getName()), (Throwable)e);
            return false;
        }
    }

    private void initializeProfileDirFromBootstrapSettings() {
        this.profile = this.bootstrapSettings.getProfile();
        this.isUsingIntendedProfileDirectory = this.isIntendedProfileDirectorySuccessfullyLocked() && this.hasIntendedProfileDirectoryValidVersion();
    }

    private void initializeAuditLog() {
        try {
            Path profileRootPath = this.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_ROOT).toPath();
            AuditLog.initialize((AuditLog.AuditLogBackend)new AuditLogFileBackend(profileRootPath.resolve("event.log")));
            AuditLog.append((String)"application.start", (String)"", (String)"-------------------------------------------------------------------------");
            String rceVersionInfo = VersionUtils.getVersionOfProduct().toString().replace(".qualifier", ".dev");
            AuditLog.append((AuditLog.LogEntry)AuditLog.newEntry((String)"application.session.start").set("profile_location", profileRootPath.toString()).set("os_name", String.valueOf(System.getProperty("os.name")) + "; " + System.getProperty("os.version")).set("user_name", System.getProperty("user.name")).set("user_home", System.getProperty("user.home")).set("work_dir", System.getProperty("user.dir")).set("rce_version", rceVersionInfo));
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                AuditLog.append((String)"application.terminating", null);
                AuditLog.close();
            }));
        }
        catch (IOException e) {
            this.log.error((Object)("Failed to initialize audit log: " + e.toString()));
        }
    }

    protected void mockActivate() {
        this.bootstrapSettings = BootstrapConfiguration.getInstance();
        this.initializeProfileDirFromBootstrapSettings();
        this.initializeConfigurablePaths();
        this.loadRootConfiguration(false);
        this.initializeGeneralSettings();
    }

    @Override
    public void addSubstitutionProperties(String namespace, Map<String, String> properties) {
        if (namespace == null || namespace.isEmpty()) {
            throw new IllegalArgumentException("Namespace must not be null");
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            this.substitutionProperties.put(String.valueOf(namespace) + ":" + entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Deprecated
    public <T> T getConfiguration(String identifier, Class<T> clazz) {
        this.log.warn((Object)("Using a legacy method to load configuration data; id = " + identifier));
        T configObject = null;
        String errorMessage = null;
        Throwable exception = null;
        String fileName = String.valueOf(identifier) + ".json";
        File configFile = this.locateConfigurationFile(fileName);
        if (configFile != null) {
            this.log.debug((Object)("Loading configuration file " + configFile));
            try {
                configObject = this.parseConfigurationFile(clazz, configFile);
            }
            catch (JsonParseException e) {
                errorMessage = Messages.bind((String)Messages.parsingError, (Object)configFile);
                exception = e;
            }
            catch (JsonMappingException e) {
                errorMessage = Messages.bind((String)Messages.mappingError, (Object)configFile);
                exception = e;
            }
            catch (IOException e) {
                errorMessage = Messages.bind((String)Messages.couldNotOpen, (Object)configFile);
                exception = e;
            }
        } else {
            this.log.debug((Object)("No " + fileName + " found in any of the configuration directories " + this.readableConfigurationDirs + "; using default values"));
        }
        if (errorMessage != null) {
            this.log.warn((Object)errorMessage, exception);
            ConfigurationServiceMessage error = new ConfigurationServiceMessage(errorMessage);
            this.fireErrorEvent(error);
        }
        if (configObject == null) {
            try {
                configObject = clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.log.error((Object)"Error creating configuration object", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return configObject;
    }

    @Override
    public ConfigurationSegment getConfigurationSegment(String relativePath) {
        return this.currentRootConfiguration.getSubSegment(relativePath);
    }

    @Override
    public WritableConfigurationSegment getOrCreateWritableConfigurationSegment(String path) throws ConfigurationException {
        return this.currentRootConfiguration.getOrCreateWritableSubSegment(path);
    }

    @Override
    public void writeConfigurationChanges() throws ConfigurationException, IOException {
        this.configurationStore.update(this.currentRootConfiguration);
    }

    @Override
    public void reloadConfiguration() {
        this.loadRootConfiguration(true);
    }

    @Override
    public ConfigurationSegment loadCustomConfigurationFile(Path path) throws IOException {
        return new ConfigurationStoreImpl(path.toFile()).getSnapshotOfRootSegment();
    }

    protected <T> T parseConfigurationFile(Class<T> clazz, File configFile) throws IOException, JsonParseException, JsonMappingException {
        if (configFile.exists()) {
            Object configObject;
            String fileContent = FileUtils.readFileToString((File)configFile);
            if (fileContent.equals("")) {
                return null;
            }
            try {
                configObject = this.mapper.readValue(fileContent, clazz);
            }
            catch (JsonParseException jsonParseException) {
                String errorMessage = Messages.bind((String)Messages.parsingError, (Object)configFile.getAbsolutePath());
                ConfigurationServiceMessage error = new ConfigurationServiceMessage(errorMessage);
                this.fireErrorEvent(error);
                configObject = null;
            }
            return (T)configObject;
        }
        return null;
    }

    @Override
    public String resolveBundleConfigurationPath(String identifier, String path) {
        String absolutePath = new File(path).isAbsolute() ? path : String.valueOf(BootstrapConfiguration.getInstallationDir().getAbsolutePath()) + File.separator + identifier + File.separator + path;
        return absolutePath;
    }

    @Override
    public File getConfigurablePath(ConfigurationService.ConfigurablePathId pathId) {
        File path = this.configurablePathMap.get((Object)pathId);
        if (path == null) {
            throw new IllegalStateException("Internal error: Unconfigured path requested, id = " + (Object)((Object)pathId));
        }
        return path;
    }

    @Override
    public File[] getConfigurablePathList(ConfigurationService.ConfigurablePathListId pathListId) {
        List<File> pathList = this.configurablePathListMap.get((Object)pathListId);
        if (pathList == null) {
            throw new IllegalStateException("Internal error: Unconfigured path list requested, id = " + (Object)((Object)pathListId));
        }
        return pathList.toArray(new File[pathList.size()]);
    }

    @Override
    public File initializeSubDirInConfigurablePath(ConfigurationService.ConfigurablePathId pathId, String relativePath) {
        File subDir = new File(this.getConfigurablePath(pathId), relativePath);
        subDir.mkdirs();
        if (!subDir.isDirectory()) {
            throw new RuntimeException(new IOException("Failed to create configuration sub-directory " + subDir.getAbsolutePath()));
        }
        return subDir;
    }

    @Override
    public File getStandardImportDirectory(String subdir) {
        return new File(this.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_ROOT), "import/" + subdir);
    }

    @Override
    public File getOriginalProfileDirectory() {
        return this.bootstrapSettings.getOriginalProfile().getProfileDirectory();
    }

    @Override
    public File getUnpackedFilesLocation(String filesetId) throws ConfigurationException {
        return this.unpackedFilesDirectoryResolver.resolveIdToUnpackedFilesDirectory(filesetId);
    }

    @Override
    public String getInstanceName() {
        return this.resolvedInstanceName;
    }

    @Override
    public boolean getIsWorkflowHost() {
        return this.generalSettings.getIsWorkflowHost();
    }

    @Override
    public boolean getIsRelay() {
        return this.generalSettings.getIsRelay();
    }

    @Override
    public File getParentTempDirectoryRoot() {
        return this.parentTempDirectoryRoot;
    }

    public void addErrorListener(ConfigurationServiceMessageEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.errorListeners.add(listener);
        this.log.debug((Object)StringUtils.format((String)"Added instance of type '%s' to the configuration service error listeners.", (Object[])new Object[]{listener.getClass()}));
    }

    public void removeErrorListener(ConfigurationServiceMessageEventListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.errorListeners.remove(listener);
        this.log.debug((Object)StringUtils.format((String)"Removed instance of type '%s' to the configuration service error listeners.", (Object[])new Object[]{listener.getClass()}));
    }

    protected void fireErrorEvent(ConfigurationServiceMessage error) {
        ConfigurationServiceMessageEvent event = new ConfigurationServiceMessageEvent(this, error);
        RuntimeException exception = null;
        for (ConfigurationServiceMessageEventListener listener : this.errorListeners) {
            try {
                listener.handleConfigurationServiceError(event);
            }
            catch (RuntimeException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void initializeParentTempDirectoryRoot(String parentTempDirectoryOverride) {
        File parentTempDir = null;
        if (parentTempDirectoryOverride != null && !parentTempDirectoryOverride.trim().isEmpty()) {
            if (parentTempDirectoryOverride.contains(SPACE_CHARACTER)) {
                this.log.warn((Object)("Failed to initialize custom temp directory. Path '" + parentTempDirectoryOverride + "' contains whitespace(s) - trying default directory"));
            } else {
                parentTempDir = new File(this.resolvePlaceholdersInTempDirSetting(parentTempDirectoryOverride));
                parentTempDir.mkdirs();
                if (!parentTempDir.isDirectory()) {
                    this.log.warn((Object)("Failed to initialize custom temp directory " + parentTempDir.getAbsolutePath() + " - trying default directory"));
                    parentTempDir = null;
                }
            }
        }
        if (parentTempDir == null) {
            String relativePath = OSFamily.isWindows() ? "rce-temp" : "rce-temp-${systemUser}";
            parentTempDir = new File(this.getSystemTempDir(), this.resolvePlaceholdersInTempDirSetting(relativePath));
            parentTempDir.mkdirs();
            if (!parentTempDir.isDirectory()) {
                throw new RuntimeException("Failed to initialize default temp directory " + parentTempDir.getAbsolutePath());
            }
        }
        this.log.debug((Object)("Using parent temporary file directory " + parentTempDir.getAbsolutePath()));
        this.parentTempDirectoryRoot = parentTempDir;
    }

    private String resolvePlaceholdersInTempDirSetting(String value) {
        return value.replace("${systemUser}", System.getProperty("user.name"));
    }

    private void initializeGeneralSettings() {
        ConfigurationSegment configurationSegment = this.getConfigurationSegment("general");
        this.generalSettings = new GeneralSettings(configurationSegment);
        this.resolvedInstanceName = this.resolvePlaceholdersInInstanceName(this.generalSettings.getRawInstanceName());
        this.log.debug((Object)("Resolved instance name: " + this.resolvedInstanceName));
    }

    private String resolvePlaceholdersInInstanceName(String instanceName) {
        instanceName = instanceName.replace("${systemUser}", System.getProperty("user.name"));
        instanceName = instanceName.replace("${profileName}", this.profile.getLocationDependentName());
        instanceName = instanceName.replace("${version}", StringUtils.nullSafeToString((Object)VersionUtils.getVersionOfProduct(), (String)"<unknown>"));
        instanceName = instanceName.replace("${javaVersion}", System.getProperty("java.version"));
        if ((instanceName = instanceName.replace("${systemName}", System.getProperty("os.name"))).contains("${hostName}")) {
            try {
                instanceName = instanceName.replace("${hostName}", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                LogFactory.getLog(this.getClass()).warn((Object)"Failed to determine the local host name", (Throwable)e);
            }
        }
        return instanceName;
    }

    private void initializeInstanceTempDirectoryRoot() {
        String instanceTempDirectoryPrefix = this.profile.getName();
        try {
            TempFileServiceAccess.setupLiveEnvironment((File)this.parentTempDirectoryRoot, (String)instanceTempDirectoryPrefix);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to initialize the temporary file manager after the parent root directory was successfully initialized; prefix=" + instanceTempDirectoryPrefix, e);
        }
    }

    private void initializeConfigurablePaths() {
        if (!this.configurePathFromOverridePropertyIfSet(ConfigurationService.ConfigurablePathId.INSTALLATION_DATA_ROOT, "rce.installationData.rootDir")) {
            File installationDirectory = BootstrapConfiguration.getInstallationDir();
            this.log.info((Object)("Using installation data root directory " + installationDirectory.getAbsolutePath()));
            this.configurablePathMap.put(ConfigurationService.ConfigurablePathId.INSTALLATION_DATA_ROOT, installationDirectory);
        }
        File installationDataRoot = this.configurablePathMap.get((Object)ConfigurationService.ConfigurablePathId.INSTALLATION_DATA_ROOT);
        if (!this.configurePathFromOverridePropertyIfSet(ConfigurationService.ConfigurablePathId.SHARED_USER_SETTINGS_ROOT, "rce.userSettings.rootDir")) {
            this.configurablePathMap.put(ConfigurationService.ConfigurablePathId.SHARED_USER_SETTINGS_ROOT, new File(System.getProperty("user.home"), ".rce/common").getAbsoluteFile());
        }
        this.configurablePathMap.put(ConfigurationService.ConfigurablePathId.PROFILE_ROOT, this.profile.getProfileDirectory());
        this.initializeRelativeProfilePath(ConfigurationService.ConfigurablePathId.PROFILE_INTEGRATION_DATA, INTEGRATION_SUBDIRECTORY_PATH);
        this.initializeRelativeProfilePath(ConfigurationService.ConfigurablePathId.PROFILE_OUTPUT, RELATIVE_PATH_TO_OUTPUT_ROOT);
        this.initializeRelativeProfilePath(ConfigurationService.ConfigurablePathId.PROFILE_DATA_MANAGEMENT, RELATIVE_PATH_TO_STORAGE_ROOT);
        this.initializeRelativeProfilePath(ConfigurationService.ConfigurablePathId.PROFILE_CONFIGURATION_DATA, CONFIGURATION_SUBDIRECTORY_PATH);
        this.initializeRelativeProfilePath(ConfigurationService.ConfigurablePathId.PROFILE_INTERNAL_DATA, RELATIVE_PATH_TO_INTERNAL_DATA_ROOT);
        this.definePathAlias(ConfigurationService.ConfigurablePathId.DEFAULT_WRITEABLE_INTEGRATION_ROOT, ConfigurationService.ConfigurablePathId.PROFILE_INTEGRATION_DATA);
        this.readableConfigurationDirs = new ArrayList<File>();
        this.addDirectoryIfPresent(this.readableConfigurationDirs, new File(installationDataRoot, CONFIGURATION_SUBDIRECTORY_PATH));
        this.configurablePathListMap.put(ConfigurationService.ConfigurablePathListId.READABLE_CONFIGURATION_DIRS, this.readableConfigurationDirs);
        ArrayList<File> jdbcDriverDirs = new ArrayList<File>();
        this.addDirectoryIfPresent(jdbcDriverDirs, new File(installationDataRoot, JDBC_SUBDIRECTORY_PATH));
        this.configurablePathListMap.put(ConfigurationService.ConfigurablePathListId.JDBC_DRIVER_DIRS, jdbcDriverDirs);
        ArrayList<File> readableIntegrationDirs = new ArrayList<File>();
        this.addDirectoryIfPresent(readableIntegrationDirs, new File(installationDataRoot, INTEGRATION_SUBDIRECTORY_PATH));
        this.addDirectoryIfPresent(readableIntegrationDirs, this.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_INTEGRATION_DATA));
        this.configurablePathListMap.put(ConfigurationService.ConfigurablePathListId.READABLE_INTEGRATION_DIRS, readableIntegrationDirs);
        this.configurablePathMap.put(ConfigurationService.ConfigurablePathId.CONFIGURATION_SAMPLES_LOCATION, new File(installationDataRoot, "examples/configuration"));
        this.log.debug((Object)("Configured paths: " + this.configurablePathMap));
        this.log.debug((Object)("Configured path lists: " + this.configurablePathListMap));
        this.log.debug((Object)("Using instance output directory " + this.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_OUTPUT)));
    }

    private void definePathAlias(ConfigurationService.ConfigurablePathId aliasKey, ConfigurationService.ConfigurablePathId existingKey) {
        this.configurablePathMap.put(aliasKey, this.configurablePathMap.get((Object)existingKey));
    }

    private void addDirectoryIfPresent(List<File> pathList, File path) {
        if ((path = path.getAbsoluteFile()).isDirectory()) {
            pathList.add(path);
        }
    }

    private boolean configurePathFromOverridePropertyIfSet(ConfigurationService.ConfigurablePathId pathId, String overrideProperty) {
        String value = System.getProperty(overrideProperty);
        if (value == null) {
            return false;
        }
        File path = new File(value);
        if (!path.isAbsolute()) {
            this.log.warn((Object)StringUtils.format((String)"Value '%s' for path override setting '%s' will be ignored as it is not an absolute path", (Object[])new Object[]{value, overrideProperty}));
            return false;
        }
        if (!path.isDirectory()) {
            this.log.warn((Object)StringUtils.format((String)"Value '%s' for path override setting '%s' will be ignored as it does not point to an existing directory", (Object[])new Object[]{value, overrideProperty}));
            return false;
        }
        this.configurablePathMap.put(pathId, path);
        return true;
    }

    private void initializeRelativeProfilePath(ConfigurationService.ConfigurablePathId key, String relativePath) {
        File subDir = new File(this.profile.getProfileDirectory(), relativePath).getAbsoluteFile();
        subDir.mkdirs();
        if (!subDir.isDirectory()) {
            throw new RuntimeException("Unexpected state: Failed to initialize profile sub-directory " + subDir.getAbsolutePath());
        }
        this.configurablePathMap.put(key, subDir);
    }

    private File locateConfigurationFile(String fileName) {
        for (File configDir : this.readableConfigurationDirs) {
            File file = new File(configDir, fileName);
            if (!file.isFile()) continue;
            return file;
        }
        return null;
    }

    private String performSubstitutions(String input, File originFile) {
        if (this.substitutionProperties.isEmpty()) {
            return input;
        }
        Pattern pattern = Pattern.compile("\\$\\{(\\w+:\\w+)\\}");
        StringBuffer buffer = new StringBuffer(input.length());
        Matcher m = pattern.matcher(input);
        while (m.find()) {
            String key = m.group(1);
            String value = this.substitutionProperties.get(key);
            if (value == null) {
                throw new IllegalArgumentException("Missing configuration value for \"" + key + "\" in file " + originFile.getAbsolutePath());
            }
            m.appendReplacement(buffer, value);
        }
        m.appendTail(buffer);
        return buffer.toString();
    }

    private String getSystemTempDir() {
        return System.getProperty("java.io.tmpdir");
    }

    @Override
    public boolean isUsingDefaultConfigurationValues() {
        return this.usingDefaultConfigurationValues;
    }

    @Override
    public double[] getLocationCoordinates() {
        return this.generalSettings.getLocation();
    }

    @Override
    public String getLocationName() {
        return this.generalSettings.getLocationName();
    }

    @Override
    public String getInstanceContact() {
        return this.generalSettings.getContact();
    }

    @Override
    public String getInstanceAdditionalInformation() {
        return this.generalSettings.getAdditionalInformation();
    }
}

