/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.integration;

import de.rcenvironment.core.component.model.configuration.api.ReadOnlyConfiguration;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.integration.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TempDirectorySection
extends ValidatingWorkflowNodePropertySection {
    private Button neverDeleteTempDirectoryButton;
    private Button onceDeleteTempDirectoryButton;
    private Button alwaysDeleteTempDirectoryButton;
    private Button onSuccessDeleteTempDirectoryButton;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayoutData((Object)new GridData(1808));
        parent.setLayout((Layout)new GridLayout(1, true));
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setData("property.control", (Object)"chosenDeleteTempDirBehavior");
        Section scriptSection = this.getWidgetFactory().createSection(composite, 256);
        scriptSection.setLayoutData((Object)new GridData(1808));
        scriptSection.setText(Messages.tempDirectorySection);
        Composite scriptComposite = this.getWidgetFactory().createFlatFormComposite((Composite)scriptSection);
        scriptComposite.setLayout((Layout)new GridLayout(1, true));
        scriptComposite.setLayoutData((Object)new GridData(1808));
        new Label(scriptComposite, 0).setText("Choose the deletion behavior for working directory(ies):");
        this.neverDeleteTempDirectoryButton = new Button(scriptComposite, 16);
        this.neverDeleteTempDirectoryButton.setText("Do not delete working directory(ies)");
        this.neverDeleteTempDirectoryButton.addSelectionListener((SelectionListener)new DeleteTempDirectorySelectionListener("deleteWorkingDirectoriesNever"));
        this.onceDeleteTempDirectoryButton = new Button(scriptComposite, 16);
        this.onceDeleteTempDirectoryButton.setText("Delete working directory(ies) after workflow execution");
        this.onceDeleteTempDirectoryButton.addSelectionListener((SelectionListener)new DeleteTempDirectorySelectionListener("deleteWorkingDirectoriesAfterWorkflowExecution"));
        this.alwaysDeleteTempDirectoryButton = new Button(scriptComposite, 16);
        this.alwaysDeleteTempDirectoryButton.setText("Delete working directory(ies) after every run");
        this.alwaysDeleteTempDirectoryButton.addSelectionListener((SelectionListener)new DeleteTempDirectorySelectionListener("deleteWorkingDirectoriesAfterIteration"));
        this.onSuccessDeleteTempDirectoryButton = new Button(scriptComposite, 32);
        this.onSuccessDeleteTempDirectoryButton.setText("Keep working directory(ies) in case of failure");
        this.onSuccessDeleteTempDirectoryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                TempDirectorySection.this.setProperty("keepOnFailure", "" + TempDirectorySection.this.onSuccessDeleteTempDirectoryButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        scriptSection.setClient((Control)scriptComposite);
        this.onSuccessDeleteTempDirectoryButton.setData("property.control", (Object)"keepOnFailure");
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.setActivationOfCheckboxes();
    }

    private void determineDeletionBehaviour(boolean deleteNeverActive, boolean deleteOnceActive, boolean deleteAlwaysActive) {
        if (deleteOnceActive) {
            this.onceDeleteTempDirectoryButton.setSelection(true);
            this.setPropertyNotUndoable("chosenDeleteTempDirBehavior", "deleteWorkingDirectoriesAfterWorkflowExecution");
        } else if (deleteNeverActive) {
            this.neverDeleteTempDirectoryButton.setSelection(true);
            this.setPropertyNotUndoable("chosenDeleteTempDirBehavior", "deleteWorkingDirectoriesNever");
        } else if (deleteAlwaysActive) {
            this.setPropertyNotUndoable("chosenDeleteTempDirBehavior", "deleteWorkingDirectoriesAfterIteration");
            this.alwaysDeleteTempDirectoryButton.setSelection(true);
        }
    }

    public void refreshSection() {
        super.refreshSection();
        this.aboutToBeShown();
    }

    protected TempSectionUpdater createUpdater() {
        return new TempSectionUpdater();
    }

    private void setActivationOfCheckboxes() {
        ReadOnlyConfiguration readOnlyconfig = this.getConfiguration().getConfigurationDescription().getComponentConfigurationDefinition().getReadOnlyConfiguration();
        boolean deleteNeverActive = Boolean.parseBoolean(readOnlyconfig.getValue("deleteWorkingDirectoriesNever"));
        boolean deleteOnceActive = Boolean.parseBoolean(readOnlyconfig.getValue("deleteWorkingDirectoriesAfterWorkflowExecution"));
        boolean deleteAlwaysActive = Boolean.parseBoolean(readOnlyconfig.getValue("deleteWorkingDirectoriesAfterIteration"));
        this.neverDeleteTempDirectoryButton.setEnabled(deleteNeverActive);
        this.onceDeleteTempDirectoryButton.setEnabled(deleteOnceActive);
        this.alwaysDeleteTempDirectoryButton.setEnabled(deleteAlwaysActive);
        this.onceDeleteTempDirectoryButton.setSelection(false);
        this.alwaysDeleteTempDirectoryButton.setSelection(false);
        this.neverDeleteTempDirectoryButton.setSelection(false);
        String chosen = this.getProperty("chosenDeleteTempDirBehavior");
        if (chosen != null) {
            if (chosen.equals("deleteWorkingDirectoriesAfterWorkflowExecution") && deleteOnceActive) {
                this.onceDeleteTempDirectoryButton.setSelection(true);
            } else if (chosen.equals("deleteWorkingDirectoriesAfterIteration") && deleteAlwaysActive) {
                this.alwaysDeleteTempDirectoryButton.setSelection(true);
            } else if (chosen.equals("deleteWorkingDirectoriesNever") && deleteNeverActive) {
                this.neverDeleteTempDirectoryButton.setSelection(true);
            } else {
                this.determineDeletionBehaviour(deleteNeverActive, deleteOnceActive, deleteAlwaysActive);
            }
        } else {
            this.determineDeletionBehaviour(deleteNeverActive, deleteOnceActive, deleteAlwaysActive);
        }
        this.onSuccessDeleteTempDirectoryButton.setEnabled(this.isKeepButtonActive());
        this.onSuccessDeleteTempDirectoryButton.setSelection(this.isKeepButtonActive() && Boolean.parseBoolean(this.getProperty("keepOnFailure")));
        this.setPropertyNotUndoable("keepOnFailure", "" + this.onSuccessDeleteTempDirectoryButton.getSelection());
    }

    private boolean isKeepButtonActive() {
        boolean onceActiveAndPermitted;
        ReadOnlyConfiguration readOnlyconfig = this.getConfiguration().getConfigurationDescription().getComponentConfigurationDefinition().getReadOnlyConfiguration();
        boolean alwaysActiveAndPermitted = this.alwaysDeleteTempDirectoryButton.getSelection() && Boolean.parseBoolean(readOnlyconfig.getValue("deleteWorkingDirectoriesKeepOnErrorIteration"));
        boolean bl = onceActiveAndPermitted = this.onceDeleteTempDirectoryButton.getSelection() && Boolean.parseBoolean(readOnlyconfig.getValue("deleteWorkingDirectoriesKeepOnErrorOnce"));
        return alwaysActiveAndPermitted || onceActiveAndPermitted;
    }

    private class DeleteTempDirectorySelectionListener
    implements SelectionListener {
        private final String key;

        DeleteTempDirectorySelectionListener(String key) {
            this.key = key;
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }

        public void widgetSelected(SelectionEvent arg0) {
            TempDirectorySection.this.setProperty("chosenDeleteTempDirBehavior", this.key);
            TempDirectorySection.this.setActivationOfCheckboxes();
        }
    }

    protected class TempSectionUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected TempSectionUpdater() {
            super((WorkflowNodePropertySection)TempDirectorySection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            super.updateControl(control, propertyName, newValue, oldValue);
            TempDirectorySection.this.setActivationOfCheckboxes();
        }
    }
}

