/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import de.rcenvironment.core.gui.communication.views.contributors.CustomPasteHandler;
import de.rcenvironment.core.gui.utils.incubator.PasteListeningText;
import de.rcenvironment.core.utils.common.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractSshConnectionDialog
extends Dialog
implements PasteListeningText.PasteListener,
VerifyListener {
    private static final String KEYFILE_AUTH_WITH_PASSPHRASE = "Keyfile with passphrase protection";
    private static final String KEYFILE_AUTH_WITHOUT_PASSPHRASE = "Keyfile without passphrase protection";
    private static final String PASSPHRASE_AUTH = "Passphrase";
    private static final int DIALOG_WINDOW_OFFSET_Y = 100;
    private static final int DIALOG_WINDOW_OFFSET_X = 150;
    private static final String COLON = ":";
    private static final String NAME_LABEL = "Name:";
    private static final String HOST_LABEL = "Host:";
    private static final String PORT_LABEL = "Port:";
    private static final String USERNAME_LABEL = "Username:";
    private static final String AUTH_TYPE_LABEL = "Authentication type:";
    private static final String KEYFILE_LABEL = "SSH key file:";
    private static final String PASSPHRASE_LABEL = "Passphrase:";
    private static Text portTextField;
    private static PasteListeningText hostTextField;
    protected String connectionName = "";
    protected String host = "";
    protected String port = "";
    protected String username = "";
    protected String passphrase = "";
    protected String keyfileLocation = "";
    protected String hint = "";
    protected String networkContactPointID = "";
    private boolean storePassphrase = true;
    private boolean useKeyFile = false;
    private boolean connectImmediately = true;
    private boolean autoRetry = true;
    private boolean usePassphrase = true;
    private Button useDefaultNameButton;
    private Button storePasswordButton;
    private Button immediateConnectButton;
    private Button autoRetryButton;
    private Label nameLabel;
    private boolean isDefaultName = true;

    protected AbstractSshConnectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public AbstractSshConnectionDialog(Shell parentShell, String connectionName, String host, int port, String username, String keyfileLocation, boolean usePassphrase, boolean storePassphrase, boolean connectImmediately, boolean autoRetry) {
        super(parentShell);
        this.connectionName = connectionName;
        this.host = host;
        this.port = Integer.toString(port);
        String hostAndPortString = StringUtils.format((String)"%s:%s", (Object[])new Object[]{host, port});
        this.username = username;
        this.connectImmediately = connectImmediately;
        this.autoRetry = autoRetry;
        this.storePassphrase = storePassphrase;
        this.isDefaultName = connectionName.equals(hostAndPortString);
        this.keyfileLocation = keyfileLocation;
        if (keyfileLocation == null) {
            this.keyfileLocation = "";
        }
        this.useKeyFile = !this.keyfileLocation.isEmpty();
        this.usePassphrase = usePassphrase;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (shell.getHorizontalBar() != null) {
            shell.getHorizontalBar().dispose();
        }
        shell.setLocation(shell.getParent().getLocation().x + shell.getParent().getSize().x / 2 - 150, shell.getParent().getLocation().y + shell.getParent().getSize().y / 2 - 100);
        shell.setText("Connection");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        GridData containerGridData = new GridData(4, 4, false, false);
        container.setLayoutData((Object)containerGridData);
        container.setLayout((Layout)layout);
        GridData useDefaultCheckboxGridData = new GridData();
        useDefaultCheckboxGridData.horizontalSpan = 1;
        GridData storePassphraseCheckboxGridData = new GridData();
        storePassphraseCheckboxGridData.horizontalSpan = 1;
        GridData connectImmediateCheckboxGridData = new GridData();
        connectImmediateCheckboxGridData.horizontalSpan = 2;
        GridData autoRetryCheckboxGridData = new GridData();
        autoRetryCheckboxGridData.horizontalSpan = 2;
        Label cpLabelHost = new Label(container, 0);
        cpLabelHost.setText(HOST_LABEL);
        hostTextField = new PasteListeningText(container, 2052);
        hostTextField.setLayoutData((Object)new GridData(256));
        if (!this.host.isEmpty()) {
            hostTextField.setText(this.host);
        }
        hostTextField.addPasteListener((PasteListeningText.PasteListener)this);
        Label cpLabelPort = new Label(container, 0);
        cpLabelPort.setText(PORT_LABEL);
        portTextField = new Text(container, 2052);
        portTextField.setLayoutData((Object)new GridData(256));
        if (!this.port.isEmpty()) {
            portTextField.setText(this.port);
        }
        portTextField.addVerifyListener((VerifyListener)this);
        GridData separatorGridData = new GridData();
        separatorGridData.horizontalAlignment = 4;
        separatorGridData.grabExcessHorizontalSpace = true;
        separatorGridData.horizontalSpan = 2;
        this.nameLabel = new Label(container, 0);
        this.nameLabel.setText(NAME_LABEL);
        final Text nameText = new Text(container, 2052);
        nameText.setLayoutData((Object)new GridData(256));
        nameText.setText(this.connectionName);
        nameText.setEnabled(!this.isDefaultName);
        Label placeholderLabel = new Label(container, 0);
        placeholderLabel.setText("");
        this.useDefaultNameButton = new Button(container, 32);
        this.useDefaultNameButton.setText("Use default name (host:port)");
        this.useDefaultNameButton.setLayoutData((Object)useDefaultCheckboxGridData);
        this.useDefaultNameButton.setSelection(this.isDefaultName);
        this.useDefaultNameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                nameText.setEnabled(!AbstractSshConnectionDialog.this.useDefaultNameButton.getSelection());
                nameText.setText("");
                if (AbstractSshConnectionDialog.this.useDefaultNameButton.getSelection() && !hostTextField.getText().isEmpty() && !portTextField.getText().isEmpty()) {
                    nameText.setText(String.valueOf(hostTextField.getText()) + AbstractSshConnectionDialog.COLON + portTextField.getText());
                }
                AbstractSshConnectionDialog.this.updateOkButtonActivation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
        Label usernameLabel = new Label(container, 0);
        usernameLabel.setText(USERNAME_LABEL);
        Text usernameText = new Text(container, 2052);
        usernameText.setLayoutData((Object)new GridData(256));
        usernameText.setText(this.username);
        Label authTypeLabel = new Label(container, 0);
        authTypeLabel.setText(AUTH_TYPE_LABEL);
        Combo authTypeCombo = new Combo(container, 8);
        String[] authTypes = new String[]{PASSPHRASE_AUTH, KEYFILE_AUTH_WITH_PASSPHRASE, KEYFILE_AUTH_WITHOUT_PASSPHRASE};
        authTypeCombo.setItems(authTypes);
        if (this.useKeyFile) {
            if (this.usePassphrase) {
                authTypeCombo.select(1);
            } else {
                authTypeCombo.select(2);
            }
        } else {
            authTypeCombo.select(0);
        }
        Label keyfileLabel = new Label(container, 0);
        keyfileLabel.setText(KEYFILE_LABEL);
        keyfileLabel.setVisible(this.useKeyFile);
        Composite keyfileComposite = new Composite(container, 0);
        GridLayout klayout = new GridLayout(2, false);
        keyfileComposite.setLayout((Layout)klayout);
        keyfileComposite.setVisible(this.useKeyFile);
        keyfileComposite.setLayoutData((Object)new GridData(768));
        Text keyfileText = new Text(keyfileComposite, 2052);
        keyfileText.setLayoutData((Object)new GridData(768));
        keyfileText.setText(this.keyfileLocation);
        this.createFileChooserButton(parent, keyfileComposite, keyfileText);
        Label passphraseLabel = new Label(container, 0);
        passphraseLabel.setText(PASSPHRASE_LABEL);
        passphraseLabel.setVisible(this.usePassphrase);
        Text passphraseText = new Text(container, 2052);
        passphraseText.setLayoutData((Object)new GridData(256));
        passphraseText.setText(this.passphrase);
        passphraseText.setEchoChar('*');
        passphraseText.setVisible(this.usePassphrase);
        new Label(container, 0);
        this.storePasswordButton = new Button(container, 32);
        this.storePasswordButton.setSelection(true);
        this.storePasswordButton.setText("Store passphrase");
        this.storePasswordButton.setLayoutData((Object)storePassphraseCheckboxGridData);
        this.storePasswordButton.setSelection(this.storePassphrase);
        this.storePasswordButton.setVisible(this.usePassphrase);
        this.createButtonsAndHint(container, connectImmediateCheckboxGridData, autoRetryCheckboxGridData, separatorGridData);
        this.defineListenerForAuthenticationType(authTypeCombo, keyfileLabel, keyfileComposite, passphraseLabel, passphraseText);
        this.initVariablesAndCreateListeners(hostTextField, portTextField, nameText, usernameText, passphraseText, keyfileText);
        return container;
    }

    private void createButtonsAndHint(Composite container, GridData connectImmediateCheckboxGridData, GridData autoRetryCheckboxGridData, GridData separatorGridData) {
        Label separator = new Label(container, 258);
        separator.setLayoutData((Object)separatorGridData);
        this.immediateConnectButton = new Button(container, 32);
        this.immediateConnectButton.setSelection(this.connectImmediately);
        this.immediateConnectButton.setText("Connect immediately");
        this.immediateConnectButton.setLayoutData((Object)connectImmediateCheckboxGridData);
        this.autoRetryButton = new Button(container, 32);
        this.autoRetryButton.setSelection(this.autoRetry);
        this.autoRetryButton.setText("Try reconnect after error (requires stored passphrase)");
        this.autoRetryButton.setLayoutData((Object)autoRetryCheckboxGridData);
        Label persistHint = new Label(container, 0);
        GridData hintGridData = new GridData();
        hintGridData.horizontalSpan = 2;
        persistHint.setText(this.hint);
        persistHint.setLayoutData((Object)hintGridData);
    }

    public void paste(String text) {
        CustomPasteHandler.paste(text, (Text)hostTextField, portTextField);
    }

    public void verifyText(VerifyEvent e) {
        String currentText = ((Text)e.widget).getText();
        String portID = String.valueOf(currentText.substring(0, e.start)) + e.text + currentText.substring(e.end);
        e.doit = CustomPasteHandler.isValidPort(portID);
    }

    private void defineListenerForAuthenticationType(final Combo authTypeCombo, final Label keyfileLabel, final Composite keyfileComposite, final Label passphraseLabel, final Text passphraseText) {
        authTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                AbstractSshConnectionDialog.this.useKeyFile = authTypeCombo.getText().equals(AbstractSshConnectionDialog.KEYFILE_AUTH_WITH_PASSPHRASE) || authTypeCombo.getText().equals(AbstractSshConnectionDialog.KEYFILE_AUTH_WITHOUT_PASSPHRASE);
                AbstractSshConnectionDialog.this.usePassphrase = !authTypeCombo.getText().equals(AbstractSshConnectionDialog.KEYFILE_AUTH_WITHOUT_PASSPHRASE);
                keyfileLabel.setVisible(AbstractSshConnectionDialog.this.useKeyFile);
                keyfileComposite.setVisible(AbstractSshConnectionDialog.this.useKeyFile);
                passphraseLabel.setVisible(AbstractSshConnectionDialog.this.usePassphrase);
                passphraseText.setVisible(AbstractSshConnectionDialog.this.usePassphrase);
                AbstractSshConnectionDialog.this.storePasswordButton.setVisible(AbstractSshConnectionDialog.this.usePassphrase);
                AbstractSshConnectionDialog.this.autoRetryButton.setEnabled(!AbstractSshConnectionDialog.this.usePassphrase || AbstractSshConnectionDialog.this.storePassphrase);
                if (!AbstractSshConnectionDialog.this.storePassphrase) {
                    AbstractSshConnectionDialog.this.autoRetryButton.setSelection(false);
                    AbstractSshConnectionDialog.this.autoRetry = false;
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    private void createFileChooserButton(final Composite parent, Composite container, final Text keyfileText) {
        Button keyfileButton = new Button(container, 0);
        keyfileButton.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        keyfileButton.setText("...");
        keyfileButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog dialog = new FileDialog(parent.getShell());
                dialog.setText("Choose private key file");
                String result = dialog.open();
                if (result != null) {
                    keyfileText.setText(result);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    private void initVariablesAndCreateListeners(PasteListeningText hostTextFieldInit, Text portTextFieldInit, final Text nameTextInit, final Text usernameText, final Text passphraseText, final Text keyfileText) {
        hostTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractSshConnectionDialog.this.host = hostTextField.getText();
                if (AbstractSshConnectionDialog.this.useDefaultNameButton.getSelection()) {
                    if (!hostTextField.getText().isEmpty() && !portTextField.getText().isEmpty()) {
                        nameTextInit.setText(String.valueOf(hostTextField.getText()) + AbstractSshConnectionDialog.COLON + portTextField.getText());
                    } else {
                        nameTextInit.setText("");
                    }
                }
                AbstractSshConnectionDialog.this.updateOkButtonActivation();
            }
        });
        portTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractSshConnectionDialog.this.port = portTextField.getText();
                if (AbstractSshConnectionDialog.this.useDefaultNameButton.getSelection()) {
                    if (!hostTextField.getText().isEmpty() && !portTextField.getText().isEmpty()) {
                        nameTextInit.setText(String.valueOf(hostTextField.getText()) + AbstractSshConnectionDialog.COLON + portTextField.getText());
                    } else {
                        nameTextInit.setText("");
                    }
                }
                AbstractSshConnectionDialog.this.updateOkButtonActivation();
            }
        });
        this.connectionName = nameTextInit.getText();
        nameTextInit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractSshConnectionDialog.this.connectionName = nameTextInit.getText();
            }
        });
        this.username = usernameText.getText();
        usernameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AbstractSshConnectionDialog.this.username = usernameText.getText();
                AbstractSshConnectionDialog.this.updateOkButtonActivation();
            }
        });
        this.passphrase = passphraseText.getText();
        passphraseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AbstractSshConnectionDialog.this.passphrase = passphraseText.getText();
            }
        });
        this.keyfileLocation = keyfileText.getText();
        keyfileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                AbstractSshConnectionDialog.this.keyfileLocation = keyfileText.getText();
            }
        });
        this.connectImmediately = this.immediateConnectButton.getSelection();
        this.immediateConnectButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractSshConnectionDialog.this.connectImmediately = AbstractSshConnectionDialog.this.immediateConnectButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.autoRetry = this.autoRetryButton.getSelection();
        this.autoRetryButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractSshConnectionDialog.this.autoRetry = AbstractSshConnectionDialog.this.autoRetryButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.storePassphrase = this.storePasswordButton.getSelection();
        this.storePasswordButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                AbstractSshConnectionDialog.this.storePassphrase = AbstractSshConnectionDialog.this.storePasswordButton.getSelection();
                AbstractSshConnectionDialog.this.autoRetryButton.setEnabled(AbstractSshConnectionDialog.this.storePassphrase);
                if (!AbstractSshConnectionDialog.this.storePassphrase) {
                    AbstractSshConnectionDialog.this.autoRetryButton.setSelection(false);
                    AbstractSshConnectionDialog.this.autoRetry = false;
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        this.useDefaultNameButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (AbstractSshConnectionDialog.this.useDefaultNameButton.getSelection()) {
                    nameTextInit.setEnabled(false);
                    if (!hostTextField.getText().isEmpty() && !portTextField.getText().isEmpty()) {
                        nameTextInit.setText(String.valueOf(hostTextField.getText()) + AbstractSshConnectionDialog.COLON + portTextField.getText());
                    } else {
                        nameTextInit.setText("");
                    }
                } else {
                    nameTextInit.setEnabled(true);
                    nameTextInit.setText("");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }
        });
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateOkButtonActivation();
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        parent.getShell().pack();
        return buttonBar;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(67936);
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return Integer.parseInt(this.port);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassphrase() {
        if (this.usePassphrase) {
            return this.passphrase;
        }
        return null;
    }

    public String getKeyfileLocation() {
        if (this.useKeyFile) {
            return this.keyfileLocation;
        }
        return null;
    }

    public boolean getConnectImmediately() {
        return this.connectImmediately;
    }

    public boolean getAutoRetry() {
        return this.autoRetry;
    }

    protected void activateDefaultName() {
        this.isDefaultName = true;
    }

    protected void deactivateDefaultName() {
        this.isDefaultName = false;
    }

    public boolean shouldStorePassPhrase() {
        if (this.usePassphrase) {
            return this.storePassphrase;
        }
        return false;
    }

    public boolean getUsePassphrase() {
        return this.usePassphrase;
    }

    protected void updateOkButtonActivation() {
        this.getButton(0).setEnabled(!this.host.isEmpty() && !this.port.isEmpty() && !this.username.isEmpty());
    }
}

