/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui;

import com.googlecode.lanterna.gui.GUIScreenBackgroundRenderer;
import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.TerminalPosition;

public class DefaultBackgroundRenderer
implements GUIScreenBackgroundRenderer {
    private String title;
    private boolean showMemoryUsage;

    public DefaultBackgroundRenderer() {
        this("");
    }

    public DefaultBackgroundRenderer(String title) {
        this.title = title;
        this.showMemoryUsage = false;
    }

    @Override
    public void drawBackground(TextGraphics textGraphics) {
        textGraphics.applyTheme(Theme.Category.SCREEN_BACKGROUND);
        textGraphics.fillRectangle(' ', new TerminalPosition(0, 0), textGraphics.getSize());
        textGraphics.drawString(3, 0, this.title, new ScreenCharacterStyle[0]);
        if (this.showMemoryUsage) {
            Runtime runtime = Runtime.getRuntime();
            long freeMemory = runtime.freeMemory();
            long totalMemory = runtime.totalMemory();
            long usedMemory = totalMemory - freeMemory;
            String memUsageString = "Memory usage: " + (usedMemory /= 0x100000L) + " MB of " + (totalMemory /= 0x100000L) + " MB";
            textGraphics.drawString(textGraphics.getSize().getColumns() - memUsageString.length() - 1, textGraphics.getSize().getRows() - 1, memUsageString, new ScreenCharacterStyle[0]);
        }
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setShowMemoryUsage(boolean showMemoryUsage) {
        this.showMemoryUsage = showMemoryUsage;
    }

    public boolean isShowingMemoryUsage() {
        return this.showMemoryUsage;
    }
}

