/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.network.channel.internal;

import de.rcenvironment.core.communication.uplink.client.execution.api.ToolExecutionProviderEventCollector;
import de.rcenvironment.core.communication.uplink.network.channel.internal.ToolExecutionProviderEventTransferObject;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchAggregator;
import de.rcenvironment.toolkit.modules.concurrency.api.ConcurrencyUtilsFactory;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.logging.LogFactory;

public class ToolExecutionProviderEventCollectorImpl
implements ToolExecutionProviderEventCollector {
    private static final int MAX_BATCH_SIZE = 50;
    private static final long MAX_BATCH_LATENCY = 500L;
    private static final int MAX_QUEUED_EVENTS = 1000;
    private static final int MAX_TIME_TO_WAIT_FOR_QUEUE_COMPLETION_MSEC = 5000;
    private final BatchAggregator<ToolExecutionProviderEventTransferObject> batchAggregator;
    private final Semaphore maxQueuedEventsSemaphore = new Semaphore(1000);
    private boolean shutDown;
    private final Object shutDownLock = new Object();
    private Consumer<List<ToolExecutionProviderEventTransferObject>> batchConsumer;

    public ToolExecutionProviderEventCollectorImpl(Consumer<List<ToolExecutionProviderEventTransferObject>> batchConsumer, ConcurrencyUtilsFactory concurrencyUtilsFactory) {
        this.batchConsumer = batchConsumer;
        this.batchAggregator = concurrencyUtilsFactory.createBatchAggregator(50, 500L, this::enqueueBatchOfTransferObjectsForSending);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitEvent(String type, String data) {
        Object object = this.shutDownLock;
        synchronized (object) {
            if (this.shutDown) {
                LogFactory.getLog(this.getClass()).warn((Object)("Dropping execution event as the event forwarder has already been shut down: Type='" + type + "', data='" + data + "'"));
                return;
            }
        }
        try {
            this.maxQueuedEventsSemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            LogFactory.getLog(this.getClass()).warn((Object)("Dropping execution event due to interruption while waiting for space in the outgoing queue: Type='" + type + "', data='" + data + "'"));
            Thread.currentThread().interrupt();
        }
        this.batchAggregator.enqueue((Object)new ToolExecutionProviderEventTransferObject(type, data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownAndAwaitCompletion() throws InterruptedException {
        Object object = this.shutDownLock;
        synchronized (object) {
            this.shutDown = true;
        }
        if (!this.maxQueuedEventsSemaphore.tryAcquire(1000, 5000L, TimeUnit.MILLISECONDS)) {
            LogFactory.getLog(this.getClass()).warn((Object)"Waited for the outgoing event queue to complete for the maximum wait time of 5000 msec");
        }
    }

    private void enqueueBatchOfTransferObjectsForSending(List<ToolExecutionProviderEventTransferObject> batch) {
        this.batchConsumer.accept(batch);
        this.maxQueuedEventsSemaphore.release(batch.size());
    }
}

