/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Field;
import org.easymock.internal.Injection;

public class InjectionTarget {
    private final Field targetField;

    public InjectionTarget(Field f) {
        this.targetField = f;
    }

    public boolean accepts(Injection injection) {
        return this.targetField.getType().isAssignableFrom(injection.getMock().getClass());
    }

    public void inject(Object obj, Injection injection) {
        this.targetField.setAccessible(true);
        try {
            this.targetField.set(obj, injection.getMock());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        injection.setMatched();
    }

    public Field getTargetField() {
        return this.targetField;
    }
}

