/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.doe.execution.validator;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.doe.common.DOEAlgorithms;
import de.rcenvironment.components.doe.execution.Messages;
import de.rcenvironment.core.component.model.api.ComponentDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.validation.api.ComponentValidationMessage;
import de.rcenvironment.core.component.validation.spi.AbstractLoopComponentValidator;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DOEComponentValidator
extends AbstractLoopComponentValidator {
    public String getIdentifier() {
        return "de.rcenvironment.doe.v2";
    }

    protected List<ComponentValidationMessage> validateLoopComponentSpecific(ComponentDescription componentDescription) {
        ArrayList<ComponentValidationMessage> messages = new ArrayList<ComponentValidationMessage>();
        boolean hasOutputs = !this.getOutputs(componentDescription).isEmpty();
        int outputCount = this.getOutputs(componentDescription).size();
        String methodName = this.getProperty(componentDescription, "method");
        int runNumber = Integer.parseInt(this.getProperty(componentDescription, "runNumber"));
        if (methodName.equals("Custom design table") || methodName.equals("Monte Carlo design") || methodName.equals("Custom design table as input")) {
            if (!hasOutputs) {
                ComponentValidationMessage outputTooLow = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "method", Messages.minOneOutput, Messages.minOneOutput);
                messages.add(outputTooLow);
                return messages;
            }
        } else if (!hasOutputs || outputCount < 2) {
            ComponentValidationMessage outputTooLow = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "method", Messages.minTwoOutputs, Messages.minTwoOutputs);
            messages.add(outputTooLow);
            return messages;
        }
        if (runNumber == 0) {
            ComponentValidationMessage noRun = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "runNumber", Messages.noRunNumber, Messages.noRunNumber);
            messages.add(noRun);
            return messages;
        }
        ComponentValidationMessage tooManySamplesMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "", Messages.tooManySamples, Messages.tooManySamples);
        if (methodName.equals("Full factorial design")) {
            if (Math.pow(runNumber, outputCount) >= DOEAlgorithms.MAXMIMAL_RUNS) {
                messages.add(tooManySamplesMessage);
                return messages;
            }
        } else if ((double)runNumber >= DOEAlgorithms.MAXMIMAL_RUNS) {
            messages.add(tooManySamplesMessage);
            return messages;
        }
        if (methodName.equals("Full factorial design") && runNumber < 2) {
            ComponentValidationMessage noInputMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "runNumber", Messages.numLevelsInvalid, Messages.numLevelsInvalid);
            messages.add(noInputMessage);
            return messages;
        }
        if (methodName.equals("Custom design table")) {
            this.checkStartAndEndSample(componentDescription, messages);
            this.checkTableDimensions(componentDescription, messages);
        }
        return messages;
    }

    protected List<ComponentValidationMessage> validateOnWorkflowStartComponentSpecific(ComponentDescription componentDescription) {
        return null;
    }

    private void checkTableDimensions(ComponentDescription componentDescription, List<ComponentValidationMessage> messages) {
        String table = this.getProperty(componentDescription, "table");
        if (table == null || table.isEmpty() || table.equals("null")) {
            ComponentValidationMessage startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "table", Messages.noTable, Messages.noTable);
            messages.add(startSampleErrorMessage);
        } else {
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            try {
                ComponentValidationMessage startSampleErrorMessage;
                Double[][] tableValues = (Double[][])mapper.readValue(table, Double[][].class);
                if (tableValues != null && tableValues.length > 0 && tableValues[0] != null && tableValues[0].length < this.getOutputs(componentDescription).size()) {
                    startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "table", Messages.tableTooShort, Messages.tableTooShort);
                    messages.add(startSampleErrorMessage);
                }
                if (tableValues != null && tableValues.length > 0 && tableValues[0].length > this.getOutputs(componentDescription).size()) {
                    startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.WARNING, "table", Messages.tableTooLong, Messages.tableTooLong);
                    messages.add(startSampleErrorMessage);
                }
                ComponentValidationMessage noValueError = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "table", Messages.undefinedValues, Messages.undefinedValues);
                int runNumber = Integer.parseInt(this.getProperty(componentDescription, "runNumber"));
                int i = 0;
                while (i < runNumber && tableValues != null && i < tableValues.length) {
                    int j = 0;
                    while (j < tableValues[i].length) {
                        if (tableValues[i][j] == null) {
                            messages.add(noValueError);
                            break;
                        }
                        ++j;
                    }
                    if (!messages.contains(noValueError)) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                ComponentValidationMessage startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "table", Messages.cannotReadTable, Messages.cannotReadTable);
                messages.add(startSampleErrorMessage);
            }
        }
    }

    private void checkStartAndEndSample(ComponentDescription componentDescription, Collection<ComponentValidationMessage> messages) {
        String endSampleString;
        String startSampleString = this.getProperty(componentDescription, "startSample");
        if (startSampleString.isEmpty()) {
            ComponentValidationMessage startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "startSample", Messages.noStartSample, Messages.noStartSample);
            messages.add(startSampleErrorMessage);
        }
        if ((endSampleString = this.getProperty(componentDescription, "endSample")).isEmpty()) {
            ComponentValidationMessage startSampleErrorMessage = new ComponentValidationMessage(ComponentValidationMessage.Type.ERROR, "endSample", Messages.noEndSample, Messages.noEndSample);
            messages.add(startSampleErrorMessage);
        }
    }

    protected Set<EndpointDescription> getOutputs(ComponentDescription componentDescription) {
        HashSet<EndpointDescription> outputs = new HashSet<EndpointDescription>(super.getOutputs(componentDescription));
        Iterator outputsIterator = outputs.iterator();
        while (outputsIterator.hasNext()) {
            EndpointDescription next = (EndpointDescription)outputsIterator.next();
            if (!"toForward".equals(next.getDynamicEndpointIdentifier()) && !"Done".equals(next.getName()) && !"Number of samples".equals(next.getName())) continue;
            outputsIterator.remove();
        }
        return outputs;
    }
}

