/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.doe.execution;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.doe.common.DOEAlgorithms;
import de.rcenvironment.components.doe.common.DOEComponentHistoryDataItem;
import de.rcenvironment.components.doe.common.DOEUtils;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.ComponentHistoryDataItem;
import de.rcenvironment.core.component.execution.api.Component;
import de.rcenvironment.core.component.execution.api.ThreadHandler;
import de.rcenvironment.core.component.model.spi.AbstractNestedLoopComponent;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DOEComponent
extends AbstractNestedLoopComponent {
    private static final int MINUS_ONE = -1;
    private static final String PLACEHOLDER_STRING = "%s: %s";
    private static final String WROTE_VALUE_TO_OUTPUT_TEXT = "Wrote to output '%s': %s";
    private static final Log LOGGER = LogFactory.getLog(DOEComponent.class);
    private Double[][] valuesTable;
    private final Map<Integer, Map<String, Double>> resultData = new HashMap<Integer, Map<String, Double>>();
    private int runNumber = 0;
    private int endSample = -1;
    private DOEComponentHistoryDataItem historyDataItem;
    private FileReferenceTD tableFileReference;
    private Double[][] codedValues;
    private List<String> outputs;
    private boolean isDone;
    private File tableFile;
    private volatile boolean canceled = false;
    private String method = "";

    public void startNestedComponentSpecific() throws ComponentException {
        this.outputs = new LinkedList<String>(this.componentContext.getOutputs());
        this.removeOutputsNotConsidered();
        Collections.sort(this.outputs);
        this.method = this.componentContext.getConfigurationValue("method");
        int runNumberCount = Integer.parseInt(this.componentContext.getConfigurationValue("runNumber"));
        int seedNumber = 0;
        if (this.componentContext.getConfigurationValue("seedNumber") != null) {
            seedNumber = Integer.parseInt(this.componentContext.getConfigurationValue("seedNumber"));
        }
        this.valuesTable = new Double[0][0];
        if (!(this.method.equals("Custom design table") || this.method.equals("Monte Carlo design") || this.method.equals("Custom design table as input") || this.outputs.size() >= 2)) {
            throw new ComponentException("Number of outputs for chosen method too few - must be >=2, but is " + this.outputs.size());
        }
        switch (this.method) {
            case "Full factorial design": {
                if (runNumberCount >= 2) {
                    this.valuesTable = DOEAlgorithms.populateTableFullFactorial((int)this.outputs.size(), (int)runNumberCount);
                    if (this.valuesTable.length != 0) break;
                    throw new ComponentException("The chosen configuration produced too many samples");
                }
                throw new ComponentException("Level number for full factorial design too low - must be >=2, but is " + runNumberCount);
            }
            case "Latin hypercube design": {
                this.valuesTable = DOEAlgorithms.populateTableLatinHypercube((int)this.outputs.size(), (int)runNumberCount, (int)seedNumber);
                break;
            }
            case "Monte Carlo design": {
                this.valuesTable = DOEAlgorithms.populateTableMonteCarlo((int)this.outputs.size(), (int)runNumberCount, (int)seedNumber);
                break;
            }
            case "Custom design table": {
                this.readCustomTable();
                break;
            }
            case "Custom design table as input": {
                this.valuesTable = new Double[0][0];
                break;
            }
        }
        if (this.endSample < 0) {
            this.endSample = this.valuesTable.length;
        }
        if (!"Custom design table as input".equals(this.method)) {
            this.codeOutputsAndWriteToFile();
        }
        if (this.treatStartAsComponentRun()) {
            this.processInputsNestedComponentSpecific();
        }
    }

    private void readCustomTable() throws ComponentException {
        try {
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            if (this.componentContext.getConfigurationValue("table") != null && !this.componentContext.getConfigurationValue("table").isEmpty()) {
                this.valuesTable = (Double[][])mapper.readValue(this.componentContext.getConfigurationValue("table"), Double[][].class);
                if (this.valuesTable == null) {
                    throw new ComponentException("No table given");
                }
            } else {
                throw new ComponentException("No table given");
            }
            if (this.componentContext.getConfigurationValue("startSample") != null && !this.componentContext.getConfigurationValue("startSample").isEmpty()) {
                this.runNumber = Integer.parseInt(this.componentContext.getConfigurationValue("startSample"));
            }
            if (this.componentContext.getConfigurationValue("endSample") != null && !this.componentContext.getConfigurationValue("endSample").isEmpty()) {
                this.endSample = Integer.parseInt(this.componentContext.getConfigurationValue("endSample"));
            }
            if (this.runNumber < 0) {
                this.componentLog.componentInfo("Start sample value < 0 -> set it to 0");
                this.runNumber = 0;
            }
            if (this.runNumber >= this.valuesTable.length) {
                throw new ComponentException(StringUtils.format((String)"Start sample value (%s) is greater than the number of samples (%s)", (Object[])new Object[]{this.runNumber, this.valuesTable.length}));
            }
            if (this.runNumber > this.endSample) {
                throw new ComponentException(StringUtils.format((String)"Start sample value (%s) is greater than end sample value (%s)", (Object[])new Object[]{this.runNumber, this.endSample}));
            }
            if (this.valuesTable.length > 0 && this.valuesTable[0].length < this.outputs.size()) {
                throw new ComponentException(StringUtils.format((String)"Number of values per sample (%s) is lower than the number of outputs (%s)", (Object[])new Object[]{this.valuesTable[0].length, this.outputs.size()}));
            }
            int i = 0;
            while (i <= this.endSample && i < this.valuesTable.length) {
                int j = 0;
                while (j < this.valuesTable[i].length) {
                    if (this.valuesTable[i][j] == null) {
                        throw new ComponentException("Values in table are incomplete");
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (IOException e) {
            throw new ComponentException("Failed to read given table", (Throwable)e);
        }
    }

    private void codeOutputsAndWriteToFile() {
        try {
            int i = 0;
            this.codedValues = new Double[this.valuesTable.length][this.valuesTable[0].length];
            for (String output : this.outputs) {
                Double low = Double.valueOf(this.componentContext.getOutputMetaDataValue(output, "lower"));
                Double up = Double.valueOf(this.componentContext.getOutputMetaDataValue(output, "upper"));
                int run = 0;
                while (run < this.valuesTable.length && run <= this.endSample) {
                    if (this.valuesTable[run][i] != null) {
                        this.codedValues[run][i] = DOEAlgorithms.convertValue((Double)low, (Double)up, (Double)this.valuesTable[run][i]);
                    }
                    ++run;
                }
                ++i;
            }
            if (!this.outputs.isEmpty()) {
                this.tableFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("DOETable*.csv");
                if (!this.method.equals("Custom design table") && !this.method.equals("Custom design table as input")) {
                    DOEUtils.writeTableToCSVFile((Object[][])this.codedValues, (String)this.tableFile.getAbsolutePath(), this.outputs);
                } else {
                    DOEUtils.writeTableToCSVFile((Object[][])this.valuesTable, (String)this.tableFile.getAbsolutePath(), this.outputs);
                }
            }
        }
        catch (IOException e) {
            String errorMessage = "Failed to write DOE table file";
            this.componentLog.componentError(StringUtils.format((String)PLACEHOLDER_STRING, (Object[])new Object[]{errorMessage, e.getMessage()}));
            LOGGER.error((Object)errorMessage, (Throwable)e);
        }
    }

    private void removeOutputsNotConsidered() {
        this.outputs.remove("Done");
        this.outputs.remove("Number of samples");
        Iterator<String> outputsIterator = this.outputs.iterator();
        while (outputsIterator.hasNext()) {
            String outputName = outputsIterator.next();
            if (!this.componentContext.isDynamicOutput(outputName) || !this.componentContext.getDynamicOutputIdentifier(outputName).equals("toForward")) continue;
            outputsIterator.remove();
        }
    }

    public boolean treatStartAsComponentRun() {
        return !this.hasForwardingStartInputs() && this.componentContext.getDynamicInputsWithIdentifier("startTable").isEmpty();
    }

    public void processInputsNestedComponentSpecific() throws ComponentException {
        if (this.componentContext.getInputsWithDatum().contains("Custom table")) {
            this.readCustomTableFromInput();
            this.codeOutputsAndWriteToFile();
        }
        this.initializeNewHistoryDataItem();
        if (this.historyDataItem != null && this.tableFileReference != null) {
            this.historyDataItem.setTableFileReference(this.tableFileReference.getFileReference());
        } else if (this.historyDataItem != null) {
            this.createTableFileReference();
        }
        this.processInput();
        if (this.runNumber == 0) {
            this.componentContext.writeOutput("Number of samples", (TypedDatum)this.typedDatumFactory.createInteger((long)this.valuesTable.length));
        }
        this.writeNewOutput();
        this.writeResultFile();
    }

    private void readCustomTableFromInput() throws ComponentException {
        MatrixTD customTable = (MatrixTD)this.componentContext.readInput("Custom table");
        int rowDimension = customTable.getRowDimension();
        int columnDimension = customTable.getColumnDimension();
        if (rowDimension <= 0 || columnDimension <= 0) {
            throw new ComponentException(StringUtils.format((String)"Dimension of table must be > 0 but is %sx%s", (Object[])new Object[]{rowDimension, columnDimension}));
        }
        if (columnDimension != this.outputs.size()) {
            throw new ComponentException(StringUtils.format((String)"Column dimension (%s) of table does not match number of outputs (%s)", (Object[])new Object[]{columnDimension, this.outputs.size()}));
        }
        this.valuesTable = new Double[rowDimension][columnDimension];
        int i = 0;
        while (i < rowDimension) {
            int j = 0;
            while (j < columnDimension) {
                this.valuesTable[i][j] = customTable.getFloatTDOfElement(i, j).getFloatValue();
                ++j;
            }
            ++i;
        }
    }

    private void createTableFileReference() {
        block13: {
            if (this.historyDataItem != null && this.tableFile != null) {
                try {
                    try {
                        this.tableFileReference = ((ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class)).createFileReferenceTDFromLocalFile(this.componentContext, this.tableFile, "DOETable.csv");
                        this.historyDataItem.setTableFileReference(this.tableFileReference.getFileReference());
                    }
                    catch (IOException e) {
                        String errorMessage = "Failed to create DOE table file";
                        this.componentLog.componentError(StringUtils.format((String)PLACEHOLDER_STRING, (Object[])new Object[]{errorMessage, e.getMessage()}));
                        LOGGER.error((Object)errorMessage, (Throwable)e);
                        if (this.tableFile == null || !this.tableFile.exists()) break block13;
                        try {
                            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.tableFile);
                        }
                        catch (IOException e2) {
                            LOGGER.error((Object)("Failed to dispose temporary file: " + this.tableFile.getAbsolutePath()), (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (this.tableFile != null && this.tableFile.exists()) {
                        try {
                            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.tableFile);
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)("Failed to dispose temporary file: " + this.tableFile.getAbsolutePath()), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public void completeStartOrProcessInputsAfterFailure() throws ComponentException {
        this.writeResultFile();
        this.writeFinalHistoryDataItem();
    }

    public void onStartInterrupted(ThreadHandler executingThreadHandler) {
        this.canceled = true;
    }

    public void tearDown(Component.FinalComponentState state) {
        super.tearDown(state);
        if (this.tableFile != null && this.tableFile.exists()) {
            try {
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.tableFile);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Could not dispose temp file: ", (Throwable)e);
            }
        }
    }

    private void writeResultFile() {
        block15: {
            if (!this.componentContext.getDynamicInputsWithIdentifier("default").isEmpty() && this.historyDataItem != null) {
                File resultFile = null;
                try {
                    try {
                        resultFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("DOEResult*.csv");
                        if (this.method.equals("Custom design table") || this.method.equals("Custom design table as input")) {
                            DOEUtils.writeResultToCSVFile((Object[][])this.valuesTable, this.resultData, (String)resultFile.getAbsolutePath(), (int)this.runNumber, this.outputs);
                        } else {
                            DOEUtils.writeResultToCSVFile((Object[][])this.codedValues, this.resultData, (String)resultFile.getAbsolutePath(), (int)this.runNumber, this.outputs);
                        }
                        FileReferenceTD resultFileReference = ((ComponentDataManagementService)this.componentContext.getService(ComponentDataManagementService.class)).createFileReferenceTDFromLocalFile(this.componentContext, resultFile, "Result.csv");
                        this.historyDataItem.setResultFileReference(resultFileReference.getFileReference());
                    }
                    catch (IOException e) {
                        String errorMessage = "Failed to store history data";
                        this.componentLog.componentError(StringUtils.format((String)PLACEHOLDER_STRING, (Object[])new Object[]{errorMessage, e.getMessage()}));
                        LOGGER.error((Object)errorMessage, (Throwable)e);
                        if (resultFile == null || !resultFile.exists()) break block15;
                        try {
                            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(resultFile);
                        }
                        catch (IOException e2) {
                            LOGGER.error((Object)("Failed to dispose temporary file: " + resultFile.getAbsolutePath()), (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (resultFile != null && resultFile.exists()) {
                        try {
                            TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(resultFile);
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)("Failed to dispose temporary file: " + resultFile.getAbsolutePath()), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void writeNewOutput() {
        if (this.valuesTable != null) {
            if (this.componentContext.getDynamicInputsWithIdentifier("default").isEmpty() && this.componentContext.getDynamicInputsWithIdentifier("toForward").isEmpty() && !this.hasForwardingStartInputs()) {
                this.writeAllOutputs();
            } else if (this.runNumber < this.valuesTable.length) {
                this.writeNextOutput();
            } else {
                this.setLoopDone();
            }
        }
    }

    private void setLoopDone() {
        this.setLoopDone(true);
    }

    private void setLoopDone(boolean done) {
        this.isDone = done;
    }

    private void writeNextOutput() {
        if (this.method.equals("Custom design table") && this.runNumber > this.endSample) {
            this.setLoopDone();
            return;
        }
        int i = 0;
        for (String output : this.outputs) {
            Double low = Double.valueOf(this.componentContext.getOutputMetaDataValue(output, "lower"));
            Double up = Double.valueOf(this.componentContext.getOutputMetaDataValue(output, "upper"));
            double value = this.valuesTable[this.runNumber][i++];
            if (!this.method.equals("Custom design table") && !this.method.equals("Custom design table as input")) {
                value = DOEAlgorithms.convertValue((Double)low, (Double)up, (Double)value);
            }
            this.writeOutput(output, (TypedDatum)((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory().createFloat(value));
            this.componentLog.componentInfo(StringUtils.format((String)WROTE_VALUE_TO_OUTPUT_TEXT, (Object[])new Object[]{output, value}));
        }
        ++this.runNumber;
        this.setLoopDone(false);
    }

    private void writeAllOutputs() {
        while (this.runNumber < this.valuesTable.length) {
            if (this.method.equals("Custom design table") && this.runNumber > this.endSample) break;
            int i = 0;
            for (String output : this.outputs) {
                double value = this.valuesTable[this.runNumber][i++];
                if (!this.method.equals("Custom design table") && !this.method.equals("Custom design table as input")) {
                    Double low = Double.valueOf(this.componentContext.getOutputMetaDataValue(output, "lower"));
                    Double up = Double.valueOf(this.componentContext.getOutputMetaDataValue(output, "upper"));
                    value = DOEAlgorithms.convertValue((Double)low, (Double)up, (Double)value);
                }
                this.writeOutput(output, (TypedDatum)((TypedDatumService)this.componentContext.getService(TypedDatumService.class)).getFactory().createFloat(value));
                this.componentLog.componentInfo(StringUtils.format((String)WROTE_VALUE_TO_OUTPUT_TEXT, (Object[])new Object[]{output, value}));
            }
            ++this.runNumber;
            if (this.canceled) break;
        }
        this.setLoopDone();
    }

    private void processInput() {
        if (!this.componentContext.getInputsWithDatum().isEmpty()) {
            HashMap<String, Double> runInput = new HashMap<String, Double>();
            for (String inputName : this.componentContext.getInputsWithDatum()) {
                if (!this.componentContext.getDynamicInputIdentifier(inputName).equals("default")) continue;
                if (this.componentContext.readInput(inputName).getDataType() != DataType.NotAValue) {
                    runInput.put(inputName, ((FloatTD)this.componentContext.readInput(inputName)).getFloatValue());
                    continue;
                }
                runInput.put(inputName, Double.NaN);
            }
            this.resultData.put(this.runNumber - 1, runInput);
        }
    }

    private void initializeNewHistoryDataItem() {
        if (Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.historyDataItem = new DOEComponentHistoryDataItem();
        }
    }

    private void writeFinalHistoryDataItem() {
        if (this.historyDataItem != null && !this.outputs.isEmpty() && Boolean.valueOf(this.componentContext.getConfigurationValue("storeComponentHistoryData")).booleanValue()) {
            this.componentContext.writeFinalHistoryDataItem((ComponentHistoryDataItem)this.historyDataItem);
        }
    }

    protected boolean isDoneNestedComponentSpecific() {
        return this.isDone;
    }

    protected void resetNestedComponentSpecific() {
        this.runNumber = 0;
        this.isDone = false;
    }

    protected void finishLoopNestedComponentSpecific() {
    }

    protected void sendFinalValues() throws ComponentException {
        this.writeFinalHistoryDataItem();
    }

    protected void sendValuesNestedComponentSpecific() {
        this.writeFinalHistoryDataItem();
    }
}

