/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class Env {
    public static final Env INSTANCE = new Env("cucumber");
    private final Map<String, String> map = new HashMap<String, String>();

    public Env() {
        this(null, System.getProperties());
    }

    public Env(String bundleName) {
        this(bundleName, System.getProperties());
    }

    public Env(Properties properties) {
        this(null, properties);
    }

    public Env(String bundleName, Properties properties) {
        if (bundleName != null) {
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
                for (String key : bundle.keySet()) {
                    this.put(key, bundle.getString(key));
                }
            }
            catch (MissingResourceException bundle) {
                // empty catch block
            }
        }
        if (properties != null) {
            for (String key : properties.stringPropertyNames()) {
                this.put(key, properties.getProperty(key));
            }
        }
        Map<String, String> env = System.getenv();
        for (String key : env.keySet()) {
            this.put(key, env.get(key));
        }
    }

    private void put(String key, String string) {
        this.map.put(key, string);
        this.map.put(key.replace('.', '_').toUpperCase(), string);
        this.map.put(key.replace('_', '.').toLowerCase(), string);
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public String get(String key, String defaultValue) {
        String result = this.get(key);
        return result != null ? result : defaultValue;
    }
}

