/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.TrueType;
import org.jpedal.fonts.Type1C;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1GlyphFactory;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.fonts.tt.conversion.CFFFixer;
import org.jpedal.fonts.tt.conversion.CFFWriter;
import org.jpedal.fonts.tt.conversion.CMAPWriter;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;
import org.jpedal.fonts.tt.conversion.HeadWriter;
import org.jpedal.fonts.tt.conversion.HheaWriter;
import org.jpedal.fonts.tt.conversion.HmtxWriter;
import org.jpedal.fonts.tt.conversion.MAXPWriter;
import org.jpedal.fonts.tt.conversion.NameWriter;
import org.jpedal.fonts.tt.conversion.OS2Writer;
import org.jpedal.fonts.tt.conversion.PostWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PS2OTFFontWriter
extends FontWriter {
    byte[] cff;
    byte[] cmap = null;
    PdfFont pdfFont;
    PdfFont orginalFont;
    PdfJavaGlyphs glyphs;
    int minCharCode;
    int maxCharCode;
    private int xAvgCharWidth = 0;
    private double xMaxExtent = Double.MIN_VALUE;
    private double minRightSideBearing = Double.MAX_VALUE;
    private double minLeftSideBearing = Double.MAX_VALUE;
    private double advanceWidthMax = Double.MIN_VALUE;
    private double lowestDescender = -1.0;
    private double highestAscender = 1.0;
    private float[] fontBBox = new float[4];
    private int[] advanceWidths;
    private HashMap<String, Integer> widthMap;

    public PS2OTFFontWriter(PdfFont pdfFont, byte[] byArray, String string, HashMap<String, Integer> hashMap) throws Exception {
        boolean bl = string.equals("cff");
        this.name = pdfFont.getBaseFontName();
        this.widthMap = hashMap;
        String string2 = "cff ";
        if (string.equals("ttf")) {
            this.glyphs = new TTGlyphs();
            this.pdfFont = new TrueType(byArray, this.glyphs);
            string2 = "glyf";
        } else {
            this.glyphs = new T1Glyphs(false, bl);
            this.pdfFont = new Type1C(byArray, this.glyphs, bl);
        }
        this.glyphCount = this.glyphs.getGlyphCount();
        this.orginalFont = pdfFont;
        this.cff = byArray;
        String[] stringArray = new String[]{string2, "OS/2", "cmap", "head", "hhea", "hmtx", "maxp", "name", "post"};
        this.tableList = new ArrayList();
        this.numTables = stringArray.length;
        int n = 1;
        while (n * 2 <= this.numTables) {
            n *= 2;
        }
        this.searchRange = n * 16;
        this.entrySelector = 0;
        while (Math.pow(2.0, this.entrySelector) < (double)n) {
            ++this.entrySelector;
        }
        this.rangeShift = this.numTables * 16 - this.searchRange;
        this.tableList.addAll(Arrays.asList(stringArray).subList(0, this.numTables));
        this.checksums = new int[this.tableCount][1];
        this.tables = new int[this.tableCount][1];
        this.tableLength = new int[this.tableCount][1];
        this.type = 1;
    }

    @Override
    void readTables() {
        int n = 0;
        this.advanceWidths = new int[this.glyphCount];
        if (this.widthMap != null) {
            for (int i = 0; i < this.glyphCount; ++i) {
                Integer n2 = this.widthMap.get(this.glyphs.getIndexForCharString(i + 1));
                if (n2 != null) {
                    this.advanceWidths[i] = n2;
                } else {
                    n2 = this.widthMap.get("JPedalDefaultWidth");
                    if (n2 != null) {
                        this.advanceWidths[i] = n2;
                    }
                }
                this.advanceWidthMax = this.advanceWidthMax > (double)this.advanceWidths[i] ? this.advanceWidthMax : (double)this.advanceWidths[i];
                n += this.advanceWidths[i];
            }
        }
        if (this.glyphCount > 0) {
            this.xAvgCharWidth = (int)((double)n / (double)this.glyphCount);
        }
        double d = Double.MIN_VALUE;
        for (int i = 0; i < this.glyphCount && i < 256; ++i) {
            PdfGlyph pdfGlyph = this.glyphs.getEmbeddedGlyph(new T1GlyphFactory(), this.pdfFont.getMappedChar(i, false), new float[][]{{1.0f, 0.0f}, {0.0f, 1.0f}}, i, this.pdfFont.getGlyphValue(i), this.pdfFont.getWidth(i), this.pdfFont.getMappedChar(i, false));
            if (pdfGlyph == null || pdfGlyph.getShape() == null) continue;
            Rectangle2D rectangle2D = pdfGlyph.getShape().getBounds2D();
            double d2 = rectangle2D.getMinX();
            double d3 = (double)this.advanceWidths[i] - rectangle2D.getMaxX();
            double d4 = rectangle2D.getMinX() + rectangle2D.getWidth();
            this.minLeftSideBearing = this.minLeftSideBearing < d2 ? this.minLeftSideBearing : d2;
            this.minRightSideBearing = this.minRightSideBearing < d3 ? this.minRightSideBearing : d3;
            this.xMaxExtent = this.xMaxExtent > d4 ? this.xMaxExtent : d4;
            this.lowestDescender = this.lowestDescender < rectangle2D.getMinY() ? this.lowestDescender : rectangle2D.getMinY();
            this.highestAscender = this.highestAscender > rectangle2D.getMaxY() ? this.highestAscender : rectangle2D.getMaxY();
            d = d > rectangle2D.getMaxX() ? d : rectangle2D.getMaxX();
        }
        this.fontBBox = this.pdfFont.FontBBox;
        this.minLeftSideBearing = this.minLeftSideBearing < (double)this.fontBBox[0] ? this.minLeftSideBearing : (double)this.fontBBox[0];
        this.lowestDescender = this.lowestDescender < (double)this.fontBBox[1] ? this.lowestDescender : (double)this.fontBBox[1];
        d = d > (double)this.fontBBox[2] ? d : (double)this.fontBBox[2];
        this.highestAscender = this.highestAscender > (double)this.fontBBox[3] ? this.highestAscender : (double)this.fontBBox[3];
        this.fontBBox = new float[]{(float)this.minLeftSideBearing, (float)this.lowestDescender, (float)d, (float)this.highestAscender};
    }

    @Override
    public byte[] getTableBytes(int n) {
        byte[] byArray = new byte[]{};
        FontTableWriter fontTableWriter = null;
        switch (n) {
            case 16: {
                if (this.pdfFont.is1C()) {
                    byArray = new CFFFixer(this.cff).getBytes();
                    break;
                }
                fontTableWriter = new CFFWriter(this.glyphs, this.cff, this.name);
                break;
            }
            case 0: {
                fontTableWriter = new HeadWriter(this.fontBBox);
                break;
            }
            case 2: {
                fontTableWriter = new CMAPWriter(this.pdfFont, this.glyphs);
                this.minCharCode = fontTableWriter.getIntValue(0);
                this.maxCharCode = fontTableWriter.getIntValue(1);
                break;
            }
            case 5: {
                fontTableWriter = new HheaWriter(this.glyphs, this.xMaxExtent, this.minRightSideBearing, this.minLeftSideBearing, this.advanceWidthMax, this.lowestDescender, this.highestAscender);
                break;
            }
            case 6: {
                fontTableWriter = new HmtxWriter(this.pdfFont, this.glyphs, this.advanceWidths);
                break;
            }
            case 13: {
                fontTableWriter = new OS2Writer(this.glyphs, this.xAvgCharWidth, this.minCharCode, this.maxCharCode, this.fontBBox);
                break;
            }
            case 1: {
                fontTableWriter = new MAXPWriter(this.glyphs);
                break;
            }
            case 7: {
                fontTableWriter = new NameWriter(this.pdfFont, this.glyphs, this.name);
                break;
            }
            case 8: {
                fontTableWriter = new PostWriter();
                break;
            }
        }
        if (fontTableWriter != null) {
            try {
                byArray = fontTableWriter.writeTable();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return byArray;
    }
}

