/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.timeline;

import de.rcenvironment.core.gui.workflow.view.timeline.TimelineActivityType;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class TimelineActivityPart {
    private String componentName = null;
    private TimelineActivityType type = null;
    private Date date = null;
    private String comment = "";
    private Date endtime = null;
    private String run;

    public TimelineActivityPart(String componentName, TimelineActivityType type, Date date, String comment) {
        this.componentName = componentName;
        this.date = date;
        this.type = type;
        this.comment = comment;
    }

    public TimelineActivityPart(String componentName, TimelineActivityType type, Date date, String run, String comment) {
        this.componentName = componentName;
        this.date = date;
        this.type = type;
        this.run = run;
        this.comment = comment;
    }

    public Date getDate() {
        return this.date;
    }

    public Date getEndDate() {
        return this.endtime;
    }

    public TimelineActivityType getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public String getTooltipText(Date newWFEndTime) {
        String text = String.valueOf(this.componentName) + ": ";
        if (this.type != null) {
            text = String.valueOf(text) + this.type.getDisplayName() + "\n";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        text = String.valueOf(text) + "Start: " + dateFormat.format(this.date) + "\n";
        Date currentCalcTime = this.endtime;
        if (currentCalcTime == null) {
            currentCalcTime = newWFEndTime;
        }
        if (currentCalcTime != null) {
            text = String.valueOf(text) + "End: " + dateFormat.format(currentCalcTime) + "\n";
            text = String.valueOf(text) + "Duration: " + this.getDurationText(currentCalcTime) + "\n";
        }
        if (this.run != null) {
            text = String.valueOf(text) + "Run: " + this.run + "\n";
        }
        if (this.comment != null && !this.comment.equals("")) {
            text = String.valueOf(text) + "Comment: " + this.comment;
        }
        return text;
    }

    public String getDurationText(Date time) {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(this.date);
        long t1 = cal.getTimeInMillis();
        cal.setTime(time);
        return DurationFormatUtils.formatDurationHMS((long)Math.abs(cal.getTimeInMillis() - t1));
    }

    public void setEndtime(Date newEndTime) {
        this.endtime = newEndTime;
    }
}

