/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor;

import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.RetargetAction;

public class ShowNumberOfConnectionsAction
extends RetargetAction {
    private static IPreferenceStore preferenceStore;
    private IWorkbenchPart activePart;

    public ShowNumberOfConnectionsAction(String actionID, String text) {
        super(actionID, text);
        preferenceStore = Activator.getInstance().getPreferenceStore();
    }

    public void partActivated(IWorkbenchPart part) {
        super.partActivated(part);
        this.activePart = part;
        this.setChecked(preferenceStore.getBoolean("showConnections"));
        if (this.activePart instanceof WorkflowEditor) {
            if (preferenceStore.getBoolean("showConnections")) {
                ((WorkflowEditor)this.activePart).showAllConnectionLabels();
            } else {
                ((WorkflowEditor)this.activePart).hideUnselectedConnectionLabels();
            }
        }
        this.isEnabled();
    }

    public boolean isEnabled() {
        boolean enabled = this.activePart instanceof WorkflowEditor;
        super.setEnabled(enabled);
        return enabled;
    }

    public int getStyle() {
        return 2;
    }

    public void runWithEvent(Event event) {
        if (this.activePart instanceof WorkflowEditor) {
            WorkflowEditor editor = (WorkflowEditor)this.activePart;
            if (this.isChecked()) {
                editor.showAllConnectionLabels();
                preferenceStore.setValue("showConnections", true);
            } else {
                editor.hideUnselectedConnectionLabels();
                preferenceStore.setValue("showConnections", false);
            }
        }
        super.runWithEvent(event);
    }
}

