/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.testutils;

import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.internal.ConfigurationStoreImpl;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;

public final class ConfigurationSegmentUtils {
    private ConfigurationSegmentUtils() {
    }

    public static ConfigurationSegment createEmptySegment() {
        return new ConfigurationStoreImpl(null).createEmptyPlaceholder();
    }

    public static ConfigurationSegment readTestConfigurationFile(File file) throws IOException {
        return new ConfigurationStoreImpl(file).getSnapshotOfRootSegment();
    }

    public static ConfigurationSegment readTestConfigurationFromStream(InputStream is) throws IOException {
        if (is == null) {
            throw new IOException("InputStream is null - most likely, a test resource was not found");
        }
        File tempFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("*.json");
        FileUtils.copyInputStreamToFile((InputStream)is, (File)tempFile);
        ConfigurationSegment segment = new ConfigurationStoreImpl(tempFile).getSnapshotOfRootSegment();
        TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(tempFile);
        return segment;
    }

    public static ConfigurationSegment readTestConfigurationFromString(String data) throws IOException {
        if (data == null) {
            throw new IOException("JSON content cannot be null");
        }
        File tempFile = TempFileServiceAccess.getInstance().createTempFileFromPattern("*.json");
        FileUtils.write((File)tempFile, (CharSequence)data);
        ConfigurationSegment segment = new ConfigurationStoreImpl(tempFile).getSnapshotOfRootSegment();
        TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(tempFile);
        return segment;
    }
}

