/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function;

import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class WorkflowFunctionInputs {
    private final Map<String, TypedDatum> inputs;

    protected WorkflowFunctionInputs(Map<String, TypedDatum> inputs) {
        this.inputs = inputs;
    }

    public static WorkflowFunctionInputs createFromMap(Map<String, TypedDatum> inputs) {
        String invalidEntries = inputs.entrySet().stream().filter(entry -> entry.getKey() == null || entry.getValue() == null).map(entry -> StringUtils.format((String)"{%s=%s}", (Object[])new Object[]{entry.getKey(), entry.getValue()})).collect(Collectors.joining(", "));
        if (!invalidEntries.isEmpty()) {
            throw new IllegalArgumentException("WorkflowFunctionInputs contains the following invalid entries: " + invalidEntries + "\nEntries may not contain `null` as key or value.");
        }
        return new WorkflowFunctionInputs(new HashMap<String, TypedDatum>(inputs));
    }

    public TypedDatum getValueByName(String name) {
        if (!this.inputs.containsKey(name)) {
            throw new IllegalArgumentException(StringUtils.format((String)"Attempted to access value of input %s, but that input was not set", (Object[])new Object[]{name}));
        }
        return this.inputs.get(name);
    }

    public Iterable<String> getInputNames() {
        return this.inputs.keySet();
    }
}

