/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.parametricstudy.execution;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.rcenvironment.components.parametricstudy.common.ParametricStudyComponentConstants;
import de.rcenvironment.core.component.update.api.PersistentComponentDescription;
import de.rcenvironment.core.component.update.api.PersistentComponentDescriptionUpdaterUtils;
import de.rcenvironment.core.component.update.spi.PersistentComponentDescriptionUpdater;
import de.rcenvironment.core.utils.common.JsonUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.UUID;

public class ParametricStudyPersistentComponentDescriptionUpdater
implements PersistentComponentDescriptionUpdater {
    private static final String DESIGN_VARIABLE = "Design Variable";
    private static final String V1_0 = "1.0";
    private static final String V3_0 = "3.0";
    private static final String V3_1 = "3.1";
    private static final String V3_2 = "3.2";
    private static final String V3_3 = "3.3";
    private static final String V4 = "4";
    private static final String OUTPUT_NAME = "name";
    private static final String STATIC_OUTPUTS = "staticOutputs";
    private static final String DYNAMIC_INPUTS = "dynamicInputs";
    private static final String EP_IDENTIFIER = "epIdentifier";

    public String[] getComponentIdentifiersAffectedByUpdate() {
        return ParametricStudyComponentConstants.COMPONENT_IDS;
    }

    public int getFormatVersionsAffectedByUpdate(String persistentComponentDescriptionVersion, boolean silent) {
        int versionsToUpdate = 0;
        if (!silent) {
            if (persistentComponentDescriptionVersion == null || persistentComponentDescriptionVersion.compareTo(V1_0) < 0) {
                versionsToUpdate |= 1;
            }
            if (persistentComponentDescriptionVersion != null) {
                if (persistentComponentDescriptionVersion.compareTo(V3_0) < 0) {
                    versionsToUpdate |= 2;
                }
                if (persistentComponentDescriptionVersion.compareTo(V4) < 0) {
                    versionsToUpdate |= 4;
                }
            }
        } else if (persistentComponentDescriptionVersion != null && persistentComponentDescriptionVersion.compareTo(V3_3) < 0) {
            versionsToUpdate |= 4;
        }
        return versionsToUpdate;
    }

    public PersistentComponentDescription performComponentDescriptionUpdate(int formatVersion, PersistentComponentDescription description, boolean silent) throws IOException {
        block29: {
            block28: {
                if (silent) break block28;
                if (formatVersion == 1) {
                    return this.updateToV10(description);
                }
                if (formatVersion == 2) {
                    return this.updateFrom10To30(description);
                }
                if (formatVersion != 4) break block29;
                switch (description.getComponentVersion()) {
                    case "3.0": {
                        description = this.updateFrom30To31(description);
                    }
                    case "3.1": {
                        description = this.updateFrom31To32(description);
                    }
                    case "3.2": {
                        description = this.updateFrom32To33(description);
                    }
                    case "3.3": {
                        description = this.updateFrom33To4(description);
                    }
                }
                break block29;
            }
            if (formatVersion != 4) break block29;
            switch (description.getComponentVersion()) {
                case "3.1": {
                    description = this.updateFrom31To32(description);
                }
                case "3.2": {
                    description = this.updateFrom32To33(description);
                }
            }
        }
        return description;
    }

    private PersistentComponentDescription updateFrom33To4(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.removeOuterLoopDoneEndpoints((PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.removeEndpointCharacterInfoFromMetaData((PersistentComponentDescription)description);
        description = PersistentComponentDescriptionUpdaterUtils.reassignEndpointIdentifiers((PersistentComponentDescription)description, (String)DYNAMIC_INPUTS, (String)"toForward", (String)"startToForward", (String)"_start");
        description.setComponentVersion(V4);
        return description;
    }

    private PersistentComponentDescription updateFrom32To33(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        PersistentComponentDescription updatedDesc = PersistentComponentDescriptionUpdaterUtils.updateFaultToleranceOfLoopDriver((PersistentComponentDescription)description);
        updatedDesc.setComponentVersion(V3_3);
        return updatedDesc;
    }

    private PersistentComponentDescription updateFrom31To32(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode staticOutputs = node.get(STATIC_OUTPUTS);
        for (JsonNode outputEndpoint : staticOutputs) {
            ((ObjectNode)outputEndpoint).remove(EP_IDENTIFIER);
            if (!outputEndpoint.get(OUTPUT_NAME).textValue().equals(DESIGN_VARIABLE)) continue;
            ((ObjectNode)outputEndpoint).put(OUTPUT_NAME, "Design variable");
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        PersistentComponentDescription newdesc = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        newdesc.setComponentVersion(V3_2);
        return newdesc;
    }

    private PersistentComponentDescription updateFrom30To31(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode staticOutputs = node.get(STATIC_OUTPUTS);
        if (staticOutputs != null) {
            for (JsonNode outputEndpoint : staticOutputs) {
                ((ObjectNode)outputEndpoint).remove(EP_IDENTIFIER);
                if (!outputEndpoint.get(OUTPUT_NAME).textValue().equals("DesignVariable")) continue;
                ((ObjectNode)outputEndpoint).put(OUTPUT_NAME, DESIGN_VARIABLE);
                ObjectNode metadata = this.createStaticOutputMetaData(node);
                ((ObjectNode)outputEndpoint).set("metadata", (JsonNode)metadata);
                ((ObjectNode)outputEndpoint).put("datatype", "Float");
            }
        } else {
            ArrayNode statOutputs = JsonNodeFactory.instance.arrayNode();
            ObjectNode output = JsonNodeFactory.instance.objectNode();
            output.set("identifier", (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
            output.set(OUTPUT_NAME, (JsonNode)TextNode.valueOf((String)DESIGN_VARIABLE));
            output.set("datatype", (JsonNode)TextNode.valueOf((String)"Float"));
            ObjectNode metadata = this.createStaticOutputMetaData(node);
            output.set("metadata", (JsonNode)metadata);
            statOutputs.add((JsonNode)output);
            ((ObjectNode)node).set(STATIC_OUTPUTS, (JsonNode)statOutputs);
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        PersistentComponentDescription newdesc = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        newdesc.setComponentVersion(V3_1);
        return newdesc;
    }

    private ObjectNode createStaticOutputMetaData(JsonNode node) {
        ObjectNode metadata = JsonNodeFactory.instance.objectNode();
        ObjectNode config = (ObjectNode)node.get("configuration");
        metadata.set("FromValue", (JsonNode)TextNode.valueOf((String)config.get("FromValue").textValue()));
        metadata.set("StepSize", (JsonNode)TextNode.valueOf((String)config.get("StepSize").textValue()));
        metadata.set("ToValue", (JsonNode)TextNode.valueOf((String)config.get("ToValue").textValue()));
        return metadata;
    }

    private PersistentComponentDescription updateFrom10To30(PersistentComponentDescription description) throws JsonProcessingException, IOException {
        description = PersistentComponentDescriptionUpdaterUtils.updateAllDynamicEndpointsToIdentifier((String)DYNAMIC_INPUTS, (String)"parameters", (PersistentComponentDescription)description);
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode node = mapper.readTree(description.getComponentDescriptionAsString());
        JsonNode staticOutputs = node.get(STATIC_OUTPUTS);
        if (staticOutputs != null) {
            for (JsonNode outputEndpoint : staticOutputs) {
                ((ObjectNode)outputEndpoint).remove(EP_IDENTIFIER);
            }
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        PersistentComponentDescription newdesc = new PersistentComponentDescription(writer.writeValueAsString((Object)node));
        newdesc.setComponentVersion(V3_0);
        return newdesc;
    }

    private PersistentComponentDescription updateToV10(PersistentComponentDescription description) throws JsonParseException, IOException {
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser jsonParser = jsonFactory.createParser(description.getComponentDescriptionAsString());
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        JsonNode rootNode = (JsonNode)mapper.readTree(jsonParser);
        jsonParser.close();
        JsonNode dynamicInputsNode = rootNode.findPath(STATIC_OUTPUTS);
        Iterator it = dynamicInputsNode.elements();
        while (it.hasNext()) {
            JsonNode inputNode = (JsonNode)it.next();
            ((ObjectNode)inputNode).remove(OUTPUT_NAME);
            ((ObjectNode)inputNode).set(OUTPUT_NAME, (JsonNode)TextNode.valueOf((String)"Design variable"));
        }
        ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
        description = new PersistentComponentDescription(writer.writeValueAsString((Object)rootNode));
        description.setComponentVersion(V1_0);
        return description;
    }
}

