/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.map;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.IterableMap;
import org.apache.commons.collections15.MapIterator;
import org.apache.commons.collections15.keyvalue.MultiKey;
import org.apache.commons.collections15.map.AbstractHashedMap;
import org.apache.commons.collections15.map.HashedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiKeyMap<K, V>
implements IterableMap<MultiKey<K>, V>,
Serializable {
    private static final long serialVersionUID = -1788199231038721040L;
    protected final AbstractHashedMap<MultiKey<K>, V> map;

    public static <K, V> MultiKeyMap<K, V> decorate(AbstractHashedMap<MultiKey<K>, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must not be null");
        }
        if (map.size() > 0) {
            throw new IllegalArgumentException("Map must be empty");
        }
        return new MultiKeyMap<K, V>(map);
    }

    public MultiKeyMap() {
        this.map = new HashedMap<MultiKey<K>, V>();
    }

    protected MultiKeyMap(AbstractHashedMap<MultiKey<K>, V> map) {
        this.map = map;
    }

    public V get(K ... keys) {
        int hashCode = this.hash(keys);
        AbstractHashedMap.HashEntry entry = this.map.data[this.map.hashIndex(hashCode, this.map.data.length)];
        while (entry != null) {
            if (entry.hashCode == hashCode && this.isEqualKey(entry, keys)) {
                return entry.getValue();
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean containsKey(K ... keys) {
        int hashCode = this.hash(keys);
        AbstractHashedMap.HashEntry entry = this.map.data[this.map.hashIndex(hashCode, this.map.data.length)];
        while (entry != null) {
            if (entry.hashCode == hashCode && this.isEqualKey(entry, keys)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public V put(K key1, K key2, V value) {
        return this.putMultiKey(value, key1, key2);
    }

    public V put(K key1, K key2, K key3, V value) {
        return this.putMultiKey(value, key1, key2, key3);
    }

    public V put(K key1, K key2, K key3, K key4, V value) {
        return this.putMultiKey(value, key1, key2, key3, key4);
    }

    public V put(K key1, K key2, K key3, K key4, K key5, V value) {
        return this.putMultiKey(value, key1, key2, key3, key4, key5);
    }

    public V putMultiKey(V value, K ... keys) {
        int hashCode = this.hash(keys);
        int index = this.map.hashIndex(hashCode, this.map.data.length);
        AbstractHashedMap.HashEntry entry = this.map.data[index];
        while (entry != null) {
            if (entry.hashCode == hashCode && this.isEqualKey(entry, keys)) {
                Object oldValue = entry.getValue();
                this.map.updateEntry(entry, value);
                return oldValue;
            }
            entry = entry.next;
        }
        this.map.addMapping(index, hashCode, new MultiKey<K>(keys), value);
        return null;
    }

    public Object remove(K ... keys) {
        int hashCode = this.hash(keys);
        int index = this.map.hashIndex(hashCode, this.map.data.length);
        AbstractHashedMap.HashEntry entry = this.map.data[index];
        AbstractHashedMap.HashEntry previous = null;
        while (entry != null) {
            if (entry.hashCode == hashCode && this.isEqualKey(entry, keys)) {
                Object oldValue = entry.getValue();
                this.map.removeMapping(entry, index, previous);
                return oldValue;
            }
            previous = entry;
            entry = entry.next;
        }
        return null;
    }

    protected int hash(K ... keys) {
        int h = 0;
        for (int i = 0; i < keys.length; ++i) {
            K key = keys[i];
            if (key == null) continue;
            h ^= key.hashCode();
        }
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    protected boolean isEqualKey(AbstractHashedMap.HashEntry<MultiKey<K>, V> entry, K ... keys) {
        MultiKey<K> multi = entry.getKey();
        if (multi.size() != keys.length) {
            return false;
        }
        for (int i = 0; i < keys.length; ++i) {
            K key = keys[i];
            if (!(key == null ? multi.getKey(i) != null : !key.equals(multi.getKey(i)))) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Object key1) {
        boolean modified = false;
        MapIterator it = this.mapIterator();
        while (it.hasNext()) {
            MultiKey multi = (MultiKey)it.next();
            if (multi.size() < 1 || !(key1 == null ? multi.getKey(0) == null : key1.equals(multi.getKey(0)))) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(Object key1, Object key2) {
        boolean modified = false;
        MapIterator it = this.mapIterator();
        while (it.hasNext()) {
            MultiKey multi = (MultiKey)it.next();
            if (multi.size() < 2 || !(key1 == null ? multi.getKey(0) == null : key1.equals(multi.getKey(0))) || !(key2 == null ? multi.getKey(1) == null : key2.equals(multi.getKey(1)))) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(Object key1, Object key2, Object key3) {
        boolean modified = false;
        MapIterator it = this.mapIterator();
        while (it.hasNext()) {
            MultiKey multi = (MultiKey)it.next();
            if (multi.size() < 3 || !(key1 == null ? multi.getKey(0) == null : key1.equals(multi.getKey(0))) || !(key2 == null ? multi.getKey(1) == null : key2.equals(multi.getKey(1))) || !(key3 == null ? multi.getKey(2) == null : key3.equals(multi.getKey(2)))) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(Object key1, Object key2, Object key3, Object key4) {
        boolean modified = false;
        MapIterator it = this.mapIterator();
        while (it.hasNext()) {
            MultiKey multi = (MultiKey)it.next();
            if (multi.size() < 4 || !(key1 == null ? multi.getKey(0) == null : key1.equals(multi.getKey(0))) || !(key2 == null ? multi.getKey(1) == null : key2.equals(multi.getKey(1))) || !(key3 == null ? multi.getKey(2) == null : key3.equals(multi.getKey(2))) || !(key4 == null ? multi.getKey(3) == null : key4.equals(multi.getKey(3)))) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    protected void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null");
        }
    }

    public Object clone() {
        return new MultiKeyMap<K, V>((AbstractHashedMap)this.map.clone());
    }

    @Override
    public V put(MultiKey<K> key, V value) {
        this.checkKey(key);
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends MultiKey<K>, ? extends V> mapToCopy) {
        for (MultiKey<K> key : mapToCopy.keySet()) {
            this.checkKey(key);
        }
        this.map.putAll(mapToCopy);
    }

    @Override
    public MapIterator mapIterator() {
        return this.map.mapIterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection values() {
        return this.map.values();
    }

    @Override
    public Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return this.map.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

