/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15;

import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.functors.ConstantFactory;
import org.apache.commons.collections15.functors.ExceptionFactory;
import org.apache.commons.collections15.functors.InstantiateFactory;
import org.apache.commons.collections15.functors.PrototypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryUtils {
    public static Factory exceptionFactory() {
        return ExceptionFactory.INSTANCE;
    }

    public static Factory nullFactory() {
        return ConstantFactory.NULL_INSTANCE;
    }

    public static <T> Factory<T> constantFactory(T constantToReturn) {
        return ConstantFactory.getInstance(constantToReturn);
    }

    public static <T> Factory<T> prototypeFactory(T prototype) {
        return PrototypeFactory.getInstance(prototype);
    }

    public static <T> Factory<T> instantiateFactory(Class<T> classToInstantiate) {
        return InstantiateFactory.getInstance(classToInstantiate, null, null);
    }

    public static <T> Factory<T> instantiateFactory(Class<T> classToInstantiate, Class[] paramTypes, Object[] args) {
        return InstantiateFactory.getInstance(classToInstantiate, paramTypes, args);
    }
}

