/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import de.rcenvironment.core.utils.common.TempFileService;
import java.io.File;
import java.io.IOException;
import java.util.function.BiFunction;
import java.util.function.Supplier;

class FileUtils {
    private BiFunction<File, String, File> createFile;
    private Supplier<ObjectWriter> createObjectWriter;
    private Supplier<ObjectMapper> createObjectMapper;
    private TempFileService tempFileService;

    FileUtils() {
    }

    public File createFile(File parent, String name) {
        return this.createFile.apply(parent, name);
    }

    public ObjectWriter getObjectWriter() {
        return this.createObjectWriter.get();
    }

    public ObjectMapper getObjectMapper() {
        return this.createObjectMapper.get();
    }

    public File createTempDir(String name) throws IOException {
        return this.tempFileService.createManagedTempDir(name);
    }

    public void setCreateFile(BiFunction<File, String, File> createFile) {
        this.createFile = createFile;
    }

    public void setCreateObjectWriter(Supplier<ObjectWriter> createObjectWriter) {
        this.createObjectWriter = createObjectWriter;
    }

    public void setCreateObjectMapper(Supplier<ObjectMapper> createObjectMapper) {
        this.createObjectMapper = createObjectMapper;
    }

    public void setTempFileService(TempFileService service) {
        this.tempFileService = service;
    }
}

