/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.workflow;

import de.rcenvironment.core.authorization.AuthorizationException;
import de.rcenvironment.core.communication.common.CommunicationException;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.component.api.ComponentException;
import de.rcenvironment.core.component.execution.api.ComponentContext;
import de.rcenvironment.core.component.integration.workflow.internal.WorkflowIntegrationContext;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.model.spi.DefaultComponent;
import de.rcenvironment.core.component.workflow.execution.api.PersistentWorkflowDescriptionLoaderService;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowFileException;
import de.rcenvironment.core.component.workflow.execution.spi.WorkflowDescriptionLoaderCallback;
import de.rcenvironment.core.component.workflow.model.api.WorkflowDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.datamanagement.DataManagementService;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapter;
import de.rcenvironment.core.workflow.execution.function.EndpointAdapters;
import de.rcenvironment.core.workflow.execution.function.WorkflowFunction;
import de.rcenvironment.core.workflow.execution.function.WorkflowFunctionException;
import de.rcenvironment.core.workflow.execution.function.WorkflowFunctionInputs;
import de.rcenvironment.core.workflow.execution.function.WorkflowFunctionResult;
import de.rcenvironment.core.workflow.execution.function.WorkflowFunctionService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.LogFactory;

public class WorkflowIntegratorComponent
extends DefaultComponent {
    private ComponentContext context;
    private PersistentWorkflowDescriptionLoaderService workflowLoaderService;
    private WorkflowFunctionService workflowFunctionService;

    public void setComponentContext(ComponentContext componentContext) {
        this.context = componentContext;
        this.workflowLoaderService = (PersistentWorkflowDescriptionLoaderService)this.context.getService(PersistentWorkflowDescriptionLoaderService.class);
        this.workflowFunctionService = (WorkflowFunctionService)this.context.getService(WorkflowFunctionService.class);
    }

    public boolean treatStartAsComponentRun() {
        return this.context.getInputs().isEmpty();
    }

    public void start() throws ComponentException {
        if (this.treatStartAsComponentRun()) {
            this.processInputs();
        }
    }

    public void processInputs() throws ComponentException {
        WorkflowFunctionResult workflowResult;
        List parsedEndpointAdapterConfiguration;
        super.processInputs();
        File workflowFile = this.getWorkflowFileAndAssertExistence();
        WorkflowDescription workflowDescription = this.loadWorkflowDescriptionFromFile(workflowFile);
        String endpointAdapterDefinitionsString = this.context.getConfigurationValue("endpointAdapters");
        try {
            parsedEndpointAdapterConfiguration = (List)JsonUtils.getDefaultObjectMapper().readValue(endpointAdapterDefinitionsString, LinkedList.class);
        }
        catch (IOException e) {
            throw new ComponentException("Error when deserializing endpointAdapterDefinitions", (Throwable)e);
        }
        EndpointAdapters.Builder endpointAdapterDefinitionsBuilder = new EndpointAdapters.Builder();
        LinkedList<ComponentException> thrownExceptions = new LinkedList<ComponentException>();
        EndpointAdapterFactory factory = new EndpointAdapterFactory(workflowDescription);
        for (Map parsedEndpointAdapterConfigurations : parsedEndpointAdapterConfiguration) {
            try {
                endpointAdapterDefinitionsBuilder.addEndpointAdapter(factory.buildFromMap(parsedEndpointAdapterConfigurations));
            }
            catch (ComponentException e) {
                thrownExceptions.add(e);
            }
            if (thrownExceptions.isEmpty()) continue;
            String joinedExceptionMessages = thrownExceptions.stream().map(exception -> exception.toString()).collect(Collectors.joining("; "));
            String errorMessage = "Errors in the configuration of endpoint adapters: " + joinedExceptionMessages;
            throw new ComponentException(errorMessage);
        }
        WorkflowFunction workflowFunction = this.workflowFunctionService.createBuilder().setComponentContext(this.context).withWorkflowDescription(workflowDescription).withEndpointAdapters(endpointAdapterDefinitionsBuilder.build()).withInternalName(this.context.getComponentName()).withExternalName(this.context.getInstanceName()).withCallingWorkflowName(this.context.getWorkflowInstanceName()).build();
        WorkflowFunctionInputs workflowInputs = this.createWorkflowInputsFromComponentContext();
        this.context.announceExternalProgramStart();
        try {
            workflowResult = workflowFunction.execute(workflowInputs);
        }
        catch (WorkflowFunctionException e) {
            throw new ComponentException("Could not execute underlying workflow", (Throwable)e);
        }
        this.context.announceExternalProgramTermination();
        if (workflowResult.isFailure()) {
            throw new ComponentException(StringUtils.format((String)"Execution of workflow %s failed", (Object[])new Object[]{workflowFile.getAbsolutePath()}));
        }
        for (Map.Entry<String, TypedDatum> result : workflowResult.toMap().entrySet()) {
            this.context.writeOutput(result.getKey(), result.getValue());
        }
    }

    private WorkflowFunctionInputs createWorkflowInputsFromComponentContext() throws ComponentException {
        Map<String, TypedDatum> inputs = this.context.getInputsWithDatum().stream().collect(Collectors.toMap(name -> name, arg_0 -> ((ComponentContext)this.context).readInput(arg_0)));
        DataManagementService dms = (DataManagementService)this.context.getService(DataManagementService.class);
        NetworkDestination outerWorkflowStorage = this.context.getStorageNetworkDestination();
        TempFileServiceAccess.getInstance();
        TypedDatumService tds = (TypedDatumService)this.context.getService(TypedDatumService.class);
        HashMap<String, TypedDatum> replacedInputs = new HashMap<String, TypedDatum>();
        for (Map.Entry<String, TypedDatum> nonreplacedInput : inputs.entrySet()) {
            FileReferenceTD nonreplacedDatum;
            if (nonreplacedInput.getValue() instanceof FileReferenceTD) {
                try {
                    File tempFile = this.createTempFile();
                    nonreplacedDatum = (FileReferenceTD)nonreplacedInput.getValue();
                    dms.copyReferenceToLocalFile(nonreplacedDatum.getFileReference(), tempFile, outerWorkflowStorage);
                    replacedInputs.put(nonreplacedInput.getKey(), (TypedDatum)tds.getFactory().createShortText(Paths.get(tempFile.getAbsolutePath(), new String[0]).toString()));
                    continue;
                }
                catch (AuthorizationException | CommunicationException | IOException e) {
                    throw new ComponentException("Error when copying outer inputs to inner ones", e);
                }
            }
            if (nonreplacedInput.getValue() instanceof DirectoryReferenceTD) {
                try {
                    File tempDir = this.createTempDir();
                    nonreplacedDatum = (DirectoryReferenceTD)nonreplacedInput.getValue();
                    dms.copyReferenceToLocalDirectory(nonreplacedDatum.getDirectoryReference(), tempDir, outerWorkflowStorage);
                    replacedInputs.put(nonreplacedInput.getKey(), (TypedDatum)tds.getFactory().createShortText(Paths.get(tempDir.getAbsolutePath(), nonreplacedDatum.getDirectoryName()).toString()));
                    LogFactory.getLog(WorkflowFunctionInputs.class).info((Object)StringUtils.format((String)"Copied directory to '%s'", (Object[])new Object[]{tempDir}));
                    continue;
                }
                catch (AuthorizationException | CommunicationException | IOException e) {
                    throw new ComponentException("Error when copying outer inputs to inner ones", e);
                }
            }
            replacedInputs.put(nonreplacedInput.getKey(), nonreplacedInput.getValue());
        }
        return WorkflowFunctionInputs.createFromMap(replacedInputs);
    }

    protected File createTempDir() throws IOException {
        return TempFileServiceAccess.getInstance().createManagedTempDir();
    }

    protected File createTempFile() throws IOException {
        return TempFileServiceAccess.getInstance().createTempFileFromPattern("*");
    }

    public File getWorkflowFileAndAssertExistence() throws ComponentException {
        WorkflowIntegrationContext workflowIntegrationContext = new WorkflowIntegrationContext();
        String workflowFilePath = String.join((CharSequence)File.separator, ((ConfigurationService)this.context.getService(ConfigurationService.class)).getConfigurablePath(ConfigurationService.ConfigurablePathId.DEFAULT_WRITEABLE_INTEGRATION_ROOT).getAbsolutePath(), workflowIntegrationContext.getNameOfToolIntegrationDirectory(), String.valueOf(workflowIntegrationContext.getToolDirectoryPrefix()) + this.context.getComponentName(), "workflow.wf");
        File workflowFile = this.createWorkflowFile(workflowFilePath);
        if (!this.fileExists(workflowFile)) {
            throw new ComponentException(StringUtils.format((String)"Path %s is expected to point to a workflow file. Instead, that path does not exist.", (Object[])new Object[]{workflowFile.getAbsolutePath()}));
        }
        if (!this.isFile(workflowFile)) {
            throw new ComponentException(StringUtils.format((String)"Path %s is expected to point to a workflow file, but points at something that is not a file. Hence, that workflow cannot be executed", (Object[])new Object[]{workflowFile.getAbsolutePath()}));
        }
        return workflowFile;
    }

    protected boolean isFile(File workflowFile) {
        return workflowFile.isFile();
    }

    protected boolean fileExists(File workflowFile) {
        return workflowFile.exists();
    }

    protected File createWorkflowFile(String workflowFilePath) {
        return new File(workflowFilePath);
    }

    private WorkflowDescription loadWorkflowDescriptionFromFile(File workflowFile) throws ComponentException {
        WorkflowDescriptionLoaderCallback loaderCallback = new WorkflowDescriptionLoaderCallback(){

            public void onWorkflowFileParsingPartlyFailed(String backupFilename) {
            }

            public void onSilentWorkflowFileUpdated(String message) {
            }

            public void onNonSilentWorkflowFileUpdated(String message, String backupFilename) {
            }

            public boolean arePartlyParsedWorkflowConsiderValid() {
                return false;
            }
        };
        try {
            return this.workflowLoaderService.loadWorkflowDescriptionFromFileConsideringUpdates(workflowFile, loaderCallback);
        }
        catch (WorkflowFileException e) {
            throw new ComponentException(StringUtils.format((String)"Unexpected exception thrown during parsing of file %s", (Object[])new Object[]{workflowFile.getAbsolutePath()}), (Throwable)e);
        }
    }

    public static class EndpointAdapterFactory {
        private static final String TYPE_KEY = "type";
        private static final String IDENTIFIER_KEY = "identifier";
        private static final String INTERNAL_NAME_KEY = "internalName";
        private static final String EXTERNAL_NAME_KEY = "externalName";
        private final WorkflowDescription description;
        private Map<String, String> configurationMap;
        private Collection<String> errorMessages = new LinkedList<String>();

        public EndpointAdapterFactory(WorkflowDescription descriptionParam) {
            this.description = descriptionParam;
        }

        public EndpointAdapter buildFromMap(Map<String, String> map) throws ComponentException {
            this.configurationMap = map;
            EndpointAdapter.Builder builder = "INPUT".equals(this.configurationMap.get(TYPE_KEY)) ? EndpointAdapter.inputAdapterBuilder() : EndpointAdapter.outputAdapterBuilder();
            this.initializeEndpointNames(builder);
            this.initializeAdaptedDataType(builder);
            this.initializeInputHandling(builder);
            this.initializeInputExecutionConstraint(builder);
            if (!this.configurationMap.containsKey(TYPE_KEY)) {
                this.errorMessages.add("Configuration does not key 'type', which must be set to ether 'INPUT' or 'OUTPUT'");
            } else if (!"INPUT".equals(this.configurationMap.get(TYPE_KEY)) && !"OUTPUT".equals(this.configurationMap.get(TYPE_KEY))) {
                String errorMessage = StringUtils.format((String)"Endpoint adapter defined as unknown type %s. Supported types: 'INPUT', 'OUTPUT'", (Object[])new Object[]{this.configurationMap.get(TYPE_KEY)});
                this.errorMessages.add(errorMessage);
            }
            this.throwExceptionIfErrorOccurred();
            if ("INPUT".equals(this.configurationMap.get(TYPE_KEY))) {
                return builder.build();
            }
            return builder.build();
        }

        private void initializeInputExecutionConstraint(EndpointAdapter.Builder builder) {
            if (!this.configurationMap.containsKey(IDENTIFIER_KEY)) {
                return;
            }
            boolean isInputAdapter = "INPUT".equals(this.configurationMap.get(TYPE_KEY));
            if (!isInputAdapter) {
                return;
            }
            Optional<EndpointDescription> adaptedInput = this.getAdaptedEndpoint();
            if (!adaptedInput.isPresent()) {
                return;
            }
            builder.inputExecutionConstraint(EndpointDefinition.InputExecutionContraint.valueOf((String)this.configurationMap.get("inputExecutionConstraint")));
        }

        private void initializeInputHandling(EndpointAdapter.Builder builder) {
            if (!this.configurationMap.containsKey(IDENTIFIER_KEY)) {
                return;
            }
            boolean isInputAdapter = "INPUT".equals(this.configurationMap.get(TYPE_KEY));
            if (!isInputAdapter) {
                return;
            }
            Optional<EndpointDescription> adaptedInput = this.getAdaptedEndpoint();
            if (!adaptedInput.isPresent()) {
                return;
            }
            builder.inputHandling(EndpointDefinition.InputDatumHandling.valueOf((String)this.configurationMap.get("inputHandling")));
        }

        private void throwExceptionIfErrorOccurred() throws ComponentException {
            if (this.errorMessages.isEmpty()) {
                return;
            }
            String unparsedConfigurationMap = this.configurationMap.entrySet().stream().map(entry -> StringUtils.format((String)"%s=%s", (Object[])new Object[]{entry.getKey(), entry.getValue()})).collect(Collectors.joining(", ", "{", "}"));
            String joinedErrorMessages = this.errorMessages.stream().collect(Collectors.joining(". "));
            throw new ComponentException(StringUtils.format((String)"Invalid endpoint adapter definition: %s. Specific errors: %s.", (Object[])new Object[]{unparsedConfigurationMap, joinedErrorMessages}));
        }

        private void initializeEndpointNames(EndpointAdapter.Builder builder) throws ComponentException {
            if (!this.configurationMap.containsKey(IDENTIFIER_KEY)) {
                this.errorMessages.add("Configuration does not contain required parameter 'identifier'");
            } else {
                builder.workflowNodeIdentifier(this.configurationMap.get(IDENTIFIER_KEY));
            }
            if (!this.configurationMap.containsKey(INTERNAL_NAME_KEY)) {
                this.errorMessages.add("Configuration does not contain required parameter 'internalName'");
            } else {
                builder.internalEndpointName(this.configurationMap.get(INTERNAL_NAME_KEY));
            }
            if (!this.configurationMap.containsKey(EXTERNAL_NAME_KEY)) {
                this.errorMessages.add("Configuration does not contain required parameter 'externalName'");
            } else {
                builder.externalEndpointName(this.configurationMap.get(EXTERNAL_NAME_KEY));
            }
        }

        private void initializeAdaptedDataType(EndpointAdapter.Builder builder) {
            if (!this.configurationMap.containsKey(IDENTIFIER_KEY)) {
                return;
            }
            Optional<EndpointDescription> internalEndpointDescription = this.getAdaptedEndpoint();
            if (!internalEndpointDescription.isPresent()) {
                this.errorMessages.add(StringUtils.format((String)"Endpoint with name '%s' at workflow node with ID '%s' is configured to pass values from or to the external workflow, but that endpoint does not exist on that node", (Object[])new Object[]{this.configurationMap.get(INTERNAL_NAME_KEY), this.configurationMap.get(IDENTIFIER_KEY)}));
                return;
            }
            builder.dataType(internalEndpointDescription.get().getDataType());
        }

        private Optional<EndpointDescription> getAdaptedEndpoint() {
            boolean isInputAdapter = "INPUT".equals(this.configurationMap.get(TYPE_KEY));
            String workflowNodeIdentifier = this.configurationMap.get(IDENTIFIER_KEY);
            Optional<WorkflowNode> adaptedWorkflowNode = this.description.getWorkflowNodes().stream().filter(node -> workflowNodeIdentifier.equals(node.getIdentifierAsObject().toString())).findAny();
            if (!adaptedWorkflowNode.isPresent()) {
                this.errorMessages.add(StringUtils.format((String)"Workflow node with identifier '%s' is configured to pass values from or to the external workflow, but that node does not exist in the workflow", (Object[])new Object[]{workflowNodeIdentifier}));
                return Optional.empty();
            }
            EndpointDescriptionsManager endpointDescriptions = isInputAdapter ? adaptedWorkflowNode.get().getInputDescriptionsManager() : adaptedWorkflowNode.get().getOutputDescriptionsManager();
            Stream allEndpointDescriptions = Stream.concat(endpointDescriptions.getDynamicEndpointDescriptions().stream(), endpointDescriptions.getStaticEndpointDescriptions().stream());
            Optional<EndpointDescription> internalEndpointDescription = allEndpointDescriptions.filter(endpointDescription -> endpointDescription.getName().equals(this.configurationMap.get(INTERNAL_NAME_KEY))).findAny();
            return internalEndpointDescription;
        }
    }
}

