/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.api;

import de.rcenvironment.core.command.common.CommandException;
import de.rcenvironment.core.command.spi.CommandContext;
import de.rcenvironment.core.command.spi.CommandDescription;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.monitoring.system.api.LocalSystemMonitoringAggregationService;
import de.rcenvironment.core.monitoring.system.api.model.AverageOfDoubles;
import de.rcenvironment.core.monitoring.system.api.model.SystemLoadInformation;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public class SystemMonitoringCommandPlugin
implements CommandPlugin {
    private static final String ROOT_COMMAND = "sysmon";
    private static final String SUBCOMMAND_FETCH_LOCAL = "local";
    private static final String SUBCOMMAND_FETCH_LOCAL_SHORT = "-l";
    private static final String SUBCOMMAND_FETCH_REMOTE = "remote";
    private static final String SUBCOMMAND_FETCH_REMOTE_SHORT = "-r";
    private static final String SUBCOMMAND_API = "api";
    private static final String SPACE = " ";
    private static final int DEFAULT_FETCH_TIME_SPAN_VALUE_SEC = 10;
    private static final int DEFAULT_FETCH_TIME_LIMIT_VALUE_MSEC = 1000;
    private static final int SEC_TO_MSEC = 1000;
    private LocalSystemMonitoringAggregationService localSystemMonitoringAggregationService;
    private CommunicationService communicationService;
    private InstanceNodeSessionId localInstanceNodeSessionId;

    public void execute(CommandContext context) throws CommandException {
        context.consumeExpectedToken(ROOT_COMMAND);
        String subCommand = context.consumeNextToken();
        if (subCommand == null) {
            throw CommandException.syntaxError((String)"Missing operation argument (e.g. \"sysmon remote\")", (CommandContext)context);
        }
        block7 : switch (subCommand) {
            case "-l": 
            case "local": {
                this.performPrintLocalSysMonData(context, 10000, 1000, true);
                break;
            }
            case "remote": 
            case "-r": {
                this.performCollectAndPrintSysMonData(context, 10000, 1000, true);
                break;
            }
            case "api": {
                String apiCall = context.consumeNextToken();
                if (apiCall == null) {
                    throw CommandException.wrongNumberOfParameters((CommandContext)context);
                }
                switch (apiCall) {
                    case "avgcpu+ram": 
                    case "default": {
                        int timeSpanSec = this.parseRequiredPositiveIntParameter(context, "time span");
                        int timeLimitMsec = this.parseRequiredPositiveIntParameter(context, "time limit");
                        this.performCollectAndPrintSysMonData(context, timeSpanSec * 1000, timeLimitMsec, false);
                        break block7;
                    }
                }
                throw CommandException.syntaxError((String)("Unknown API operation: " + apiCall), (CommandContext)context);
            }
            default: {
                throw CommandException.unknownCommand((CommandContext)context);
            }
        }
    }

    public Collection<CommandDescription> getCommandDescriptions() {
        ArrayList<CommandDescription> contributions = new ArrayList<CommandDescription>();
        contributions.add(new CommandDescription(ROOT_COMMAND, "local/-l", false, "prints system monitoring data for the local instance", new String[0]));
        contributions.add(new CommandDescription("sysmon remote", "/-r", false, "fetches system monitoring data from all reachable nodes in the network, and prints it in a human-readable format", new String[0]));
        contributions.add(new CommandDescription("sysmon api", "<operation>", false, "fetches system monitoring data from all reachable nodes in the network, and prints it in a parser-friendly format.", new String[]{"Available operations:", "  avgcpu+ram <time span> <time limit> - fetches the average CPU load over the given time span and the current free RAM", "Operation parameters:", "  time span - the maximum time span (in seconds) to aggregate load data over", "  time limit - the maximum time (in milliseconds) to wait for each node's load data response"}));
        return contributions;
    }

    public void bindLocalSystemMonitoringAggregationService(LocalSystemMonitoringAggregationService newInstance) {
        this.localSystemMonitoringAggregationService = newInstance;
    }

    public void bindCommunicationService(CommunicationService newInstance) {
        this.communicationService = newInstance;
    }

    public void bindPlatformService(PlatformService newInstance) {
        this.localInstanceNodeSessionId = newInstance.getLocalInstanceNodeSessionId();
    }

    private void performPrintLocalSysMonData(CommandContext context, int timeSpanMsec, int timeLimitMsec, boolean humanReadable) throws CommandException {
        HashSet<InstanceNodeSessionId> singleNodeIdSet = new HashSet<InstanceNodeSessionId>();
        singleNodeIdSet.add(this.localInstanceNodeSessionId);
        this.performCollectAndPrintSysMonData(context, singleNodeIdSet, timeSpanMsec, timeLimitMsec, humanReadable);
    }

    private void performCollectAndPrintSysMonData(CommandContext context, int timeSpanMsec, int timeLimitMsec, boolean humanReadable) throws CommandException {
        Set reachableInstanceNodes = this.communicationService.getReachableInstanceNodes();
        this.performCollectAndPrintSysMonData(context, reachableInstanceNodes, timeSpanMsec, timeLimitMsec, humanReadable);
    }

    private void performCollectAndPrintSysMonData(CommandContext context, Set<InstanceNodeSessionId> nodeIds, int timeSpanMsec, int timeLimitMsec, boolean humanReadable) throws CommandException {
        Map<InstanceNodeSessionId, SystemLoadInformation> resultMap;
        try {
            resultMap = this.localSystemMonitoringAggregationService.collectSystemMonitoringDataWithTimeLimit(nodeIds, timeSpanMsec, timeLimitMsec);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw CommandException.executionError((String)e.toString(), (CommandContext)context);
        }
        String formatString = humanReadable ? "%s - Average CPU load:%6.2f (%2d samples over %5d msec), Available RAM:%6d kiB" : "id=%s CpuAvg=%.2f n=%d t=%d FreeRam=%d";
        StringBuilder outputBuffer = new StringBuilder();
        for (Map.Entry<InstanceNodeSessionId, SystemLoadInformation> e : resultMap.entrySet()) {
            SystemLoadInformation data = e.getValue();
            AverageOfDoubles cpuLoadAvg = data.getCpuLoadAvg();
            String nodeIdString = e.getKey().getInstanceNodeSessionIdString();
            int cpuLoadAvgTimeSpan = cpuLoadAvg.getNumSamples() * 1000;
            double cpuAvgAsPercentage = cpuLoadAvg.getAverage() * 100.0;
            if (outputBuffer.length() != 0) {
                outputBuffer.append("\n");
            }
            outputBuffer.append(StringUtils.format((String)formatString, (Object[])new Object[]{nodeIdString, cpuAvgAsPercentage, cpuLoadAvg.getNumSamples(), cpuLoadAvgTimeSpan, data.getAvailableRam()}));
            if (!humanReadable) continue;
            outputBuffer.append(" (");
            outputBuffer.append(e.getKey().getAssociatedDisplayName());
            outputBuffer.append(")");
        }
        context.println((Object)outputBuffer.toString());
    }

    private int parseRequiredPositiveIntParameter(CommandContext context, String name) throws CommandException {
        int timespan;
        String parameter = context.consumeNextToken();
        if (parameter == null) {
            throw CommandException.wrongNumberOfParameters((CommandContext)context);
        }
        try {
            timespan = Integer.parseInt(parameter);
            if (timespan <= 0) {
                throw CommandException.syntaxError((String)("The " + name + " parameter must be positive: " + parameter), (CommandContext)context);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw CommandException.syntaxError((String)("The " + name + " parameter must be an integer number: " + parameter), (CommandContext)context);
        }
        return timespan;
    }
}

