/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelPendingMessagesQueue;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.forward.ForwardingTunnelEndpointsProvider;
import org.apache.sshd.common.forward.LocalForwardingEntry;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class TcpipClientChannel
extends AbstractClientChannel
implements ForwardingTunnelEndpointsProvider {
    protected final SshdSocketAddress remote;
    protected final IoSession serverSession;
    protected SshdSocketAddress localEntry;
    private final Type typeEnum;
    private final ClientChannelPendingMessagesQueue messagesQueue;
    private SshdSocketAddress tunnelEntrance;
    private SshdSocketAddress tunnelExit;

    public TcpipClientChannel(Type type, IoSession serverSession, SshdSocketAddress remote) {
        super(Objects.requireNonNull(type, "No type specified").getName());
        this.typeEnum = type;
        this.serverSession = Objects.requireNonNull(serverSession, "No server session provided");
        this.localEntry = new SshdSocketAddress((InetSocketAddress)serverSession.getLocalAddress());
        this.remote = remote;
        this.messagesQueue = new ClientChannelPendingMessagesQueue(this);
    }

    public OpenFuture getOpenFuture() {
        return this.openFuture;
    }

    public Type getTcpipChannelType() {
        return this.typeEnum;
    }

    public ClientChannelPendingMessagesQueue getPendingMessagesQueue() {
        return this.messagesQueue;
    }

    public void updateLocalForwardingEntry(LocalForwardingEntry entry) {
        Objects.requireNonNull(entry, "No local forwarding entry provided");
        this.localEntry = new SshdSocketAddress(entry.getAlias(), entry.getPort());
    }

    @Override
    public synchronized OpenFuture open() throws IOException {
        SshdSocketAddress dst;
        InetSocketAddress src;
        InetSocketAddress loc = (InetSocketAddress)this.serverSession.getLocalAddress();
        Type openType = this.getTcpipChannelType();
        switch (openType) {
            case Direct: {
                src = (InetSocketAddress)this.serverSession.getRemoteAddress();
                dst = this.remote;
                this.tunnelEntrance = new SshdSocketAddress(loc.getHostString(), loc.getPort());
                this.tunnelExit = new SshdSocketAddress(dst.getHostName(), dst.getPort());
                break;
            }
            case Forwarded: {
                src = (InetSocketAddress)this.serverSession.getRemoteAddress();
                dst = this.localEntry;
                this.tunnelEntrance = new SshdSocketAddress(src.getHostString(), src.getPort());
                this.tunnelExit = new SshdSocketAddress(loc.getHostString(), loc.getPort());
                break;
            }
            default: {
                throw new SshException("Unknown client channel type: " + (Object)((Object)openType));
            }
        }
        if (this.closeFuture.isClosed()) {
            throw new SshException("Session has been closed");
        }
        this.openFuture = (OpenFuture)new DefaultOpenFuture(src, this.futureLock).addListener(this.getPendingMessagesQueue());
        if (this.log.isDebugEnabled()) {
            this.log.debug("open({}) send SSH_MSG_CHANNEL_OPEN", (Object)this);
        }
        Session session = this.getSession();
        String srcHost = src.getHostString();
        String dstHost = dst.getHostName();
        Window wLocal = this.getLocalWindow();
        String type = this.getChannelType();
        Buffer buffer = session.createBuffer((byte)90, type.length() + srcHost.length() + dstHost.length() + 64);
        buffer.putString(type);
        buffer.putInt((long)this.getId());
        buffer.putInt(wLocal.getSize());
        buffer.putInt(wLocal.getPacketSize());
        buffer.putString(dstHost);
        buffer.putInt((long)dst.getPort());
        buffer.putString(srcHost);
        buffer.putInt((long)src.getPort());
        this.writePacket(buffer);
        return this.openFuture;
    }

    @Override
    protected synchronized void doOpen() throws IOException {
        if (this.streaming == ClientChannel.Streaming.Async) {
            throw new IllegalArgumentException("Asynchronous streaming isn't supported yet on this channel");
        }
        this.invertedIn = this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
    }

    @Override
    protected void preClose() {
        IOException err = IoUtils.closeQuietly((java.io.Closeable)this.getPendingMessagesQueue());
        if (err != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("preClose({}) Failed ({}) to close pending messages queue: {}", new Object[]{this, err.getClass().getSimpleName(), err.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("preClose(" + this + ") pending messages queue close failure details", (Throwable)err);
            }
        }
        super.preClose();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().sequential(new Closeable[]{this.serverSession, super.getInnerCloseable()}).build();
    }

    @Override
    protected synchronized void doWriteData(byte[] data, int off, long len) throws IOException {
        ValidateUtils.checkTrue((len <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Data length exceeds int boundaries: %d", (long)len);
        ByteArrayBuffer buf = ByteArrayBuffer.getCompactClone((byte[])data, (int)off, (int)((int)len));
        Window wLocal = this.getLocalWindow();
        wLocal.consumeAndCheck(len);
        this.serverSession.writePacket((Buffer)buf);
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, long len) throws IOException {
        throw new UnsupportedOperationException(this.getChannelType() + "Tcpip channel does not support extended data");
    }

    @Override
    public SshdSocketAddress getTunnelEntrance() {
        return this.tunnelEntrance;
    }

    @Override
    public SshdSocketAddress getTunnelExit() {
        return this.tunnelExit;
    }

    public static enum Type implements NamedResource
    {
        Direct("direct-tcpip"),
        Forwarded("forwarded-tcpip");

        public static final Set<Type> VALUES;
        private final String channelType;

        private Type(String channelType) {
            this.channelType = channelType;
        }

        public String getName() {
            return this.channelType;
        }

        static {
            VALUES = Collections.unmodifiableSet(EnumSet.allOf(Type.class));
        }
    }
}

