/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.text;

import com.googlecode.lanterna.LanternaException;
import com.googlecode.lanterna.input.InputDecoder;
import com.googlecode.lanterna.terminal.InputEnabledAbstractTerminal;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public abstract class StreamBasedTerminal
extends InputEnabledAbstractTerminal {
    private static Charset UTF8_REFERENCE;
    private final OutputStream terminalOutput;
    private final Charset terminalCharset;
    protected final Object writerMutex = new Object();

    public StreamBasedTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) {
        super(new InputDecoder(new InputStreamReader(terminalInput, terminalCharset)));
        this.terminalOutput = terminalOutput;
        this.terminalCharset = terminalCharset == null ? Charset.defaultCharset() : terminalCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putCharacter(char c) {
        Object object = this.writerMutex;
        synchronized (object) {
            this.writeToTerminal(this.translateCharacter(c));
        }
    }

    protected void writeToTerminal(byte ... bytes) {
        try {
            this.terminalOutput.write(bytes);
        }
        catch (IOException e) {
            throw new LanternaException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.terminalOutput.flush();
        }
        catch (IOException e) {
            throw new LanternaException(e);
        }
    }

    protected byte[] translateCharacter(char input) {
        if (UTF8_REFERENCE != null && UTF8_REFERENCE == this.terminalCharset) {
            return this.convertToCharset(input);
        }
        switch (input) {
            case '\u2193': {
                return this.convertToVT100('v');
            }
            case '\u2190': {
                return this.convertToVT100('<');
            }
            case '\u2192': {
                return this.convertToVT100('>');
            }
            case '\u2191': {
                return this.convertToVT100('^');
            }
            case '\u2588': 
            case '\u2591': 
            case '\u2592': 
            case '\u2593': {
                return this.convertToVT100('a');
            }
            case '\u2660': 
            case '\u2663': 
            case '\u2665': {
                return this.convertToVT100('?');
            }
            case '\u263a': 
            case '\u263b': 
            case '\u2666': {
                return this.convertToVT100('`');
            }
            case '\u2022': {
                return this.convertToVT100('f');
            }
            case '\u253c': 
            case '\u256c': {
                return this.convertToVT100('n');
            }
            case '\u2500': 
            case '\u2550': {
                return this.convertToVT100('q');
            }
            case '\u2514': 
            case '\u255a': {
                return this.convertToVT100('m');
            }
            case '\u2518': 
            case '\u255d': {
                return this.convertToVT100('j');
            }
            case '\u252c': 
            case '\u2564': 
            case '\u2565': 
            case '\u2566': {
                return this.convertToVT100('w');
            }
            case '\u2524': 
            case '\u2561': 
            case '\u2562': 
            case '\u2563': {
                return this.convertToVT100('u');
            }
            case '\u251c': 
            case '\u255e': 
            case '\u255f': 
            case '\u2560': {
                return this.convertToVT100('t');
            }
            case '\u2534': 
            case '\u2567': 
            case '\u2569': 
            case '\u256b': {
                return this.convertToVT100('v');
            }
            case '\u250c': 
            case '\u2554': {
                return this.convertToVT100('l');
            }
            case '\u2510': 
            case '\u2557': {
                return this.convertToVT100('k');
            }
            case '\u2502': 
            case '\u2551': {
                return this.convertToVT100('x');
            }
        }
        return this.convertToCharset(input);
    }

    private byte[] convertToVT100(char code) {
        return new byte[]{27, 40, 48, (byte)code, 27, 40, 66};
    }

    private byte[] convertToCharset(char input) {
        char[] buffer = new char[]{input};
        return this.terminalCharset.encode(CharBuffer.wrap(buffer)).array();
    }

    static {
        try {
            UTF8_REFERENCE = Charset.forName("UTF-8");
        }
        catch (Exception e) {
            UTF8_REFERENCE = null;
        }
    }
}

