/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.integration.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.component.api.ComponentConstants;
import de.rcenvironment.core.component.api.ComponentIdRules;
import de.rcenvironment.core.component.integration.ConfigurationMap;
import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.component.integration.ToolIntegrationService;
import de.rcenvironment.core.component.integration.internal.IconHelper;
import de.rcenvironment.core.component.integration.internal.ToolIntegrationFileWatcherManager;
import de.rcenvironment.core.component.management.api.LocalComponentRegistrationService;
import de.rcenvironment.core.component.model.api.ComponentInstallation;
import de.rcenvironment.core.component.model.api.ComponentInstallationBuilder;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.api.ComponentInterfaceBuilder;
import de.rcenvironment.core.component.model.api.ComponentRevision;
import de.rcenvironment.core.component.model.api.ComponentRevisionBuilder;
import de.rcenvironment.core.component.model.configuration.api.ComponentConfigurationModelFactory;
import de.rcenvironment.core.component.model.configuration.api.ConfigurationDefinition;
import de.rcenvironment.core.component.model.endpoint.api.ComponentEndpointModelFactory;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionBuilder;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinitionsProvider;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataConstants;
import de.rcenvironment.core.component.model.impl.ToolIntegrationConstants;
import de.rcenvironment.core.configuration.CommandLineArguments;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.CrossPlatformFilenameUtils;
import de.rcenvironment.core.utils.common.FileCompressionFormat;
import de.rcenvironment.core.utils.common.FileCompressionService;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.ServiceUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class ToolIntegrationServiceImpl
implements ToolIntegrationService {
    private static final String WARNING_INVALID_TOOL = "Tool Integration: Tool %s has been disabled. Reason: Invalid %s. %s.";
    private static final String IDENTIFIER = "identifier";
    private static final String META_DATA = "metaData";
    private static final String NAME = "name";
    private static final String DATA_TYPES = "dataTypes";
    private static final String DEFAULT_DATA_TYPE = "defaultDataType";
    private static final String INPUT_HANDLINGS = "inputHandlingOptions";
    private static final String DEFAULT_INPUT_HANDLING = "defaultInputHandling";
    private static final String INPUT_EXECUTION_CONSTRAINTS = "inputExecutionConstraintOptions";
    private static final String DEFAULT_INPUT_EXECUTION_CONSTRAINT = "defaultInputExecutionConstraint";
    private static final String STRING_0 = "0";
    private static final String DEFAULT_VALUE = "defaultValue";
    private static final String POSSIBLE_VALUES = "possibleValues";
    private static final String COULD_NOT_READ_TOOL_CONFIGURATION = "Could not read tool configuration: ";
    private static final String ERROR_WRITING_TOOL_INTEGRATION_CONFIG_FILE = "Error writing tool integration config file: ";
    private static final BigInteger DOCU_DIRECTORY_MAXIMUM_SIZE = new BigInteger("52428800");
    private final Map<String, String> toolNameToPath = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<String, Object>> integratedConfiguration = Collections.synchronizedMap(new HashMap());
    @Deprecated
    private final Set<String> publishedComponents = Collections.synchronizedSet(new HashSet());
    private final Semaphore sequentialToolInitializationSemaphore = new Semaphore(1);
    private final ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private ToolIntegrationFileWatcherManager watchManager;
    private ToolIntegrationContextRegistry toolIntegrationContextRegistry;
    private LocalComponentRegistrationService localComponentRegistry;
    private LogicalNodeId localLogicalNodeId;
    private IconHelper iconHelper;
    private final AsyncTaskService asyncTaskService = ConcurrencyUtils.getAsyncTaskService();
    private final CountDownLatch initializationComplete = new CountDownLatch(1);
    private final Log log = LogFactory.getLog(ToolIntegrationServiceImpl.class);
    private ToolIntegrationFileWatcherManager.Builder fileWatcherManagerBuilder;

    @Override
    public void integrateTool(Map<String, Object> configurationMap, ToolIntegrationContext context) {
        this.integrateTool(configurationMap, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void integrateTool(Map<String, Object> rawConfigurationMap, ToolIntegrationContext context, boolean savePublished) {
        ConfigurationDefinition configuration;
        EndpointDefinitionsProvider outputProvider;
        EndpointDefinitionsProvider inputProvider;
        String groupName;
        String version;
        ConfigurationMap configurationMap = context.parseConfigurationMap(rawConfigurationMap).get();
        String toolComponentID = String.valueOf(context.getPrefixForComponentId()) + configurationMap.getToolName();
        String toolClassName = context.getImplementingComponentClassName();
        File toolDirFile = this.createToolDirFile(configurationMap, context);
        byte[] icon16 = this.iconHelper.getIcon(IconSize.ICONSIZE16, configurationMap, toolDirFile);
        byte[] icon32 = this.iconHelper.getIcon(IconSize.ICONSIZE32, configurationMap, toolDirFile);
        String docuHash = this.createDocumentationHash(configurationMap, context);
        String toolName = configurationMap.getToolName();
        if (!this.areConfigurationIdsValid(toolName, version = configurationMap.getToolVersion(), groupName = configurationMap.getGroupName())) {
            this.removeTool(toolComponentID, context);
            return;
        }
        try {
            Set<EndpointDefinition> inputs = this.createInputs(configurationMap);
            inputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(inputs);
            Set<EndpointDefinition> outputs = this.createOutputs(configurationMap);
            outputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(outputs);
            configuration = configurationMap.generateConfiguration(this);
        }
        catch (IllegalArgumentException e) {
            this.log.warn((Object)StringUtils.format((String)"Could not read endpoints from %s: ", (Object[])new Object[]{toolComponentID}), (Throwable)e);
            inputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(new HashSet());
            outputProvider = ComponentEndpointModelFactory.createEndpointDefinitionsProvider(new HashSet());
            configuration = ComponentConfigurationModelFactory.createEmptyConfigurationDefinition();
        }
        if (groupName == null || groupName.isEmpty()) {
            groupName = context.getDefaultComponentGroupId();
        }
        LinkedList<String> supportedIds = new LinkedList<String>();
        supportedIds.add(toolComponentID);
        supportedIds.add(StringUtils.format((String)"%s_%s", (Object[])new Object[]{ToolIntegrationConstants.COMPONENT_IDS[1], configurationMap.getToolName()}));
        ComponentInterface componentInterface = new ComponentInterfaceBuilder().setIdentifier(toolComponentID).setIdentifiers(supportedIds).setDisplayName(configurationMap.getToolName()).setGroupName(groupName).setIcon16(icon16).setIcon32(icon32).setDocumentationHash(docuHash).setVersion(version).setInputDefinitionsProvider(inputProvider).setOutputDefinitionsProvider(outputProvider).setConfigurationDefinition(configuration).setConfigurationExtensionDefinitions(new HashSet()).setColor(ComponentConstants.COMPONENT_COLOR_STANDARD).setShape(ComponentConstants.COMPONENT_SHAPE_STANDARD).setSize(ComponentConstants.COMPONENT_SIZE_STANDARD).build();
        String limitExecutionCount = configurationMap.getExecutionCountLimit();
        String maxParallelCountString = configurationMap.getMaxParallelCount();
        Integer maxParallelCount = null;
        if (limitExecutionCount != null && Boolean.parseBoolean(limitExecutionCount) && maxParallelCountString != null && !maxParallelCountString.equals("") && (maxParallelCount = Integer.valueOf(Integer.parseInt(maxParallelCountString))) < 1) {
            this.log.error((Object)StringUtils.format((String)"A maximum count of parallel executions of %d is invalid, it must be >= 1; a maximum count of 1 is used instead", (Object[])new Object[]{maxParallelCount}));
            maxParallelCount = 1;
        }
        ComponentRevision componentRevision = new ComponentRevisionBuilder().setComponentInterface(componentInterface).setClassName(toolClassName).build();
        ComponentInstallation componentInstallation = new ComponentInstallationBuilder().setComponentRevision(componentRevision).setNodeId(this.localLogicalNodeId).setInstallationId(componentInterface.getIdentifierAndVersion()).setMaximumCountOfParallelInstances(maxParallelCount).build();
        if (configurationMap.isActive().orElse(true).booleanValue()) {
            this.localComponentRegistry.registerOrUpdateLocalComponentInstallation(componentInstallation);
        }
        Map<String, Map<String, Object>> map = this.integratedConfiguration;
        synchronized (map) {
            this.integratedConfiguration.put(toolComponentID, configurationMap.getShallowClone());
        }
        this.log.debug((Object)("ToolIntegration: Registered new Component " + toolComponentID));
    }

    private boolean areConfigurationIdsValid(String toolName, String version, String groupName) {
        Optional groupValidation;
        Optional versionValidation;
        boolean valid = true;
        Optional toolNameValidation = ComponentIdRules.validateComponentIdRules((String)toolName);
        if (toolNameValidation.isPresent()) {
            this.log.warn((Object)StringUtils.format((String)WARNING_INVALID_TOOL, (Object[])new Object[]{toolName, "tool name", toolNameValidation.get()}));
            valid = false;
        }
        if (version != null && (versionValidation = ComponentIdRules.validateComponentVersionRules((String)version)).isPresent()) {
            this.log.warn((Object)StringUtils.format((String)WARNING_INVALID_TOOL, (Object[])new Object[]{toolName, "version", versionValidation.get()}));
            valid = false;
        }
        if (groupName != null && !groupName.isEmpty() && (groupValidation = ComponentIdRules.validateComponentGroupNameRules((String)groupName)).isPresent()) {
            this.log.warn((Object)StringUtils.format((String)WARNING_INVALID_TOOL, (Object[])new Object[]{toolName, "group name", groupValidation.get()}));
            valid = false;
        }
        return valid;
    }

    private String createDocumentationHash(ConfigurationMap configurationMap, ToolIntegrationContext context) {
        File toolDir = this.createToolDirFile(configurationMap, context);
        File docDir = new File(toolDir, "docs");
        if (!docDir.exists()) {
            docDir.mkdirs();
        }
        if (docDir.listFiles() != null && docDir.listFiles().length > 0 && docDir.exists() && this.validateDocumentationDirectory(docDir)) {
            byte[] zippedByteArray = FileCompressionService.compressDirectoryToByteArray((File)docDir, (FileCompressionFormat)FileCompressionFormat.ZIP, (Boolean)false);
            if (zippedByteArray == null) {
                this.log.error((Object)"Was not able to create hash for documentation due to an issue with the compression.");
                return "";
            }
            return DigestUtils.md5Hex((byte[])zippedByteArray);
        }
        return "";
    }

    private boolean validateDocumentationDirectory(File docDir) {
        boolean valid = true;
        BigInteger directorySize = FileUtils.sizeOfDirectoryAsBigInteger((File)docDir);
        if (DOCU_DIRECTORY_MAXIMUM_SIZE.compareTo(directorySize) < 0) {
            this.log.error((Object)StringUtils.format((String)"Size of documentation directory %s too big (max. 50 Mb).", (Object[])new Object[]{docDir.getAbsolutePath()}));
            valid = false;
        }
        File[] fileArray = docDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.log.error((Object)StringUtils.format((String)"Directories not allowed in documentation directory %s.", (Object[])new Object[]{docDir.getAbsolutePath()}));
                valid = false;
            } else if (!ArrayUtils.contains((Object[])ToolIntegrationConstants.VALID_DOCUMENTATION_EXTENSIONS, (Object)FilenameUtils.getExtension((String)f.getName())) && !CrossPlatformFilenameUtils.isNFSFile((String)f.getName())) {
                this.log.error((Object)StringUtils.format((String)"Invalid filetype of %s in documentation directory %s. (Valid filetypes: %s)", (Object[])new Object[]{f.getName(), docDir.getAbsolutePath(), Arrays.toString(ToolIntegrationConstants.VALID_DOCUMENTATION_EXTENSIONS).replaceAll("\\[", "").replaceAll("\\]", "")}));
                valid = false;
            }
            ++n2;
        }
        return valid;
    }

    private File createToolDirFile(ConfigurationMap configurationMap, ToolIntegrationContext context) {
        return new File(new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory()), configurationMap.getToolName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTool(String componentID, ToolIntegrationContext context) {
        String toolComponentID = componentID;
        if (!componentID.startsWith(context.getPrefixForComponentId())) {
            toolComponentID = String.valueOf(context.getPrefixForComponentId()) + componentID;
        }
        if (this.integratedConfiguration.containsKey(toolComponentID)) {
            String toolIDAndVersion = String.valueOf(toolComponentID) + "/" + (String)((Map)((List)this.integratedConfiguration.get(toolComponentID).get("launchSettings")).get(0)).get("version");
            Map<String, Map<String, Object>> map = this.integratedConfiguration;
            synchronized (map) {
                this.integratedConfiguration.remove(toolComponentID);
            }
            this.localComponentRegistry.unregisterLocalComponentInstallation(toolIDAndVersion);
        }
        this.log.debug((Object)("ToolIntegration: Removed Component " + toolComponentID));
    }

    private Set<EndpointDefinition> createOutputs(ConfigurationMap configurationMap) {
        List<Map<String, Object>> dynamicOutputs;
        List<Map<String, String>> definedOutputs = configurationMap.getStaticOutputs();
        HashSet<EndpointDefinition> outputs = new HashSet<EndpointDefinition>();
        if (definedOutputs != null) {
            for (Map<String, String> output : definedOutputs) {
                HashMap<String, Object> description = new HashMap<String, Object>();
                description.put(NAME, output.get("endpointName"));
                description.put(DEFAULT_DATA_TYPE, output.get("endpointDataType"));
                LinkedList<String> dataTypes = new LinkedList<String>();
                dataTypes.add(output.get("endpointDataType"));
                description.put(DATA_TYPES, dataTypes);
                outputs.add(ComponentEndpointModelFactory.createEndpointDefinition(description, (EndpointType)EndpointType.OUTPUT));
            }
        }
        if ((dynamicOutputs = configurationMap.getDynamicOutputs()) != null) {
            for (Map<String, Object> output : dynamicOutputs) {
                HashMap<String, Object> description = new HashMap<String, Object>();
                description.put(IDENTIFIER, output.get("endpointIdentifier"));
                description.put(DEFAULT_DATA_TYPE, output.get("endpointDefaultDataType"));
                LinkedList dataTypes = new LinkedList();
                dataTypes.addAll((List)output.get("endpointDataTypes"));
                description.put(DATA_TYPES, dataTypes);
                Map metadata = (Map)output.get("endpointMetaData");
                description.put(META_DATA, metadata);
                outputs.add(ComponentEndpointModelFactory.createEndpointDefinition(description, (EndpointType)EndpointType.OUTPUT));
            }
        }
        return outputs;
    }

    private Set<EndpointDefinition> createInputs(ConfigurationMap configurationMap) {
        HashMap metadata;
        HashSet<EndpointDefinition> inputs = new HashSet<EndpointDefinition>();
        for (Map<String, String> input : configurationMap.getStaticInputs()) {
            String[] inputExecutionConstraints;
            String[] inputHandlings;
            EndpointDefinitionBuilder descriptionBuilder = EndpointDefinition.inputBuilder().name(input.get("endpointName")).defaultDatatype(DataType.valueOf((String)input.get("endpointDataType"))).allowedDatatype(DataType.valueOf((String)input.get("endpointDataType")));
            if (input.containsKey("inputHandling")) {
                inputHandlings = StringUtils.splitAndUnescape((String)input.get("inputHandling"));
                if (input.containsKey(DEFAULT_INPUT_HANDLING)) {
                    descriptionBuilder.defaultInputHandling(EndpointDefinition.InputDatumHandling.valueOf((String)input.get(DEFAULT_INPUT_HANDLING)));
                } else {
                    descriptionBuilder.defaultInputHandling(EndpointDefinition.InputDatumHandling.valueOf((String)inputHandlings[0]));
                }
            } else {
                inputHandlings = new String[]{EndpointDefinition.InputDatumHandling.Single.name()};
                if (input.get("endpointUsage").equals("initial")) {
                    inputHandlings = new String[]{EndpointDefinition.InputDatumHandling.Constant.name()};
                }
                descriptionBuilder.defaultInputHandling(EndpointDefinition.InputDatumHandling.valueOf((String)inputHandlings[0]));
            }
            descriptionBuilder.inputHandlings((Collection)Arrays.asList(inputHandlings).stream().map(EndpointDefinition.InputDatumHandling::valueOf).collect(Collectors.toList()));
            if (input.containsKey("inputExecutionConstraint")) {
                inputExecutionConstraints = StringUtils.splitAndUnescape((String)input.get("inputExecutionConstraint"));
                if (input.containsKey(DEFAULT_INPUT_EXECUTION_CONSTRAINT)) {
                    descriptionBuilder.defaultInputExecutionConstraint(EndpointDefinition.InputExecutionContraint.valueOf((String)input.get(DEFAULT_INPUT_EXECUTION_CONSTRAINT)));
                } else {
                    descriptionBuilder.defaultInputExecutionConstraint(EndpointDefinition.InputExecutionContraint.valueOf((String)inputExecutionConstraints[0]));
                }
            } else {
                inputExecutionConstraints = new String[]{EndpointDefinition.InputExecutionContraint.Required.name()};
                if (input.get("endpointUsage").equals("optional")) {
                    inputExecutionConstraints = new String[]{EndpointDefinition.InputExecutionContraint.NotRequired.name()};
                }
                descriptionBuilder.defaultInputExecutionConstraint(EndpointDefinition.InputExecutionContraint.valueOf((String)inputExecutionConstraints[0]));
            }
            descriptionBuilder.inputExecutionConstraints((Collection)Arrays.asList(inputExecutionConstraints).stream().map(EndpointDefinition.InputExecutionContraint::valueOf).collect(Collectors.toList()));
            metadata = new HashMap();
            if ((input.get("endpointDataType").equals(DataType.FileReference.name()) || input.get("endpointDataType").equals(DataType.DirectoryReference.name())) && input.get("endpointFileName") != null) {
                HashMap<String, Object> metadataFilename = new HashMap<String, Object>();
                metadataFilename.put("guiName", "Filename");
                metadataFilename.put("guiPosition", STRING_0);
                metadataFilename.put("guiGroup", "File");
                LinkedList<String> possibleValuesListFilename = new LinkedList<String>();
                possibleValuesListFilename.add(input.get("endpointFileName"));
                metadataFilename.put(POSSIBLE_VALUES, possibleValuesListFilename);
                metadataFilename.put(DEFAULT_VALUE, input.get("endpointFileName"));
                metadataFilename.put("visibility", EndpointMetaDataConstants.Visibility.developerConfigurable.toString());
                metadata.put("endpointFileName", metadataFilename);
            }
            descriptionBuilder.metadata(metadata);
            inputs.add(descriptionBuilder.build());
        }
        if (configurationMap.containsDynamicInputs()) {
            List<Map<String, Object>> dynamicInputs = configurationMap.getDynamicInputs();
            for (Map<String, Object> input : dynamicInputs) {
                LinkedList<String> inputHandlingOptions;
                HashMap<String, Object> description = new HashMap<String, Object>();
                description.put(IDENTIFIER, input.get("endpointIdentifier"));
                description.put(DEFAULT_DATA_TYPE, input.get("endpointDefaultDataType"));
                LinkedList dataTypes = new LinkedList();
                dataTypes.addAll((List)input.get("endpointDataTypes"));
                description.put(DATA_TYPES, dataTypes);
                metadata = (HashMap)input.get("endpointMetaData");
                description.put(META_DATA, metadata);
                if (metadata.containsKey("usage")) {
                    description.put(DEFAULT_INPUT_HANDLING, EndpointDefinition.InputDatumHandling.Single.name());
                    inputHandlingOptions = new LinkedList<String>();
                    inputHandlingOptions.add(EndpointDefinition.InputDatumHandling.Single.name());
                    inputHandlingOptions.add(EndpointDefinition.InputDatumHandling.Constant.name());
                    description.put(INPUT_HANDLINGS, inputHandlingOptions);
                    description.put(DEFAULT_INPUT_EXECUTION_CONSTRAINT, EndpointDefinition.InputExecutionContraint.Required.name());
                    LinkedList<String> inputinputExecutionConstraintOptions = new LinkedList<String>();
                    inputinputExecutionConstraintOptions.add(EndpointDefinition.InputExecutionContraint.Required.name());
                    inputinputExecutionConstraintOptions.add(EndpointDefinition.InputExecutionContraint.RequiredIfConnected.name());
                    description.put(INPUT_EXECUTION_CONSTRAINTS, inputinputExecutionConstraintOptions);
                    metadata.remove("usage");
                } else {
                    if (input.containsKey("inputinputHandlingOptions")) {
                        description.put(DEFAULT_INPUT_HANDLING, input.get(DEFAULT_INPUT_HANDLING));
                        inputHandlingOptions = new LinkedList();
                        inputHandlingOptions.addAll((List)input.get("inputinputHandlingOptions"));
                        description.put(INPUT_HANDLINGS, inputHandlingOptions);
                    }
                    if (input.containsKey("inputinputExecutionConstraintOptions")) {
                        description.put(DEFAULT_INPUT_EXECUTION_CONSTRAINT, input.get(DEFAULT_INPUT_EXECUTION_CONSTRAINT));
                        LinkedList inputinputExecutionConstraintOptions = new LinkedList();
                        inputinputExecutionConstraintOptions.addAll((List)input.get("inputinputExecutionConstraintOptions"));
                        description.put(INPUT_EXECUTION_CONSTRAINTS, inputinputExecutionConstraintOptions);
                    }
                }
                inputs.add(ComponentEndpointModelFactory.createEndpointDefinition(description, (EndpointType)EndpointType.INPUT));
            }
        }
        return inputs;
    }

    private void initializeExistingToolsInContext(ToolIntegrationContext context) {
        String configFolder = context.getRootPathToToolIntegrationDirectory();
        File toolIntegrationFile = new File(configFolder, context.getNameOfToolIntegrationDirectory());
        this.readPublishedComponents(context);
        if (toolIntegrationFile.exists() && toolIntegrationFile.isDirectory() && toolIntegrationFile.listFiles().length > 0) {
            this.log.debug((Object)("Initializing tool integration root directory " + toolIntegrationFile.getAbsolutePath()));
            File[] fileArray = toolIntegrationFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File toolFolder = fileArray[n2];
                if (toolFolder.isDirectory() && !toolFolder.getName().equals("null")) {
                    this.log.debug((Object)("Initializing tool directory " + toolFolder.getAbsolutePath()));
                    try {
                        this.readToolDirectory(toolFolder, context);
                    }
                    catch (RuntimeException e) {
                        String errorMessage = StringUtils.format((String)"Exception caught during integration of tool directory %s", (Object[])new Object[]{toolFolder.getAbsolutePath()});
                        this.log.error((Object)errorMessage, (Throwable)e);
                    }
                }
                ++n2;
            }
        }
    }

    private void readToolDirectory(File toolFolder, ToolIntegrationContext context) {
        File configFile = new File(toolFolder, context.getConfigurationFilename());
        if (configFile.exists() && configFile.isFile()) {
            try {
                Map configurationMap = (Map)this.mapper.readValue(configFile, new HashMap().getClass());
                if (!this.integratedConfiguration.containsKey(String.valueOf(context.getPrefixForComponentId()) + configurationMap.get("toolName"))) {
                    this.toolNameToPath.put((String)configurationMap.get("toolName"), toolFolder.getAbsolutePath());
                    if (!this.isToolIntegrated(configurationMap, context)) {
                        this.integrateTool(configurationMap, context);
                    }
                } else {
                    this.log.warn((Object)("Tool with foldername already exists:  " + toolFolder.getName()));
                }
            }
            catch (IOException e) {
                this.log.error((Object)COULD_NOT_READ_TOOL_CONFIGURATION, (Throwable)e);
            }
        }
    }

    @Override
    public void writeToolIntegrationFileToSpecifiedFolder(String folder, Map<String, Object> rawConfigurationMap, ToolIntegrationContext information) throws IOException {
        ConfigurationMap configurationMap = information.parseConfigurationMap(rawConfigurationMap).get();
        if (!configurationMap.hasIntegrationVersion()) {
            configurationMap.setIntegrationVersion(1);
        }
        configurationMap.applyMigration(this::migrateDeprecatedInstanceLimitKey);
        File toolConfigFile = new File(folder, String.valueOf(information.getNameOfToolIntegrationDirectory()) + File.separator + information.getToolDirectoryPrefix() + configurationMap.getToolName());
        toolConfigFile.mkdirs();
        this.iconHelper.prescaleAndCopyIcon(configurationMap, toolConfigFile);
        this.handleDoc(configurationMap, toolConfigFile);
        Map<String, Object> sortedMap = configurationMap.getShallowClone();
        this.mapper.writerWithDefaultPrettyPrinter().writeValue(new File(toolConfigFile, information.getConfigurationFilename()), sortedMap);
        this.toolNameToPath.put(configurationMap.getToolName(), toolConfigFile.getAbsolutePath());
    }

    private void migrateDeprecatedInstanceLimitKey(Map<String, Object> backingMap) {
        Map launchSettings = (Map)((List)backingMap.get("launchSettings")).get(0);
        String value = (String)launchSettings.remove("limitInstalltionInstances");
        if (!launchSettings.containsKey("limitInstallationInstances") && value != null) {
            launchSettings.put("limitInstallationInstances", value);
        }
    }

    private void handleDoc(ConfigurationMap configurationMap, File toolConfigFile) {
        if (!configurationMap.containsDocFilePath() || configurationMap.getDocFilePath().isEmpty()) {
            return;
        }
        File docfile = new File(configurationMap.getDocFilePath());
        File docDir = new File(toolConfigFile, "docs");
        if (docfile.isAbsolute() && docfile.exists() && docfile.isFile()) {
            File destination;
            if (docDir.exists() && docDir.listFiles().length > 0) {
                File[] fileArray = docDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    try {
                        FileUtils.forceDelete((File)f);
                    }
                    catch (IOException e) {
                        this.log.error((Object)("Could not delete old documentation file: " + f.getAbsolutePath() + ": " + e.getMessage()));
                    }
                    ++n2;
                }
            }
            if (!(destination = new File(docDir, docfile.getName())).getAbsolutePath().equals(docfile.getAbsolutePath())) {
                try {
                    FileUtils.copyFile((File)docfile, (File)destination);
                    configurationMap.setDocFilePath(docfile.getName());
                }
                catch (IOException e) {
                    this.log.error((Object)"Could not copy documentation to tool directory: ", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void writeToolIntegrationFile(Map<String, Object> configurationMap, ToolIntegrationContext information) throws IOException {
        String configFolder = information.getRootPathToToolIntegrationDirectory();
        this.writeToolIntegrationFileToSpecifiedFolder(configFolder, configurationMap, information);
    }

    private void readPublishedComponents(ToolIntegrationContext context) {
        File toolsfolder = new File(context.getRootPathToToolIntegrationDirectory(), context.getNameOfToolIntegrationDirectory());
        if (toolsfolder.exists()) {
            try {
                File publishedComponentsFile = new File(toolsfolder, "published.conf");
                if (publishedComponentsFile.isFile()) {
                    HashSet newPublishedComponents = new HashSet(FileUtils.readLines((File)publishedComponentsFile));
                    for (String newComp : newPublishedComponents) {
                        String comp = newComp.trim();
                        if (comp.isEmpty()) continue;
                        this.log.warn((Object)("Read the deprecated component publication entry \"" + comp + "\" from configuration file " + publishedComponentsFile.getAbsolutePath() + ", but it will not be applied; use the component authorization system to publish integrated tools. " + "Delete this file to get rid of this warning."));
                    }
                }
            }
            catch (IOException e) {
                this.log.error((Object)ERROR_WRITING_TOOL_INTEGRATION_CONFIG_FILE, (Throwable)e);
            }
        }
    }

    @Override
    public synchronized Map<String, Object> getToolConfiguration(String toolId) {
        return this.integratedConfiguration.get(toolId);
    }

    @Override
    public synchronized Set<String> getIntegratedComponentIds() {
        return this.integratedConfiguration.keySet();
    }

    @Override
    public synchronized Set<String> getActiveComponentIds() {
        HashSet<String> activeIds = new HashSet<String>();
        for (String key : this.integratedConfiguration.keySet()) {
            if (this.integratedConfiguration.get(key).get("isActive") != null && !((Boolean)this.integratedConfiguration.get(key).get("isActive")).booleanValue()) continue;
            activeIds.add(key);
        }
        return activeIds;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.watchManager = this.fileWatcherManagerBuilder.build(this);
        this.asyncTaskService.execute("Initialize all provided ToolIntegrationContexts", () -> {
            ToolIntegrationContext context;
            while (bundleContext.getBundle().getState() == 32 && (context = this.toolIntegrationContextRegistry.fetchNextUninitializedToolIntegrationContext()) != null) {
                if (CommandLineArguments.isDoNotStartComponentsRequested()) continue;
                this.log.debug((Object)("Registering " + ToolIntegrationContext.class.getSimpleName() + " " + context.getContextId()));
                this.integrateToolIntegrationContext(context);
            }
            this.log.debug((Object)("Finished processing tool integration contexts from " + ToolIntegrationContext.class.getSimpleName() + " queue"));
            this.initializationComplete.countDown();
            if (bundleContext.getBundle().getState() == 32) {
                this.localComponentRegistry.reportToolIntegrationRegistrationComplete();
            } else {
                this.log.debug((Object)"Skipping 'tool integration complete' trigger as this bundle seems to be shutting down");
            }
        });
    }

    @Deactivate
    protected void deactivateIntegrationService() {
        try {
            if (!this.initializationComplete.await(10L, TimeUnit.SECONDS)) {
                this.log.warn((Object)"Exceeded timeout while waiting for initialization to finish");
            }
        }
        catch (InterruptedException e) {
            this.log.warn((Object)"Interrupted while waiting for initialization to finish", (Throwable)e);
        }
        this.watchManager.shutdown();
    }

    @Reference
    protected void bindToolIntegrationContextRegistry(ToolIntegrationContextRegistry newInstance) {
        this.toolIntegrationContextRegistry = newInstance;
    }

    @Reference
    protected void bindFileWatcherManagerBuilder(ToolIntegrationFileWatcherManager.Builder newInstance) {
        this.fileWatcherManagerBuilder = newInstance;
    }

    @Reference(unbind="unbindComponentRegistry")
    protected void bindComponentRegistry(LocalComponentRegistrationService newRegistry) {
        this.localComponentRegistry = newRegistry;
    }

    protected void unbindComponentRegistry(LocalComponentRegistrationService newRegistry) {
        this.localComponentRegistry = (LocalComponentRegistrationService)ServiceUtils.createFailingServiceProxy(LocalComponentRegistrationService.class);
    }

    @Reference
    protected void bindPlatformService(PlatformService newService) {
        this.localLogicalNodeId = newService.getLocalDefaultLogicalNodeId();
    }

    @Override
    public String getPathOfComponentID(String id, ToolIntegrationContext context) {
        if (id.startsWith(context.getPrefixForComponentId())) {
            return this.toolNameToPath.get(id.substring(context.getPrefixForComponentId().length()));
        }
        return this.toolNameToPath.get(id);
    }

    @Override
    public boolean isToolIntegrated(Map<String, Object> configurationMap, ToolIntegrationContext integrationContext) {
        String toolComponentID = String.valueOf(integrationContext.getPrefixForComponentId()) + (String)configurationMap.get("toolName");
        return this.integratedConfiguration.keySet().contains(toolComponentID);
    }

    @Override
    public String getToolNameToPath(String path) {
        for (Map.Entry<String, String> e : this.toolNameToPath.entrySet()) {
            if (!e.getValue().trim().equals(path.trim())) continue;
            return e.getKey();
        }
        return null;
    }

    @Override
    public void putToolNameToPath(String toolName, File parentFile) {
        this.toolNameToPath.put(toolName, parentFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePublishedComponents(ToolIntegrationContext context) {
        HashSet<String> oldPublishedComponents = new HashSet<String>();
        Set<String> set = this.publishedComponents;
        synchronized (set) {
            Map<String, Object> configuration;
            String toolComponentID;
            oldPublishedComponents.addAll(this.publishedComponents);
            HashSet<String> toRemove = new HashSet<String>();
            for (String path : this.publishedComponents) {
                if (!path.startsWith(String.valueOf(context.getRootPathToToolIntegrationDirectory()) + File.separator + context.getNameOfToolIntegrationDirectory())) continue;
                toRemove.add(path);
            }
            this.publishedComponents.removeAll(toRemove);
            this.readPublishedComponents(context);
            HashSet<String> addPublished = new HashSet<String>();
            for (String newComp : this.publishedComponents) {
                if (oldPublishedComponents.contains(newComp) || !newComp.startsWith(String.valueOf(context.getRootPathToToolIntegrationDirectory()) + File.separator + context.getNameOfToolIntegrationDirectory())) continue;
                addPublished.add(newComp);
            }
            HashSet<String> removePublished = new HashSet<String>();
            for (String oldComp : oldPublishedComponents) {
                if (this.publishedComponents.contains(oldComp) || !oldComp.startsWith(String.valueOf(context.getRootPathToToolIntegrationDirectory()) + File.separator + context.getNameOfToolIntegrationDirectory())) continue;
                removePublished.add(oldComp);
            }
            for (String path : addPublished) {
                toolComponentID = String.valueOf(context.getPrefixForComponentId()) + this.getToolNameToPath(path);
                configuration = this.integratedConfiguration.get(toolComponentID);
                this.removeTool(toolComponentID, context);
                if (configuration == null) continue;
                this.integrateTool(configuration, context, false);
            }
            for (String path : removePublished) {
                toolComponentID = String.valueOf(context.getPrefixForComponentId()) + this.getToolNameToPath(path);
                configuration = this.integratedConfiguration.get(toolComponentID);
                this.removeTool(toolComponentID, context);
                if (configuration == null) continue;
                this.integrateTool(configuration, context, false);
            }
        }
    }

    @Override
    public byte[] getToolDocumentation(String identifier) throws RemoteOperationException {
        ToolIntegrationContext context = this.getContextForIdentifier(identifier);
        if (context == null) {
            return null;
        }
        String name = identifier.substring(context.getPrefixForComponentId().length());
        File sourceDirectory = new File(this.toolNameToPath.get(name = name.substring(0, name.indexOf("/"))), "docs");
        byte[] resultData = FileCompressionService.compressDirectoryToByteArray((File)sourceDirectory, (FileCompressionFormat)FileCompressionFormat.ZIP, (Boolean)false);
        if (resultData == null) {
            this.log.error((Object)"Was not able to create an archive for documentation due to a compression issue.");
            return null;
        }
        return resultData;
    }

    private ToolIntegrationContext getContextForIdentifier(String identifier) {
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)this);
        ToolIntegrationContextRegistry contextRegistry = (ToolIntegrationContextRegistry)serviceRegistryAccess.getService(ToolIntegrationContextRegistry.class);
        Optional<ToolIntegrationContext> result = contextRegistry.getAllIntegrationContexts().stream().filter(context -> identifier.startsWith(context.getPrefixForComponentId())).findAny();
        return result.orElse(null);
    }

    @Override
    public void setFileWatcherActive(boolean value) {
        this.watchManager.setAllWatcherActivity(value);
    }

    @Override
    public void unregisterIntegration(String previousToolName, ToolIntegrationContext integrationContext) {
        this.watchManager.unregister(previousToolName, integrationContext);
    }

    @Override
    public void registerRecursive(String toolName, ToolIntegrationContext integrationContext) {
        this.watchManager.registerRecursive(toolName, integrationContext);
    }

    private void integrateToolIntegrationContext(ToolIntegrationContext context) {
        try {
            this.sequentialToolInitializationSemaphore.acquire();
            try {
                this.log.debug((Object)("Initializing existing tools for context " + context.getContextType()));
                this.initializeExistingToolsInContext(context);
                this.log.debug((Object)("Creating tool watcher for context " + context.getContextType()));
                this.watchManager.createWatcherForToolRootDirectory(context);
                this.updatePublishedComponents(context);
                this.log.debug((Object)("Finished initialization of context " + context.getContextType()));
            }
            finally {
                this.sequentialToolInitializationSemaphore.release();
            }
        }
        catch (InterruptedException interruptedException) {
            this.log.debug((Object)"Interrupted during tool integration");
            Thread.currentThread().interrupt();
            return;
        }
    }

    @Reference
    private void bindIconHelper(IconHelper newInstance) {
        this.iconHelper = newInstance;
    }

    private void unbindIconHelper(IconHelper oldInstance) {
        this.iconHelper = null;
    }

    static enum IconSize {
        ICONSIZE16(16, "icon16.png"),
        ICONSIZE24(24, "icon24.png"),
        ICONSIZE32(32, "icon32.png");

        private final int size;
        private final String path;

        private IconSize(int size, String path) {
            this.size = size;
            this.path = path;
        }

        public int getSize() {
            return this.size;
        }

        public String getPath() {
            return this.path;
        }
    }
}

