/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.configuration;

import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommunicationConfiguration {
    public static final int CONNECTION_HEALTH_CHECK_INTERVAL_MSEC = 20000;
    public static final int CONNECTION_HEALTH_CHECK_MAX_JITTER_MSEC = 7000;
    public static final int CONNECTION_HEALTH_CHECK_TIMEOUT_MSEC = 10000;
    public static final int CONNECTION_HEALTH_CHECK_FAILURE_LIMIT = 3;
    public static final int DEFAULT_REQUEST_TIMEOUT_MSEC = 40000;
    public static final int DEFAULT_FORWARDING_TIMEOUT_MSEC = 35000;
    private static final int MAX_VALID_PORT = 65535;
    private static final String COMMA = ",";
    private List<String> providedContactPoints = new ArrayList<String>();
    private List<String> remoteContactPoints = new ArrayList<String>();
    private int requestTimeoutMsec = 40000;
    private int forwardingTimeoutMsec = 35000;
    private final Log log = LogFactory.getLog(this.getClass());
    private String nodeIdOverrideValue;

    public CommunicationConfiguration() {
    }

    public CommunicationConfiguration(ConfigurationSegment configuration) {
        Map serverPortElements;
        this.requestTimeoutMsec = configuration.getLong("requestTimeoutMsec", Long.valueOf(40000L)).intValue();
        this.forwardingTimeoutMsec = configuration.getLong("forwardingTimeoutMsec", Long.valueOf(35000L)).intValue();
        Map connectionElements = configuration.listElements("connections");
        if (connectionElements != null) {
            for (Map.Entry entry : connectionElements.entrySet()) {
                ConfigurationSegment configPart = (ConfigurationSegment)entry.getValue();
                try {
                    String connection = this.parseConnectionEntry(configPart);
                    this.remoteContactPoints.add(connection);
                }
                catch (ConfigurationException e) {
                    this.log.error((Object)("Error in network connection entry \"" + (String)entry.getKey() + "\": " + e.getMessage()));
                }
            }
        }
        if ((serverPortElements = configuration.listElements("serverPorts")) != null) {
            for (Map.Entry entry : serverPortElements.entrySet()) {
                ConfigurationSegment configPart = (ConfigurationSegment)entry.getValue();
                try {
                    String serverPort = this.parseServerPortEntry(configPart);
                    this.providedContactPoints.add(serverPort);
                }
                catch (ConfigurationException e) {
                    this.log.error((Object)("Error in server port entry " + (String)entry.getKey() + ": " + e.getMessage()));
                }
            }
        }
        this.nodeIdOverrideValue = configuration.getString("customNodeId");
    }

    private String parseConnectionEntry(ConfigurationSegment connectionPart) throws ConfigurationException {
        Double autoRetryDelayMultiplier;
        Long autoRetryMaximumDelay;
        String host = connectionPart.getString("host");
        if (host == null) {
            throw new ConfigurationException("Missing required parameter \"host\"");
        }
        Long portString = connectionPart.getLong("port");
        if (portString == null) {
            throw new ConfigurationException("Missing required parameter \"port\"");
        }
        int port = portString.intValue();
        StringBuilder options = new StringBuilder();
        Long autoRetryInitialDelay = connectionPart.getLong("autoRetryInitialDelay");
        if (autoRetryInitialDelay != null) {
            options.append("autoRetryInitialDelay=");
            options.append(autoRetryInitialDelay);
            options.append(COMMA);
        }
        if ((autoRetryMaximumDelay = connectionPart.getLong("autoRetryMaximumDelay")) != null) {
            options.append("autoRetryMaximumDelay=");
            options.append(autoRetryMaximumDelay);
            options.append(COMMA);
        }
        if ((autoRetryDelayMultiplier = connectionPart.getDouble("autoRetryDelayMultiplier")) != null) {
            options.append("autoRetryDelayMultiplier=");
            options.append(autoRetryDelayMultiplier);
            options.append(COMMA);
        }
        boolean connectOnStartup = connectionPart.getBoolean("connectOnStartup", Boolean.valueOf(true));
        options.append("connectOnStartup=");
        options.append(Boolean.toString(connectOnStartup));
        options.append(COMMA);
        if (options.length() != 0) {
            options.setLength(options.length() - 1);
        }
        String connection = StringUtils.format((String)"activemq-tcp:%s:%d(%s)", (Object[])new Object[]{host, port, options.toString()});
        return connection;
    }

    private String parseServerPortEntry(ConfigurationSegment connectionPart) throws ConfigurationException {
        String ip = connectionPart.getString("ip");
        if (ip == null || ip.trim().isEmpty()) {
            throw new ConfigurationException("Missing or invalid \"ip\" parameter");
        }
        Long port = connectionPart.getLong("port");
        if (port == null || port < 1L || port > 65535L) {
            throw new ConfigurationException("Missing or invalid \"port\" parameter");
        }
        return StringUtils.format((String)"activemq-tcp:%s:%d", (Object[])new Object[]{ip, port.intValue()});
    }

    public List<String> getProvidedContactPoints() {
        return this.providedContactPoints;
    }

    public void setProvidedContactPoints(List<String> providedContactPoints) {
        this.providedContactPoints = providedContactPoints;
    }

    public List<String> getRemoteContactPoints() {
        return this.remoteContactPoints;
    }

    public void setRemoteContactPoints(List<String> remoteContactPoints) {
        this.remoteContactPoints = remoteContactPoints;
    }

    public int getRequestTimeoutMsec() {
        return this.requestTimeoutMsec;
    }

    public void setRequestTimeoutMsec(int requestTimeoutMsec) {
        this.requestTimeoutMsec = requestTimeoutMsec;
    }

    public int getForwardingTimeoutMsec() {
        return this.forwardingTimeoutMsec;
    }

    public void setForwardingTimeoutMsec(int forwardingTimeoutMsec) {
        this.forwardingTimeoutMsec = forwardingTimeoutMsec;
    }

    public String getNodeIdOverrideValue() {
        return this.nodeIdOverrideValue;
    }
}

