/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.encryption;

import de.rcenvironment.core.utils.encryption.EncryptionFactory;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;

public class KeyPairFactory {
    private static final int RSA_ENCRYPTION_SIZE = 2048;

    public Key[] createKeyPair(EncryptionFactory.KeyBasedEncryptionAlgorithm algorithm) {
        KeyPairGenerator keygen;
        Key[] keyPair = new Key[2];
        try {
            keygen = KeyPairGenerator.getInstance(algorithm.name());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("encryption algorithm RSA not supported");
        }
        keygen.initialize(2048);
        KeyPair rsaKeys = keygen.genKeyPair();
        keyPair[0] = rsaKeys.getPrivate();
        keyPair[1] = rsaKeys.getPublic();
        return keyPair;
    }
}

