/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowCommand;
import org.eclipse.gef.commands.CommandStack;

class CompositeCommand
extends WorkflowCommand {
    private boolean done = false;
    private final WorkflowCommand command1;
    private final WorkflowCommand command2;

    CompositeCommand(WorkflowCommand command1, WorkflowCommand command2) {
        this.command1 = command1;
        this.command2 = command2;
    }

    @Override
    public void setCommandStack(CommandStack commandStack) {
        super.setCommandStack(commandStack);
        this.command1.setCommandStack(commandStack);
        this.command2.setCommandStack(commandStack);
    }

    public WorkflowCommand getCommand1() {
        return this.command1;
    }

    public WorkflowCommand getCommand2() {
        return this.command2;
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    @Override
    public void initialize() {
        this.command1.initialize();
        this.command2.initialize();
    }

    @Override
    public boolean canExecute() {
        return !this.canUndo();
    }

    @Override
    public boolean canUndo() {
        return this.done;
    }

    @Override
    public void redo() {
        this.execute();
    }

    @Override
    public void execute() {
        try {
            this.command1.execute();
            this.command2.execute();
        }
        finally {
            this.done = true;
        }
    }

    @Override
    public void undo() {
        this.command2.undo();
        this.command1.undo();
        this.done = false;
    }
}

