/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.wizards.toolintegration;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.component.integration.ToolIntegrationContext;
import de.rcenvironment.core.gui.wizards.toolintegration.ChooseConfigurationPage;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class RemoveToolIntegrationDialog
extends Dialog {
    private static final Log LOGGER = LogFactory.getLog(ChooseConfigurationPage.class);
    private static final int LIST_HEIGHT = 200;
    private static final int LIST_WIDTH = 300;
    private final ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private final Set<String> integratedConfigs;
    private String[] selectedTools = null;
    private List toolList;
    private Button keepOnDiskButton;
    private boolean keepOnDisk;
    private final Map<String, String> integrationMapping;
    private Map<String, Map<String, Object>> allConfigurations;

    public RemoveToolIntegrationDialog(Shell parent, Set<String> integratedConfigurations, Collection<ToolIntegrationContext> contexts) {
        super(parent);
        this.integratedConfigs = integratedConfigurations;
        this.integrationMapping = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        this.allConfigurations = new TreeMap<String, Map<String, Object>>();
        this.readExistingConfigurations(contexts);
        block0: for (String config : this.integratedConfigs) {
            for (ToolIntegrationContext c : contexts) {
                if (!config.contains(c.getPrefixForComponentId())) continue;
                this.integrationMapping.put(this.createDisplayedToolName(config.substring(c.getPrefixForComponentId().length())), config);
                continue block0;
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Deactivate Tool");
        shell.setImage(null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, true));
        GridData g = new GridData(1808);
        g.grabExcessHorizontalSpace = true;
        g.horizontalAlignment = 2;
        container.setLayoutData((Object)g);
        new Label(container, 0).setText("Choose tool configuration to deactivate: ");
        this.toolList = new List(container, 2050);
        GridData toolListData = new GridData(1808);
        toolListData.widthHint = 300;
        toolListData.heightHint = 200;
        this.toolList.setLayoutData((Object)toolListData);
        for (String key : this.integrationMapping.keySet()) {
            this.toolList.add(key);
        }
        this.toolList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (RemoveToolIntegrationDialog.this.toolList.getSelectionCount() > 0) {
                    RemoveToolIntegrationDialog.this.selectedTools = RemoveToolIntegrationDialog.this.toolList.getSelection();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.keepOnDiskButton = new Button(container, 32);
        this.keepOnDiskButton.setText("Keep tool configuration on disk");
        this.keepOnDiskButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                RemoveToolIntegrationDialog.this.keepOnDisk = RemoveToolIntegrationDialog.this.keepOnDiskButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        this.keepOnDiskButton.setSelection(true);
        this.keepOnDisk = true;
        return container;
    }

    public boolean getKeepOnDisk() {
        return this.keepOnDisk;
    }

    public String[] getSelectedTools() {
        if (this.selectedTools != null && this.selectedTools.length > 0) {
            String[] selectedIDs = new String[this.selectedTools.length];
            int i = 0;
            while (i < this.selectedTools.length) {
                selectedIDs[i] = this.integrationMapping.get(this.selectedTools[i]);
                ++i;
            }
            return selectedIDs;
        }
        return new String[0];
    }

    public void setSelectedTools(String[] selectedTools) {
        this.selectedTools = selectedTools;
    }

    private void readExistingConfigurations(Collection<ToolIntegrationContext> contexts) {
        for (ToolIntegrationContext context : contexts) {
            String configFolder = context.getRootPathToToolIntegrationDirectory();
            File toolIntegrationFile = new File(configFolder, context.getNameOfToolIntegrationDirectory());
            if (!toolIntegrationFile.exists() || !toolIntegrationFile.isDirectory() || toolIntegrationFile.listFiles() == null || toolIntegrationFile.listFiles().length <= 0) continue;
            File[] fileArray = toolIntegrationFile.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File toolFolder = fileArray[n2];
                if (toolFolder != null && toolFolder.isDirectory() && !toolFolder.getName().equals("null") && toolFolder.listFiles() != null && toolFolder.listFiles().length > 0) {
                    File[] files;
                    File[] fileArray2 = files = toolFolder.listFiles();
                    int n3 = files.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File f = fileArray2[n4];
                        if (f.getName().equals(context.getConfigurationFilename())) {
                            try {
                                Map configurationMap = (Map)this.mapper.readValue(f, new HashMap().getClass());
                                this.allConfigurations.put((String)configurationMap.get("toolName"), configurationMap);
                            }
                            catch (IOException e) {
                                LOGGER.error((Object)"Could not read configuration file: ", (Throwable)e);
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }

    public String createDisplayedToolName(String toolName) {
        String type = "Common";
        if (this.allConfigurations.get(toolName).get("integrationType") != null) {
            type = (String)this.allConfigurations.get(toolName).get("integrationType");
        }
        ArrayList launchSettings = (ArrayList)this.allConfigurations.get(toolName).get("launchSettings");
        String version = (String)((LinkedHashMap)launchSettings.get(0)).get("version");
        Object[] toolInformation = new Object[]{toolName, version, type};
        String displayedToolName = StringUtils.format((String)"%s (%s; Type: %s)", (Object[])toolInformation);
        return displayedToolName;
    }
}

