/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.session.internal;

import de.rcenvironment.core.communication.uplink.network.api.MessageBlockPriority;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlock;
import de.rcenvironment.core.communication.uplink.network.internal.MessageBlockWithMetadata;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BoundedMessageBlockPrioritizer {
    private static final int NUM_PRIORITY_LEVELS = MessageBlockPriority.values().length;
    private final List<LinkedBlockingQueue<MessageBlockWithMetadata>> queuesByPriority = new ArrayList<LinkedBlockingQueue<MessageBlockWithMetadata>>(NUM_PRIORITY_LEVELS);
    private final Log log = LogFactory.getLog(this.getClass());

    public BoundedMessageBlockPrioritizer(int maxMessagesPerPriority) {
        int i = 0;
        while (i < NUM_PRIORITY_LEVELS) {
            this.queuesByPriority.add(new LinkedBlockingQueue(maxMessagesPerPriority));
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(MessageBlockWithMetadata messageBlock, String logPrefix) throws InterruptedException {
        LinkedBlockingQueue<MessageBlockWithMetadata> queue;
        Objects.requireNonNull(messageBlock);
        messageBlock.setLocalQueueStartTime(System.currentTimeMillis());
        MessageBlockPriority priority = messageBlock.getPriority();
        LinkedBlockingQueue<MessageBlockWithMetadata> linkedBlockingQueue = queue = this.queuesByPriority.get(priority.getIndex());
        synchronized (linkedBlockingQueue) {
            if (!queue.offer(messageBlock)) {
                MessageBlockWithMetadata headElement = queue.peek();
                if (headElement != null) {
                    long waitTimeOfHeadElement = System.currentTimeMillis() - headElement.getLocalQueueStartTime();
                    this.log.debug((Object)StringUtils.format((String)"%sStalling a message of type %s as there are already %d messages queued for priority %s; longest queue time: %d msec", (Object[])new Object[]{logPrefix, messageBlock.getType(), queue.size(), priority.name(), waitTimeOfHeadElement}));
                }
                queue.put(messageBlock);
            }
        }
    }

    public MessageBlockWithMetadata takeNext() throws NoSuchElementException {
        int i = 0;
        while (i < NUM_PRIORITY_LEVELS) {
            MessageBlockWithMetadata pollResult = this.queuesByPriority.get(i).poll();
            if (pollResult != null) {
                return pollResult;
            }
            ++i;
        }
        throw new NoSuchElementException("Expected to find a queued " + MessageBlock.class.getSimpleName());
    }
}

