/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.resources;

import java.io.File;
import org.eclipse.rap.rwt.internal.util.ParamCheck;

public class ResourceDirectory {
    public static final String DIRNAME = "rwt-resources";
    private File resourcesDir;

    public void configure(String contextDirectory) {
        ParamCheck.notNull(contextDirectory, "contextDirectory");
        this.resourcesDir = new File(contextDirectory, DIRNAME);
    }

    public void reset() {
        this.resourcesDir = null;
    }

    public void createDirectory() {
        if (!this.resourcesDir.exists()) {
            this.resourcesDir.mkdirs();
        }
    }

    public void deleteDirectory() {
        ResourceDirectory.delete(this.resourcesDir);
    }

    public File getDirectory() {
        if (this.resourcesDir == null) {
            throw new IllegalStateException("Resources directory not configured");
        }
        return this.resourcesDir;
    }

    private static void delete(File file) {
        if (file.isDirectory()) {
            ResourceDirectory.deleteChildren(file);
        }
        ResourceDirectory.deleteFile(file);
    }

    private static void deleteChildren(File file) {
        File[] fileArray = file.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            ResourceDirectory.delete(child);
            ++n2;
        }
    }

    private static void deleteFile(File file) {
        if (!file.delete() && file.exists()) {
            throw new IllegalStateException("Could not delete: " + file.getPath());
        }
    }
}

