/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.workflow.execution.function;

import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Objects;

public class EndpointAdapter {
    private boolean isInputAdapter;
    private String workflowNodeIdentifier;
    private String internalEndpointName;
    private String externalEndpointName;
    private DataType adaptedDataType;
    private EndpointDefinition.InputDatumHandling datumHandling;
    private EndpointDefinition.InputExecutionContraint executionContraint;

    public static Builder inputAdapterBuilder() {
        Builder returnValue = new Builder();
        ((Builder)returnValue).product.isInputAdapter = true;
        return returnValue;
    }

    public static Builder outputAdapterBuilder() {
        Builder returnValue = new Builder();
        ((Builder)returnValue).product.isInputAdapter = false;
        return returnValue;
    }

    public String toString() {
        if (this.isInputAdapter) {
            return StringUtils.format((String)"%s --[%s,%s,%s]-> %s @ %s", (Object[])new Object[]{this.getExternalName(), this.getDataType(), this.datumHandling, this.executionContraint, this.getInternalName(), this.getWorkflowNodeIdentifier()});
        }
        return StringUtils.format((String)"%s @ %s --[%s]-> %s", (Object[])new Object[]{this.getInternalName(), this.getWorkflowNodeIdentifier(), this.getDataType(), this.getExternalName()});
    }

    public boolean isInputAdapter() {
        return this.isInputAdapter;
    }

    public boolean isOutputAdapter() {
        return !this.isInputAdapter;
    }

    public String getWorkflowNodeIdentifier() {
        return this.workflowNodeIdentifier;
    }

    public String getInternalName() {
        return this.internalEndpointName;
    }

    public String getExternalName() {
        return this.externalEndpointName;
    }

    public DataType getDataType() {
        return this.adaptedDataType;
    }

    public EndpointDefinition.InputExecutionContraint getInputExecutionConstraint() {
        return this.executionContraint;
    }

    public EndpointDefinition.InputDatumHandling getInputDatumHandling() {
        return this.datumHandling;
    }

    public static class Builder {
        private final EndpointAdapter product = new EndpointAdapter();

        protected Builder() {
        }

        public Builder internalEndpointName(String name) {
            this.product.internalEndpointName = name;
            return this;
        }

        public Builder externalEndpointName(String name) {
            this.product.externalEndpointName = name;
            return this;
        }

        public Builder workflowNodeIdentifier(String id) {
            this.product.workflowNodeIdentifier = id;
            return this;
        }

        public Builder dataType(DataType type) {
            this.product.adaptedDataType = type;
            return this;
        }

        public Builder inputHandling(EndpointDefinition.InputDatumHandling inputDatumHandling) {
            this.product.datumHandling = inputDatumHandling;
            return this;
        }

        public Builder inputExecutionConstraint(EndpointDefinition.InputExecutionContraint executionConstraint) {
            this.product.executionContraint = executionConstraint;
            return this;
        }

        private void assertProductIsValid() {
            Objects.requireNonNull(this.product.internalEndpointName);
            Objects.requireNonNull(this.product.externalEndpointName);
            Objects.requireNonNull(this.product.workflowNodeIdentifier);
            Objects.requireNonNull(this.product.adaptedDataType);
            if (this.product.isInputAdapter) {
                this.assertInputDefinitionsSet();
            }
        }

        private void assertInputDefinitionsSet() {
            if (this.product.datumHandling == null) {
                throw new IllegalStateException("Input handling must be set before constructing input adapter");
            }
            if (this.product.executionContraint == null) {
                throw new IllegalStateException("Input execution constraint must be set before constructing input adapter");
            }
        }

        public EndpointAdapter build() {
            this.assertProductIsValid();
            return this.product;
        }
    }
}

