/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.console;

import de.rcenvironment.core.component.execution.api.ConsoleRow;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class ConsoleColumnSorter
extends ViewerSorter {
    private static final int FIRST_IS_EQUAL = 0;
    private static final int FIRST_IS_GREATER = 1;
    private static final int FIRST_IS_LESS = -1;
    private static final int SORT_ASCENDING = 1;
    private static final int SORT_DESCENDING = 2;
    private int direction = 1;
    private int columnToSort = 1;

    public void setColumn(int column) {
        if (column == this.columnToSort) {
            this.direction = 1 == this.direction ? 2 : 1;
        } else {
            this.columnToSort = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object object1, Object object2) {
        int returnValue = 0;
        if (object1 instanceof ConsoleRow && object2 instanceof ConsoleRow) {
            ConsoleRow cr1 = (ConsoleRow)object1;
            ConsoleRow cr2 = (ConsoleRow)object2;
            switch (this.columnToSort) {
                case 0: {
                    if (cr1.getType() == cr2.getType()) {
                        returnValue = 0;
                        break;
                    }
                    if (cr1.getType() == ConsoleRow.Type.TOOL_ERROR) {
                        returnValue = 1;
                        break;
                    }
                    if (cr1.getType() == ConsoleRow.Type.TOOL_OUT) {
                        if (cr2.getType() == ConsoleRow.Type.TOOL_ERROR) {
                            returnValue = -1;
                            break;
                        }
                        returnValue = 1;
                        break;
                    }
                    returnValue = -1;
                    break;
                }
                case 1: {
                    if (cr1.getTimestamp() == cr2.getTimestamp()) {
                        returnValue = cr1.compareTo((Object)cr2);
                        break;
                    }
                    returnValue = new Long(cr1.getTimestamp()).compareTo(cr2.getTimestamp());
                    break;
                }
                case 2: {
                    returnValue = cr1.getPayload().compareTo(cr2.getPayload());
                    break;
                }
                case 3: {
                    returnValue = cr1.getComponentName().compareTo(cr2.getComponentName());
                    break;
                }
                case 4: {
                    returnValue = cr1.getWorkflowName().compareTo(cr2.getWorkflowName());
                    break;
                }
            }
            if (2 == this.direction) {
                returnValue = -returnValue;
            }
        }
        return returnValue;
    }
}

