/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.properties;

import de.rcenvironment.core.component.model.configuration.api.ConfigurationDescription;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescriptionsManager;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataConstants;
import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.utils.common.endpoint.EndpointHelper;
import de.rcenvironment.core.gui.utils.incubator.AlphanumericalTextContraintListener;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.properties.Messages;
import de.rcenvironment.core.gui.workflow.editor.properties.TypeSelectionOption;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class EndpointEditDialog
extends Dialog {
    protected static final String COLON = ":";
    protected static final String MINUS = "-";
    private static final int GROUPS_MIN_WIDTH = 235;
    private static final int MINIMUM_HEIGHT = 125;
    private static final int MINIMUM_WIDTH = 250;
    protected final ComponentInstanceProperties configuration;
    protected final EndpointType type;
    protected Text textfieldName;
    protected Combo comboDataType;
    protected String initialName;
    protected String currentName;
    protected DataType currentDataType;
    protected EndpointDefinition.InputDatumHandling currentInputHandling;
    protected EndpointDefinition.InputExecutionContraint currentInputExecutionConstraint;
    protected String title;
    protected List<TypeSelectionOption> typeSelectionOptions;
    protected Map<Widget, String> widgetToKeyMap;
    protected EndpointMetaDataDefinition metaData;
    protected Map<String, String> metadataValues;
    protected EndpointDescriptionsManager epManager;
    protected ConfigurationDescription configDesc;
    private final String id;
    private final boolean isStatic;
    private Map<String, DataType> guiNameToDataType;
    private Combo comboInputDatumHandling;
    private Map<String, EndpointDefinition.InputDatumHandling> guiNameToInputDatumHandling;
    private Combo comboInputExecutionContraint;
    private Map<String, EndpointDefinition.InputExecutionContraint> guiNameToInputExecutionConstraint;
    private int readOnlyType;

    public EndpointEditDialog(Shell parentShell, EndpointActionType actionType, ComponentInstanceProperties configuration, EndpointType direction, String id, boolean isStatic, EndpointMetaDataDefinition metaData, Map<String, String> metadataValues) {
        this(parentShell, actionType, configuration, direction, id, isStatic, metaData, metadataValues, EndpointEditDialog.getReadOnlyValue(isStatic));
    }

    public EndpointEditDialog(Shell parentShell, EndpointActionType actionType, ComponentInstanceProperties configuration, EndpointType direction, String id, boolean isStatic, EndpointMetaDataDefinition metaData, Map<String, String> metadataValues, int readOnlyType) {
        super(parentShell);
        this.setShellStyle(67696);
        this.configuration = configuration;
        this.type = direction;
        this.id = id;
        this.isStatic = isStatic;
        this.epManager = direction == EndpointType.INPUT ? configuration.getInputDescriptionsManager() : configuration.getOutputDescriptionsManager();
        this.configDesc = configuration.getConfigurationDescription();
        this.title = StringUtils.format((String)Messages.title, (Object[])new Object[]{actionType, direction});
        this.metaData = metaData;
        this.metadataValues = metadataValues;
        this.readOnlyType = readOnlyType;
        if (!isStatic) {
            this.setDataType();
            this.setInputHandling();
            this.setInputExecutionConstraint();
        }
    }

    private static int getReadOnlyValue(boolean isStatic) {
        if (isStatic) {
            return 2;
        }
        return 1;
    }

    private void setDataType() {
        this.currentDataType = this.isStatic || this.epManager.getEndpointDescription(this.currentName) != null ? this.epManager.getEndpointDescription(this.currentName).getDataType() : this.epManager.getDynamicEndpointDefinition(this.id).getDefaultDataType();
    }

    private void setInputHandling() {
        this.currentInputHandling = this.metadataValues.containsKey("inputHandling_73b1056e") ? EndpointDefinition.InputDatumHandling.valueOf((String)this.metadataValues.get("inputHandling_73b1056e")) : (this.isStatic || this.epManager.getEndpointDescription(this.currentName) != null ? this.epManager.getEndpointDescription(this.currentName).getEndpointDefinition().getDefaultInputDatumHandling() : this.epManager.getDynamicEndpointDefinition(this.id).getDefaultInputDatumHandling());
    }

    private void setInputExecutionConstraint() {
        this.currentInputExecutionConstraint = this.metadataValues.containsKey("inputExecutionConstraint_4aae3eea") ? EndpointDefinition.InputExecutionContraint.valueOf((String)this.metadataValues.get("inputExecutionConstraint_4aae3eea")) : (this.isStatic || this.epManager.getEndpointDescription(this.currentName) != null ? this.epManager.getEndpointDescription(this.currentName).getEndpointDefinition().getDefaultInputExecutionConstraint() : this.epManager.getDynamicEndpointDefinition(this.id).getDefaultInputExecutionConstraint());
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, true));
        GridData g = new GridData(1808);
        g.grabExcessHorizontalSpace = true;
        g.horizontalAlignment = 2;
        container.setLayoutData((Object)g);
        this.createEndpointSettings(container);
        Composite configHeader = new Composite(container, 4);
        configHeader.setLayout((Layout)new GridLayout(3, false));
        Label sep = new Label(configHeader, 262);
        sep.setLayoutData((Object)g);
        Label sectionTitle = new Label(configHeader, 0);
        sectionTitle.setText(Messages.configurationHeader);
        Label sep2 = new Label(configHeader, 262);
        sep2.setLayoutData((Object)g);
        configHeader.setLayoutData((Object)g);
        this.createConfigurationArea(container);
        return container;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected Control createConfigurationArea(Composite parent) {
        block3: {
            block4: {
                this.widgetToKeyMap = new HashMap<Widget, String>();
                if (this.metaData.getMetaDataKeys().isEmpty()) break block3;
                settingsComposite = (Composite)super.createDialogArea(parent);
                g = new GridData(4, 4, true, true);
                settingsComposite.setLayoutData((Object)g);
                if (this.metaData == null) break block4;
                groups = new TreeMap<String, Map<Integer, String>>();
                for (String key : this.metaData.getMetaDataKeys()) {
                    block5: {
                        group = this.metaData.getGuiGroup(key);
                        groupTree /* !! */  = groups.containsKey(group) != false ? (Map)groups.get(group) : new TreeMap<K, V>();
                        position = this.metaData.getGuiPosition(key);
                        if (position >= 0) ** GOTO lbl17
                        groupTree /* !! */ .put(groupTree /* !! */ .size(), key);
                        break block5;
lbl-1000:
                        // 1 sources

                        {
                            ++position;
lbl17:
                            // 2 sources

                            ** while (groupTree /* !! */ .containsKey((Object)Integer.valueOf((int)position)))
                        }
lbl18:
                        // 1 sources

                        groupTree /* !! */ .put(position, key);
                    }
                    groups.put(group, groupTree /* !! */ );
                }
                for (String groupKey : groups.keySet()) {
                    this.createSettingsTab(settingsComposite, groupKey, (Map)groups.get(groupKey));
                }
            }
            return settingsComposite;
        }
        noMetaData = new Label(parent, 0);
        noMetaData.setText(StringUtils.format((String)Messages.noConfig, (Object[])new Object[]{this.type}));
        g = new GridData(4, 4, true, true);
        g.horizontalAlignment = 0x1000000;
        noMetaData.setLayoutData((Object)g);
        return parent;
    }

    protected void createSettingsTab(Composite composite, String groupTitle, Map<Integer, String> sortedKeyMap) {
        Group configGroup = new Group(composite, 0x1000000);
        GridData g = new GridData(1808);
        configGroup.setLayoutData((Object)g);
        g.grabExcessHorizontalSpace = true;
        g.horizontalAlignment = 2;
        g.minimumWidth = 235;
        configGroup.setText(groupTitle);
        configGroup.setLayout((Layout)new GridLayout(2, false));
        this.createSettings(sortedKeyMap, (Composite)configGroup);
        if (configGroup.getChildren().length == 0) {
            configGroup.dispose();
        }
    }

    protected void createSettings(Map<Integer, String> sortedKeyMap, Composite container) {
        for (String key : sortedKeyMap.values()) {
            if (this.metaData.getVisibility(key).equals((Object)EndpointMetaDataConstants.Visibility.developerConfigurable) || !this.metadataIsActive(key, this.metaData.getActivationFilter(key))) continue;
            String value = this.metadataValues.get(key);
            if (value == null || value.equals("")) {
                value = this.metaData.getDefaultValue(key);
                this.metadataValues.put(key, value);
            }
            if (this.metaData.getDataType(key).equals("bool")) {
                Button newCheckbox = this.createLabelAndCheckbox(container, String.valueOf(this.metaData.getGuiName(key)) + COLON, value);
                this.widgetToKeyMap.put((Widget)newCheckbox, key);
                newCheckbox.addSelectionListener((SelectionListener)new SelectionChangedListener());
                continue;
            }
            if (this.metaData.getPossibleValues(key) == null || this.metaData.getPossibleValues(key).contains("*")) {
                Text newTextfield = this.createLabelAndTextfield(container, String.valueOf(this.metaData.getGuiName(key)) + COLON, this.metaData.getDataType(key), value);
                this.widgetToKeyMap.put((Widget)newTextfield, key);
                newTextfield.addModifyListener((ModifyListener)new MethodPropertiesModifyListener());
                continue;
            }
            Combo newCombo = this.createLabelAndCombo(container, String.valueOf(this.metaData.getGuiName(key)) + COLON, key, value);
            this.widgetToKeyMap.put((Widget)newCombo, key);
            newCombo.addModifyListener((ModifyListener)new MethodPropertiesModifyListener());
        }
    }

    protected boolean metadataIsActive(String key, Map<String, List<String>> activationFilter) {
        if (activationFilter != null) {
            boolean hasActiveFilter = false;
            for (String config : activationFilter.keySet()) {
                for (String value : activationFilter.get(config)) {
                    if (!this.configuration.getConfigurationDescription().getActualConfigurationValue(config).equals(value)) continue;
                    hasActiveFilter = true;
                }
            }
            return hasActiveFilter;
        }
        return true;
    }

    protected Button createLabelAndCheckbox(Composite container, String text, String value) {
        new Label(container, 0).setText(text);
        Button result = new Button(container, 32);
        result.setLayoutData((Object)new GridData(4, 4, true, false));
        if (value.equals("true")) {
            result.setSelection(true);
        } else {
            result.setSelection(false);
        }
        return result;
    }

    protected Combo createLabelAndCombo(Composite container, String text, String key, String value) {
        new Label(container, 0).setText(text);
        Combo combo = new Combo(container, 8);
        combo.setLayoutData((Object)new GridData(4, 4, true, false));
        for (String entry : this.metaData.getGuiNamesOfPossibleValues(key)) {
            combo.add(entry);
        }
        combo.select(this.metaData.getPossibleValues(key).indexOf(value));
        combo.setEnabled(this.metaData.getPossibleValues(key).size() > 1);
        return combo;
    }

    protected Text createLabelAndTextfield(Composite container, String text, String dataType, String value) {
        new Label(container, 0).setText(text);
        Text result = new Text(container, 2052);
        result.setLayoutData((Object)new GridData(4, 4, true, false));
        result.setText(value);
        if (dataType.equals("int")) {
            result.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(result, 2));
            if (value.equals(MINUS)) {
                result.setText("");
            }
        }
        if (dataType.equals("float")) {
            result.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(result, 1));
            if (value.equals(MINUS)) {
                result.setText("");
            }
        }
        if (dataType.equals("float_greater_zero")) {
            result.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(result, 17));
            if (value.equals(MINUS)) {
                result.setText("");
            }
        }
        return result;
    }

    protected void createEndpointSettings(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridData g = new GridData(4, 4, true, true);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)g);
        GridData textGridData = new GridData();
        textGridData.grabExcessHorizontalSpace = false;
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(String.valueOf(Messages.name) + COLON);
        nameLabel.setLayoutData((Object)textGridData);
        this.textfieldName = new Text(container, 2052);
        this.textfieldName.setLayoutData((Object)new GridData(4, 4, true, false));
        this.textfieldName.setEditable(!this.isStatic && !this.epManager.getDynamicEndpointDefinition(this.id).isNameReadOnly() && this.readOnlyType != 4 && this.readOnlyType != 2);
        this.textfieldName.addListener(25, (Listener)new AlphanumericalTextContraintListener(true, true));
        this.initialName = this.currentName;
        if (this.currentName != null) {
            this.textfieldName.setText(this.currentName);
        }
        Label dataTypeLabel = new Label(container, 0);
        dataTypeLabel.setText(String.valueOf(Messages.dataType) + COLON);
        dataTypeLabel.setLayoutData((Object)textGridData);
        this.createDataTypeComboBox(container);
        if (this.type == EndpointType.INPUT) {
            Label inputHandlingLabel = new Label(container, 0);
            inputHandlingLabel.setText("Handling:");
            inputHandlingLabel.setLayoutData((Object)textGridData);
            this.createInputHandlingComboBox(container);
            Label executionConstraintLabel = new Label(container, 0);
            executionConstraintLabel.setText("Constraint:");
            executionConstraintLabel.setLayoutData((Object)textGridData);
            this.createInputExecutionContraintComboBox(container);
        }
    }

    private void createDataTypeComboBox(Composite container) {
        this.comboDataType = new Combo(container, 133128);
        this.comboDataType.setLayoutData((Object)new GridData(4, 4, true, false));
        List possibleDataTypes = this.isStatic ? this.epManager.getStaticEndpointDefinition(this.currentName).getPossibleDataTypes() : (this.epManager.getDynamicEndpointDefinition(this.id) != null ? this.epManager.getDynamicEndpointDefinition(this.id).getPossibleDataTypes() : new LinkedList());
        this.guiNameToDataType = new HashMap<String, DataType>();
        LinkedList<String> dataTypesGuiNames = new LinkedList<String>();
        for (DataType t : possibleDataTypes) {
            dataTypesGuiNames.add(t.getDisplayName());
            this.guiNameToDataType.put(t.getDisplayName(), t);
        }
        Collections.sort(dataTypesGuiNames);
        this.comboDataType.setItems(dataTypesGuiNames.toArray(new String[dataTypesGuiNames.size()]));
        if (this.currentDataType != null) {
            this.comboDataType.select(this.comboDataType.indexOf(this.currentDataType.getDisplayName()));
        } else {
            this.comboDataType.select(this.comboDataType.indexOf(this.epManager.getDynamicEndpointDefinition(this.id).getDefaultDataType().getDisplayName()));
        }
        this.comboDataType.setEnabled(possibleDataTypes.size() > 1 && this.readOnlyType != 4 && this.readOnlyType != 2);
    }

    private void createInputHandlingComboBox(Composite container) {
        this.comboInputDatumHandling = new Combo(container, 133128);
        this.comboInputDatumHandling.setLayoutData((Object)new GridData(4, 4, true, false));
        List possibleInputinputHandlingOptions = this.isStatic ? this.epManager.getStaticEndpointDefinition(this.currentName).getInputDatumOptions() : (this.epManager.getDynamicEndpointDefinition(this.id) != null ? this.epManager.getDynamicEndpointDefinition(this.id).getInputDatumOptions() : new LinkedList());
        this.guiNameToInputDatumHandling = new HashMap<String, EndpointDefinition.InputDatumHandling>();
        LinkedList<String> inputHandlingGuiNames = new LinkedList<String>();
        for (EndpointDefinition.InputDatumHandling t : possibleInputinputHandlingOptions) {
            inputHandlingGuiNames.add(t.getDisplayName());
            this.guiNameToInputDatumHandling.put(t.getDisplayName(), t);
        }
        Collections.sort(inputHandlingGuiNames);
        this.comboInputDatumHandling.setItems(inputHandlingGuiNames.toArray(new String[inputHandlingGuiNames.size()]));
        if (this.currentInputHandling != null) {
            this.comboInputDatumHandling.select(this.comboInputDatumHandling.indexOf(this.currentInputHandling.getDisplayName()));
        } else {
            this.comboInputDatumHandling.select(this.comboInputDatumHandling.indexOf(this.epManager.getDynamicEndpointDefinition(this.id).getDefaultInputDatumHandling().getDisplayName()));
        }
        this.comboInputDatumHandling.setEnabled(possibleInputinputHandlingOptions.size() > 1);
    }

    private void createInputExecutionContraintComboBox(Composite container) {
        this.comboInputExecutionContraint = new Combo(container, 133128);
        this.comboInputExecutionContraint.setLayoutData((Object)new GridData(4, 4, true, false));
        List possibleInputHandlingOptions = this.isStatic ? this.epManager.getStaticEndpointDefinition(this.currentName).getInputExecutionConstraintOptions() : (this.epManager.getDynamicEndpointDefinition(this.id) != null ? this.epManager.getDynamicEndpointDefinition(this.id).getInputExecutionConstraintOptions() : new LinkedList());
        this.guiNameToInputExecutionConstraint = new HashMap<String, EndpointDefinition.InputExecutionContraint>();
        LinkedList<String> executionConstraintsGuiNames = new LinkedList<String>();
        for (EndpointDefinition.InputExecutionContraint t : possibleInputHandlingOptions) {
            executionConstraintsGuiNames.add(t.getDisplayName());
            this.guiNameToInputExecutionConstraint.put(t.getDisplayName(), t);
        }
        Collections.sort(executionConstraintsGuiNames);
        this.comboInputExecutionContraint.setItems(executionConstraintsGuiNames.toArray(new String[executionConstraintsGuiNames.size()]));
        if (this.currentInputExecutionConstraint != null) {
            this.comboInputExecutionContraint.select(this.comboInputExecutionContraint.indexOf(this.currentInputExecutionConstraint.getDisplayName()));
        } else {
            this.comboInputExecutionContraint.select(this.comboInputExecutionContraint.indexOf(this.epManager.getDynamicEndpointDefinition(this.id).getDefaultInputExecutionConstraint().getDisplayName()));
        }
        this.comboInputExecutionContraint.setEnabled(possibleInputHandlingOptions.size() > 1);
    }

    public void create() {
        super.create();
        this.getShell().setText(this.title);
        this.getShell().setMinimumSize(250, 125);
        this.validateInput();
        this.installModifyListeners();
        this.validateInput();
    }

    private void installModifyListeners() {
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EndpointEditDialog.this.validateInput();
            }
        };
        this.textfieldName.addModifyListener(modifyListener);
        this.comboDataType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                EndpointEditDialog.this.validateInput();
            }
        });
    }

    protected void validateInput() {
        String name = this.getNameInputFromUI();
        boolean nameIsValid = name.equals(this.initialName);
        this.getButton(0).setEnabled((nameIsValid |= this.epManager.isValidEndpointName(name)) & this.validateMetaDataInputs());
    }

    protected Widget getWidget(String key) {
        for (Map.Entry<Widget, String> entry : this.widgetToKeyMap.entrySet()) {
            if (!entry.getValue().equals(key)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected boolean validateMetaDataInputs() {
        boolean isValid = true;
        for (Widget widget : this.widgetToKeyMap.keySet()) {
            boolean enabled;
            String key = "";
            if (this.metaData.getMetaDataKeys().contains(this.widgetToKeyMap.get(widget))) {
                key = this.widgetToKeyMap.get(widget);
            }
            String dataType = this.metaData.getDataType(key);
            String validation = this.metaData.getValidation(key);
            boolean visible = this.metaData.isDefinedForDataType(key, this.guiNameToDataType.get(this.comboDataType.getText()));
            boolean bl = enabled = EndpointHelper.checkMetadataFilter((Map)this.metaData.getGuiActivationFilter(key), this.metadataValues, (ConfigurationDescription)this.configDesc) && (visible &= EndpointHelper.checkMetadataFilter((Map)this.metaData.getGuiVisibilityFilter(key), this.metadataValues, (ConfigurationDescription)this.configDesc));
            if (!dataType.equals("bool") && (this.metaData.getPossibleValues(key) == null || this.metaData.getPossibleValues(key).contains("*"))) {
                if (((Text)widget).getText().equals("") && visible && enabled && validation != null && validation.contains("required")) {
                    isValid = false;
                } else if (!((Text)widget).getText().equals("")) {
                    if (dataType.equalsIgnoreCase("int")) {
                        int value = Integer.MAX_VALUE;
                        try {
                            value = Integer.parseInt(((Text)widget).getText());
                            isValid &= this.checkValidation(value, validation);
                        }
                        catch (NumberFormatException numberFormatException) {
                            value = Integer.MAX_VALUE;
                            isValid &= false;
                        }
                    }
                    if (dataType.equalsIgnoreCase("bool")) {
                        try {
                            Boolean.parseBoolean(((Text)widget).getText());
                        }
                        catch (NumberFormatException numberFormatException) {
                            isValid &= false;
                        }
                    }
                    if (dataType.equalsIgnoreCase("float")) {
                        double value = Double.MAX_VALUE;
                        try {
                            value = Double.parseDouble(((Text)widget).getText());
                            isValid &= this.checkValidation(value, validation);
                        }
                        catch (NumberFormatException numberFormatException) {
                            value = Double.MAX_VALUE;
                            isValid &= false;
                        }
                    }
                }
            }
            if (widget instanceof Text) {
                ((Text)widget).getParent().setVisible(visible);
                ((Text)widget).setEnabled(enabled);
            } else if (widget instanceof Combo) {
                ((Combo)widget).getParent().setVisible(visible);
                ((Combo)widget).setEnabled(enabled);
            } else if (widget instanceof Button) {
                ((Button)widget).getParent().setVisible(visible);
                ((Button)widget).setEnabled(enabled);
            }
            if (!enabled) {
                if (widget instanceof Button) {
                    this.metadataValues.put(this.widgetToKeyMap.get(widget), this.metaData.getDefaultValue(this.widgetToKeyMap.get(widget)));
                    continue;
                }
                this.metadataValues.put(this.widgetToKeyMap.get(widget), MINUS);
                continue;
            }
            if (!(widget instanceof Text)) continue;
            this.metadataValues.put(this.widgetToKeyMap.get(widget), ((Text)widget).getText());
        }
        return isValid;
    }

    protected boolean checkValidation(double value, String validation) {
        boolean result = true;
        if (validation != null && !validation.equals("")) {
            String[] splitValidations;
            String[] stringArray = splitValidations = validation.split(",");
            int n = splitValidations.length;
            int n2 = 0;
            while (n2 < n) {
                double restriction;
                String argument = stringArray[n2];
                if (argument.contains("<=")) {
                    restriction = Double.parseDouble(argument.substring(2));
                    if (value > restriction) {
                        result = false;
                    }
                } else if (argument.contains(">=")) {
                    restriction = Double.parseDouble(argument.substring(2));
                    if (value < restriction) {
                        result = false;
                    }
                } else if (argument.contains("<")) {
                    restriction = Double.parseDouble(argument.substring(1));
                    if (value >= restriction) {
                        result = false;
                    }
                } else if (argument.contains(">") && value <= (restriction = Double.parseDouble(argument.substring(1)))) {
                    result = false;
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean checkValidation(int value, String validation) {
        return this.checkValidation((double)value, validation);
    }

    public Map<String, String> getMetadataValues() {
        if (this.type == EndpointType.INPUT) {
            this.metadataValues.put("inputHandling_73b1056e", this.currentInputHandling.name());
            this.metadataValues.put("inputExecutionConstraint_4aae3eea", this.currentInputExecutionConstraint.name());
        }
        return this.metadataValues;
    }

    public void initializeValues(String name) {
        this.currentName = name;
        this.setDataType();
        this.setInputHandling();
        this.setInputExecutionConstraint();
    }

    public String getChosenName() {
        return this.currentName;
    }

    public DataType getChosenDataType() {
        return this.currentDataType;
    }

    protected String getNameInputFromUI() {
        return this.textfieldName.getText();
    }

    protected DataType getTypeSelectionFromUI() {
        return this.guiNameToDataType.get(this.comboDataType.getText());
    }

    protected void okPressed() {
        this.currentName = this.getNameInputFromUI();
        this.currentDataType = this.getTypeSelectionFromUI();
        if (this.type == EndpointType.INPUT) {
            this.currentInputHandling = this.guiNameToInputDatumHandling.get(this.comboInputDatumHandling.getText());
            this.currentInputExecutionConstraint = this.guiNameToInputExecutionConstraint.get(this.comboInputExecutionContraint.getText());
        }
        this.callSuperOkPressed();
    }

    protected void callSuperOkPressed() {
        super.okPressed();
    }

    public void setBlockOnOpen(boolean shouldBlock) {
        super.setBlockOnOpen(true);
    }

    public void setReadOnlyType(int readOnlyType) {
        this.readOnlyType = readOnlyType;
    }

    public class MethodPropertiesModifyListener
    implements ModifyListener {
        public void modifyText(ModifyEvent event) {
            Widget source = (Widget)event.getSource();
            if (EndpointEditDialog.this.metaData.getMetaDataKeys().contains(EndpointEditDialog.this.widgetToKeyMap.get(source))) {
                String value = null;
                if (source instanceof Text) {
                    value = ((Text)source).getText();
                } else if (source instanceof Combo) {
                    int index = ((Combo)source).getSelectionIndex();
                    value = (String)EndpointEditDialog.this.metaData.getPossibleValues(EndpointEditDialog.this.widgetToKeyMap.get(source)).get(index);
                }
                EndpointEditDialog.this.metadataValues.put(EndpointEditDialog.this.widgetToKeyMap.get(source), value);
            }
            EndpointEditDialog.this.validateInput();
        }
    }

    public class SelectionChangedListener
    extends SelectionAdapter {
        public void widgetDefaultSelected(SelectionEvent e) {
            Button source = (Button)e.getSource();
            if (EndpointEditDialog.this.metaData.getMetaDataKeys().contains(EndpointEditDialog.this.widgetToKeyMap.get(source))) {
                EndpointEditDialog.this.metadataValues.put(EndpointEditDialog.this.widgetToKeyMap.get(source), "" + source.getSelection());
            }
            EndpointEditDialog.this.validateInput();
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }
    }
}

