/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import java.awt.Point;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.external.ExternalHandlers;

public class DisplayOffsets {
    private int userOffsetX = 0;
    private int userOffsetY = 0;
    private int userPrintOffsetX = 0;
    private int userPrintOffsetY = 0;
    private int facingCursorX = 10000;
    private int facingCursorY = 10000;

    public void setUserOffsets(int n, int n2, int n3, ExternalHandlers externalHandlers, PdfDecoder pdfDecoder) {
        switch (n3) {
            case 0: {
                this.userOffsetX = n;
                this.userOffsetY = n2;
                break;
            }
            case 1: {
                this.userPrintOffsetX = n;
                this.userPrintOffsetY = -n2;
                break;
            }
            case 995: {
                this.facingCursorX = 0;
                this.facingCursorY = pdfDecoder.getHeight();
                SwingGUI swingGUI = (SwingGUI)externalHandlers.getExternalHandler(11);
                if (swingGUI != null) {
                    swingGUI.setDragCorner(n3);
                }
                pdfDecoder.repaint();
                break;
            }
            case 998: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                SwingGUI swingGUI = (SwingGUI)externalHandlers.getExternalHandler(11);
                if (swingGUI != null) {
                    swingGUI.setDragCorner(n3);
                }
                pdfDecoder.repaint();
                break;
            }
            case 999: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                SwingGUI swingGUI = (SwingGUI)externalHandlers.getExternalHandler(11);
                if (swingGUI != null) {
                    swingGUI.setDragCorner(n3);
                }
                pdfDecoder.repaint();
                break;
            }
            case 996: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                SwingGUI swingGUI = (SwingGUI)externalHandlers.getExternalHandler(11);
                if (swingGUI != null) {
                    swingGUI.setDragCorner(n3);
                }
                pdfDecoder.repaint();
                break;
            }
            case 997: {
                this.facingCursorX = n;
                this.facingCursorY = n2;
                SwingGUI swingGUI = (SwingGUI)externalHandlers.getExternalHandler(11);
                if (swingGUI != null) {
                    swingGUI.setDragCorner(n3);
                }
                pdfDecoder.repaint();
                break;
            }
            default: {
                throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
            }
        }
    }

    public Point getUserOffsets(int n) {
        switch (n) {
            case 0: {
                return new Point(this.userOffsetX, this.userOffsetY);
            }
            case 1: {
                return new Point(this.userPrintOffsetX, this.userPrintOffsetY);
            }
            case 999: {
                return new Point(this.facingCursorX, this.facingCursorY);
            }
        }
        throw new RuntimeException("No such mode - look in org.jpedal.external.OffsetOptions for valid values");
    }

    public int getUserPrintOffsetX() {
        return this.userPrintOffsetX;
    }

    public int getUserPrintOffsetY() {
        return this.userPrintOffsetY;
    }

    public int getUserOffsetX() {
        return this.userOffsetX;
    }

    public int getUserOffsetY() {
        return this.userOffsetY;
    }
}

