/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap.commands;

import com.icegreen.greenmail.imap.ImapRequestLineReader;
import com.icegreen.greenmail.imap.ImapResponse;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.ImapSessionFolder;
import com.icegreen.greenmail.imap.ProtocolException;
import com.icegreen.greenmail.imap.commands.AuthenticatedStateCommand;
import com.icegreen.greenmail.imap.commands.ExamineCommand;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;

class SelectCommand
extends AuthenticatedStateCommand {
    public static final String NAME = "SELECT";
    public static final String ARGS = "mailbox";

    SelectCommand() {
        super(NAME, ARGS);
    }

    SelectCommand(String name) {
        super(name, null);
    }

    @Override
    protected void doProcess(ImapRequestLineReader request, ImapResponse response, ImapSession session) throws ProtocolException, FolderException {
        String mailboxName = this.parser.mailbox(request);
        this.parser.endLine(request);
        session.deselect();
        boolean isExamine = this instanceof ExamineCommand;
        this.selectMailbox(mailboxName, session, isExamine);
        ImapSessionFolder mailbox = session.getSelected();
        response.flagsResponse(mailbox.getPermanentFlags());
        response.existsResponse(mailbox.getMessageCount());
        boolean resetRecent = !isExamine;
        response.recentResponse(mailbox.getRecentCount(resetRecent));
        response.okResponse("UIDVALIDITY " + mailbox.getUidValidity(), null);
        response.okResponse("UIDNEXT " + mailbox.getUidNext(), null);
        int firstUnseen = mailbox.getFirstUnseen();
        if (firstUnseen > 0) {
            response.okResponse("UNSEEN " + firstUnseen, "Message " + firstUnseen + " is the first unseen");
        } else {
            response.okResponse(null, "No messages unseen");
        }
        response.permanentFlagsResponse(mailbox.getPermanentFlags());
        if (mailbox.isReadonly()) {
            response.commandComplete(this, "READ-ONLY");
        } else {
            response.commandComplete(this, "READ-WRITE");
        }
    }

    private boolean selectMailbox(String mailboxName, ImapSession session, boolean readOnly) throws FolderException {
        MailFolder folder = this.getMailbox(mailboxName, session, true);
        if (!folder.isSelectable()) {
            throw new FolderException("Nonselectable mailbox.");
        }
        session.setSelected(folder, readOnly);
        return readOnly;
    }
}

