/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.database.gui;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.components.database.common.DatabaseStatement;
import de.rcenvironment.components.database.gui.DatabaseStatementComposite;
import de.rcenvironment.core.component.model.endpoint.api.EndpointChange;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDescription;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class DatabaseStatementSection
extends ValidatingWorkflowNodePropertySection {
    private static final String OUTPUT = "OUTPUT";
    private static final String INPUT = "INPUT";
    private static final String INSERT_BUTTONS_TEXT = "Insert";
    private static final int STATEMENTS_COMPOSITE_MINIMAL_WIDTH = 350;
    private static final int INPUTS_COMBO_MINIMUM_WIDTH = 100;
    private static final int TEMPLATES_COMBO_MINIMUM_WIDTH = 100;
    private static final String ADD_TAB_LABEL = "< + >";
    private static final String NEW_STATEMENT_NAME = "Statement";
    private static Map<String, String> templatesMap = new HashMap<String, String>();
    private CCombo templatesCombo;
    private CCombo inputCombo;
    private CTabFolder statementsFolder;
    private Button insertInputButton;

    static {
        templatesMap = new HashMap<String, String>();
        templatesMap.put("select", "SELECT * FROM table_name WHERE column1 = 'value1';");
        templatesMap.put("insert", "INSERT INTO table_name (id, column1, column2, column3) VALUES ${in:smalltable_input};");
        templatesMap.put("delete", "DELETE FROM table_name WHERE column1 = 'value1';");
        templatesMap.put("update", "UPDATE table_name SET column2 = 'value2' WHERE column1 = 'value1';");
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.refreshOutputCombos();
        ComponentInstanceProperties config = this.getConfiguration();
        config.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() instanceof EndpointChange) {
                    if (DatabaseStatementSection.this.statementsFolder.isDisposed()) {
                        return;
                    }
                    EndpointType type = ((EndpointChange)evt.getNewValue()).getOldEndpointDescription() != null ? ((EndpointChange)evt.getNewValue()).getOldEndpointDescription().getEndpointDefinition().getEndpointType() : ((EndpointChange)evt.getNewValue()).getEndpointDescription().getEndpointDefinition().getEndpointType();
                    if (type.name().equals(DatabaseStatementSection.INPUT)) {
                        if (DatabaseStatementSection.this.getOrderedInputNames().length != 0) {
                            DatabaseStatementSection.this.inputCombo.setItems(DatabaseStatementSection.this.getOrderedInputNames());
                            DatabaseStatementSection.this.inputCombo.setEnabled(true);
                            DatabaseStatementSection.this.inputCombo.select(0);
                        } else {
                            DatabaseStatementSection.this.inputCombo.setText("< no inputs defined >");
                            DatabaseStatementSection.this.inputCombo.setEnabled(false);
                        }
                    }
                    if (type.name().equals(DatabaseStatementSection.OUTPUT)) {
                        DatabaseStatementSection.this.refreshOutputCombos();
                    }
                }
            }
        });
    }

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory factory = aTabbedPropertySheetPage.getWidgetFactory();
        Section sectionStatement = factory.createSection(parent, 320);
        sectionStatement.setText("Database Statement");
        sectionStatement.marginWidth = 5;
        sectionStatement.marginHeight = 5;
        Composite mainComposite = new Composite((Composite)sectionStatement, 0);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        GridData mainData = new GridData(1808);
        mainComposite.setLayoutData((Object)mainData);
        mainComposite.setBackground(Display.getDefault().getSystemColor(1));
        CLabel statementsOrderHintLabel = new CLabel(mainComposite, 0);
        GridData statementHintLabelData = new GridData(1808);
        statementHintLabelData.horizontalSpan = 2;
        statementsOrderHintLabel.setLayoutData((Object)statementHintLabelData);
        statementsOrderHintLabel.setText("Note: The statements are executed sequentially from left to right within one transaction.");
        statementsOrderHintLabel.setImage(ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.INFORMATION_16));
        Composite statementsComposite = new Composite(mainComposite, 0);
        statementsComposite.setLayout((Layout)new GridLayout(1, false));
        GridData statementsData = new GridData(1808);
        statementsData.widthHint = 350;
        statementsComposite.setLayoutData((Object)statementsData);
        this.statementsFolder = new CTabFolder(statementsComposite, 2048);
        GridData statementTabFolderData = new GridData(1808);
        this.statementsFolder.setLayoutData((Object)statementTabFolderData);
        this.statementsFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolderClosingListener());
        this.statementsFolder.setSimple(false);
        Composite helperElementsComposite = new Composite(mainComposite, 0);
        helperElementsComposite.setLayout((Layout)new GridLayout(1, false));
        GridData helperElementsData = new GridData(770);
        helperElementsComposite.setLayoutData((Object)helperElementsData);
        Group inputsGroup = new Group(helperElementsComposite, 0);
        inputsGroup.setLayout((Layout)new GridLayout(3, false));
        GridData inputsGroupData = new GridData(768);
        inputsGroup.setLayoutData((Object)inputsGroupData);
        inputsGroup.setText("Input");
        Label inputLabel = new Label((Composite)inputsGroup, 0);
        inputLabel.setText("Input:");
        this.inputCombo = new CCombo((Composite)inputsGroup, 2056);
        GridData inputsComboData = new GridData(768);
        inputsComboData.minimumWidth = 100;
        this.inputCombo.setLayoutData((Object)inputsComboData);
        this.inputCombo.setBackground(Display.getDefault().getSystemColor(1));
        this.insertInputButton = new Button((Composite)inputsGroup, 0);
        this.insertInputButton.setText(INSERT_BUTTONS_TEXT);
        this.insertInputButton.addSelectionListener((SelectionListener)new InsertInputButtonListener());
        Group templatesGroup = new Group(helperElementsComposite, 0);
        templatesGroup.setText("Templates");
        templatesGroup.setLayout((Layout)new GridLayout(3, false));
        GridData templatesGroupData = new GridData(768);
        templatesGroup.setLayoutData((Object)templatesGroupData);
        Label templatesLabel = new Label((Composite)templatesGroup, 0);
        templatesLabel.setText("Template:");
        this.templatesCombo = new CCombo((Composite)templatesGroup, 2056);
        GridData templatesComboData = new GridData(768);
        templatesComboData.minimumWidth = 100;
        this.templatesCombo.setLayoutData((Object)templatesComboData);
        this.templatesCombo.setBackground(Display.getDefault().getSystemColor(1));
        Button insertTemplateButton = new Button((Composite)templatesGroup, 0);
        insertTemplateButton.setText(INSERT_BUTTONS_TEXT);
        insertTemplateButton.addSelectionListener((SelectionListener)new InsertTemplateButtonListener());
        sectionStatement.setClient((Control)mainComposite);
    }

    private CTabItem addCTabItemToFolder(DatabaseStatement model) {
        CTabItem newCTabItem = new CTabItem(this.statementsFolder, 64, model.getIndex());
        newCTabItem.setText(model.getName());
        DatabaseStatementComposite newDatabaseStatementComposite = new DatabaseStatementComposite((Composite)this.statementsFolder, 0);
        newDatabaseStatementComposite.createControls();
        if (model.getName() != null && !model.getName().isEmpty()) {
            newDatabaseStatementComposite.getStatementNameText().setText(model.getName());
        }
        if (model.getStatement() != null && !model.getStatement().isEmpty()) {
            newDatabaseStatementComposite.getStatementText().setText(model.getStatement());
        }
        newDatabaseStatementComposite.getWriteToOutputCheckButton().setSelection(model.isWillWriteToOutput());
        if (this.getOrderedOutputNames().length > 0) {
            if (model.getOutputToWriteTo() != null && !model.getOutputToWriteTo().isEmpty()) {
                newDatabaseStatementComposite.fillOutputComboAndSetSelection(this.getOrderedOutputNames(), model.getOutputToWriteTo());
            } else {
                newDatabaseStatementComposite.fillOutputCombo(this.getOrderedOutputNames());
            }
            newDatabaseStatementComposite.getOutputCombo().setEnabled(newDatabaseStatementComposite.getWriteToOutputCheckButton().getSelection());
        } else {
            newDatabaseStatementComposite.getOutputCombo().setEnabled(false);
            newDatabaseStatementComposite.getOutputCombo().setText("< no outputs defined >");
        }
        newDatabaseStatementComposite.getStatementNameText().addFocusListener((FocusListener)new StatementNameFocusListener(newCTabItem));
        newDatabaseStatementComposite.getStatementText().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                DatabaseStatementSection.this.writeCurrentStatementsToProperties();
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        newDatabaseStatementComposite.getWriteToOutputCheckButton().addSelectionListener((SelectionListener)new WriteToOutputSelectionChangedListener());
        newDatabaseStatementComposite.getOutputCombo().addSelectionListener((SelectionListener)new OutputSelectionChangedListener());
        newCTabItem.setControl((Control)newDatabaseStatementComposite);
        this.statementsFolder.setSelection(newCTabItem);
        return newCTabItem;
    }

    private String determineNextValidStatementName(String currentName) {
        List<String> currentStatementNames = this.getCurrentStatementNames();
        List<Integer> currentUsedIndices = this.convertStatementNamesToIndices(currentStatementNames);
        int newIndex = 1;
        while (currentUsedIndices.contains(newIndex)) {
            ++newIndex;
        }
        currentName = String.valueOf(currentName) + " (" + newIndex + ")";
        return currentName;
    }

    private List<Integer> convertStatementNamesToIndices(List<String> statementNames) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (String name : statementNames) {
            int count = 0;
            if (name.contains("(") && name.contains(")")) {
                try {
                    int indexBegin = name.lastIndexOf("(") + 1;
                    int indexEnd = name.lastIndexOf(")");
                    count = Integer.valueOf(name.substring(indexBegin, indexEnd));
                }
                catch (NumberFormatException numberFormatException) {
                    count = 0;
                }
            }
            indices.add(count);
        }
        return indices;
    }

    private CTabItem addNewCTabItem() {
        int indexToSet = this.statementsFolder.getItemCount() - 1;
        if (this.statementsFolder.getItemCount() == 0) {
            indexToSet = 0;
        }
        String newStatementName = NEW_STATEMENT_NAME;
        String name = this.determineNextValidStatementName(newStatementName);
        DatabaseStatement newModel = new DatabaseStatement();
        newModel.setName(name);
        newModel.setIndex(indexToSet);
        CTabItem newItem = this.addCTabItemToFolder(newModel);
        this.statementsFolder.setSelection(this.statementsFolder.getItemCount() - 2);
        this.refreshOutputCombos();
        return newItem;
    }

    private void addPlusCTabItemToFolder() {
        CTabItem addNewItemTab = new CTabItem(this.statementsFolder, 0);
        addNewItemTab.setText(ADD_TAB_LABEL);
        addNewItemTab.setShowClose(false);
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.inputCombo.removeAll();
        this.inputCombo.setItems(this.getOrderedInputNames());
        if (this.inputCombo.getItemCount() > 0) {
            this.insertInputButton.setEnabled(true);
            this.inputCombo.setEnabled(true);
            this.inputCombo.select(0);
        } else {
            this.inputCombo.setEnabled(false);
            this.inputCombo.setText("< no inputs defined >");
            this.insertInputButton.setEnabled(false);
        }
        this.templatesCombo.removeAll();
        this.templatesCombo.setItems(this.getOrderedTemplateNames());
        if (this.templatesCombo.getItemCount() > 0) {
            this.templatesCombo.select(0);
        }
        this.refreshOutputCombos();
        CTabItem[] cTabItemArray = this.statementsFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            item.dispose();
            ++n2;
        }
        List<DatabaseStatement> models = this.readCurrentDatabaseStatementsFromConfig();
        this.statementsFolder.setRedraw(false);
        if (!models.isEmpty()) {
            for (DatabaseStatement model : models) {
                this.addCTabItemToFolder(model);
            }
        }
        this.statementsFolder.setSelection(0);
        this.addPlusCTabItemToFolder();
        this.statementsFolder.setRedraw(true);
        if (this.statementsFolder.getData("SelectionListenerToken") == null) {
            this.statementsFolder.addSelectionListener((SelectionListener)new StatementsFolderSelectionListener());
            this.statementsFolder.setData("SelectionListenerToken", (Object)true);
        }
        if (this.statementsFolder.getData("StatementsFolderListenerToken") == null) {
            this.statementsFolder.addMouseListener((MouseListener)new StatementsFolderMouseListener());
            this.statementsFolder.setData("StatementsFolderListenerToken", (Object)true);
        }
    }

    private void refreshOutputCombos() {
        CTabItem[] cTabItemArray = this.statementsFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (!item.getText().equals(ADD_TAB_LABEL) && item.getControl() instanceof DatabaseStatementComposite) {
                DatabaseStatementComposite control = (DatabaseStatementComposite)item.getControl();
                String selection = this.getOutputToWriteToByStatementName(item.getText());
                boolean selected = control.getWriteToOutputCheckButton().getSelection();
                this.fillOutputsCombo(control.getOutputCombo(), selection, selected);
            }
            ++n2;
        }
    }

    private String getOutputToWriteToByStatementName(String statementName) {
        List<DatabaseStatement> statements = this.readCurrentDatabaseStatementsFromConfig();
        for (DatabaseStatement statement : statements) {
            if (!statement.getName().equals(statementName)) continue;
            return statement.getOutputToWriteTo();
        }
        return null;
    }

    private void fillOutputsCombo(CCombo comboToFill, String currentSelection, boolean enabled) {
        comboToFill.removeAll();
        if (this.getOutputNamesUnordered().isEmpty()) {
            comboToFill.setEnabled(false);
            comboToFill.setText("< no outputs defined >");
        } else {
            comboToFill.setEnabled(enabled);
            comboToFill.setItems(this.getOrderedOutputNames());
            if (currentSelection != null && Arrays.asList(comboToFill.getItems()).contains(currentSelection)) {
                comboToFill.select(comboToFill.indexOf(currentSelection));
            }
        }
    }

    private List<String> getCurrentStatementNames() {
        ArrayList<String> statementNames = new ArrayList<String>();
        CTabItem[] cTabItemArray = this.statementsFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tabItem = cTabItemArray[n2];
            statementNames.add(tabItem.getText());
            ++n2;
        }
        return statementNames;
    }

    private String[] getOrderedInputNames() {
        ArrayList<String> inputChannelNames = new ArrayList<String>();
        for (EndpointDescription channelName : this.getConfiguration().getInputDescriptionsManager().getDynamicEndpointDescriptions()) {
            inputChannelNames.add(channelName.getName());
        }
        Collections.sort(inputChannelNames, String.CASE_INSENSITIVE_ORDER);
        String[] inputChannelNamesArray = new String[inputChannelNames.size()];
        int i = 0;
        while (i < inputChannelNames.size()) {
            inputChannelNamesArray[i] = (String)inputChannelNames.get(i);
            ++i;
        }
        return inputChannelNamesArray;
    }

    private String[] getOrderedOutputNames() {
        ArrayList<String> outputChannelNames = new ArrayList<String>();
        for (EndpointDescription channelName : this.getConfiguration().getOutputDescriptionsManager().getDynamicEndpointDescriptions()) {
            outputChannelNames.add(channelName.getName());
        }
        Collections.sort(outputChannelNames, String.CASE_INSENSITIVE_ORDER);
        String[] inputChannelNamesArray = new String[outputChannelNames.size()];
        int i = 0;
        while (i < outputChannelNames.size()) {
            inputChannelNamesArray[i] = (String)outputChannelNames.get(i);
            ++i;
        }
        return inputChannelNamesArray;
    }

    private String[] getOrderedTemplateNames() {
        ArrayList<String> templateNames = new ArrayList<String>();
        for (String templateName : templatesMap.keySet()) {
            templateNames.add(templateName);
        }
        Collections.sort(templateNames, String.CASE_INSENSITIVE_ORDER);
        String[] templateNamesArray = new String[templateNames.size()];
        int i = 0;
        while (i < templateNames.size()) {
            templateNamesArray[i] = (String)templateNames.get(i);
            ++i;
        }
        return templateNamesArray;
    }

    private List<String> getOutputNamesUnordered() {
        ArrayList<String> outputNames = new ArrayList<String>();
        for (EndpointDescription output : this.getOutputs()) {
            if (output.getEndpointDefinition().isStatic()) continue;
            outputNames.add(output.getName());
        }
        return outputNames;
    }

    private List<DatabaseStatement> readCurrentDatabaseStatementsFromConfig() {
        ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
        List<Object> models = new ArrayList<DatabaseStatement>();
        try {
            String modelsString = this.getProperty("databaseStatements");
            if (modelsString != null) {
                models = (List)mapper.readValue(modelsString, (JavaType)mapper.getTypeFactory().constructCollectionType(List.class, DatabaseStatement.class));
            }
        }
        catch (JsonGenerationException | JsonMappingException throwable) {
            this.logger.error((Object)"Failed to map database component's JSON content to database statements.");
        }
        catch (IOException iOException) {
            this.logger.error((Object)"Failed to load database component's JSON content from file system.");
        }
        return models;
    }

    protected void setWorkflowNode(WorkflowNode workflowNode) {
        super.setWorkflowNode(workflowNode);
        this.aboutToBeShown();
    }

    private void writeCurrentStatementsToProperties() {
        ArrayList<DatabaseStatement> currentStatements = new ArrayList<DatabaseStatement>();
        if (!this.statementsFolder.isDisposed()) {
            CTabItem[] cTabItemArray = this.statementsFolder.getItems();
            int n = cTabItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                CTabItem item = cTabItemArray[n2];
                if (!item.getText().equals(ADD_TAB_LABEL)) {
                    int index = this.statementsFolder.indexOf(item);
                    DatabaseStatementComposite control = (DatabaseStatementComposite)item.getControl();
                    DatabaseStatement statement = new DatabaseStatement();
                    statement.setName(control.getStatementNameText().getText());
                    statement.setStatement(control.getStatementText().getText());
                    statement.setWillWriteToOutput(control.getWriteToOutputCheckButton().getSelection());
                    String outputToWriteTo = control.getOutputCombo().getText();
                    statement.setOutputToWriteTo(outputToWriteTo);
                    statement.setIndex(index);
                    currentStatements.add(statement);
                }
                ++n2;
            }
            ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
            String currentStatementsString = null;
            try {
                currentStatementsString = mapper.writeValueAsString(currentStatements);
            }
            catch (JsonGenerationException | JsonMappingException throwable) {
                this.logger.error((Object)"Failed to map database statements to database component's JSON content.");
            }
            catch (IOException iOException) {
                this.logger.error((Object)"Failed to write database component's statements to file system.");
            }
            if (currentStatementsString != null) {
                if (this.getProperty("databaseStatements") == null) {
                    this.setProperty("databaseStatements", currentStatementsString);
                } else if (!this.getProperty("databaseStatements").equals(currentStatementsString)) {
                    this.setProperty("databaseStatements", currentStatementsString);
                }
            }
        }
    }

    protected DatabaseStatementSectionUpdater createUpdater() {
        return new DatabaseStatementSectionUpdater();
    }

    private final class CTabFolderClosingListener
    implements CTabFolder2Listener {
        private CTabFolderClosingListener() {
        }

        public void showList(CTabFolderEvent event) {
        }

        public void restore(CTabFolderEvent event) {
        }

        public void minimize(CTabFolderEvent event) {
        }

        public void maximize(CTabFolderEvent event) {
        }

        public void close(CTabFolderEvent event) {
            if (event.item instanceof CTabItem) {
                CTabItem selectedItem = (CTabItem)event.item;
                CTabFolder tabFolder = (CTabFolder)event.widget;
                if (selectedItem.getText().equals(DatabaseStatementSection.ADD_TAB_LABEL) || tabFolder.getItemCount() < 3) {
                    event.doit = false;
                } else {
                    selectedItem.dispose();
                    DatabaseStatementSection.this.writeCurrentStatementsToProperties();
                }
            }
        }
    }

    protected class DatabaseStatementSectionUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected DatabaseStatementSectionUpdater() {
            super((WorkflowNodePropertySection)DatabaseStatementSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            List models = DatabaseStatementSection.this.readCurrentDatabaseStatementsFromConfig();
            DatabaseStatementSection.this.statementsFolder.setRedraw(false);
            int tabNumber = DatabaseStatementSection.this.statementsFolder.getItems().length - 1;
            if (models.size() > tabNumber) {
                for (DatabaseStatement model : models) {
                    boolean val = true;
                    int i = 0;
                    while (i < DatabaseStatementSection.this.statementsFolder.getItems().length) {
                        if (DatabaseStatementSection.this.statementsFolder.getItems()[i].getText().equals(model.getName())) {
                            val = false;
                            break;
                        }
                        ++i;
                    }
                    if (!val) continue;
                    DatabaseStatementSection.this.addCTabItemToFolder(model);
                }
            }
            if (models.size() < tabNumber) {
                int i = 0;
                while (i < DatabaseStatementSection.this.statementsFolder.getItems().length) {
                    boolean val = true;
                    for (DatabaseStatement model : models) {
                        if (!DatabaseStatementSection.this.statementsFolder.getItems()[i].getText().equals(model.getName())) continue;
                        val = false;
                        break;
                    }
                    if (val) {
                        DatabaseStatementSection.this.statementsFolder.getItems()[i].dispose();
                    }
                    ++i;
                }
            }
            for (DatabaseStatement model : models) {
                CTabItem item = DatabaseStatementSection.this.statementsFolder.getItem(model.getIndex());
                if (!(item.getControl() instanceof DatabaseStatementComposite)) continue;
                DatabaseStatementComposite dsc = (DatabaseStatementComposite)item.getControl();
                if (!dsc.getStatementNameText().getText().equals(model.getName())) {
                    dsc.getStatementNameText().setText(model.getName());
                    item.setText(model.getName());
                }
                if (!dsc.getStatementText().getText().equals(model.getStatement())) {
                    dsc.getStatementText().setText(model.getStatement());
                }
                if (dsc.getWriteToOutputCheckButton().getSelection() != model.isWillWriteToOutput()) {
                    dsc.getWriteToOutputCheckButton().setSelection(model.isWillWriteToOutput());
                    if (model.isWillWriteToOutput() && !model.getOutputToWriteTo().equals("< no outputs defined >")) {
                        dsc.getOutputCombo().setEnabled(true);
                        continue;
                    }
                    dsc.getOutputCombo().setEnabled(false);
                    continue;
                }
                if (dsc.getOutputCombo().getText().equals(model.getOutputToWriteTo())) continue;
                if (model.getOutputToWriteTo().equals("")) {
                    dsc.getOutputCombo().setText("");
                    continue;
                }
                dsc.getOutputCombo().setText(model.getOutputToWriteTo());
                if (!model.getOutputToWriteTo().equals("< no outputs defined >")) continue;
                dsc.getOutputCombo().setEnabled(true);
                dsc.getOutputCombo().setText("");
            }
            DatabaseStatementSection.this.statementsFolder.setRedraw(true);
        }
    }

    private final class InsertInputButtonListener
    implements SelectionListener {
        private InsertInputButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            String inputToInsert = DatabaseStatementSection.this.inputCombo.getText();
            String textToInsert = "";
            if (inputToInsert != null && !inputToInsert.isEmpty()) {
                textToInsert = StringUtils.format((String)"${in:%s}", (Object[])new Object[]{inputToInsert});
                CTabItem currentItem = DatabaseStatementSection.this.statementsFolder.getItem(DatabaseStatementSection.this.statementsFolder.getSelectionIndex());
                if (currentItem.getControl() instanceof DatabaseStatementComposite && !textToInsert.isEmpty()) {
                    DatabaseStatementComposite statementComposite = (DatabaseStatementComposite)currentItem.getControl();
                    statementComposite.getStatementText().insert(textToInsert);
                }
            }
            DatabaseStatementSection.this.writeCurrentStatementsToProperties();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }

    private final class InsertTemplateButtonListener
    implements SelectionListener {
        private InsertTemplateButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            String templateToInsert = (String)templatesMap.get(DatabaseStatementSection.this.templatesCombo.getText());
            CTabItem currentItem = DatabaseStatementSection.this.statementsFolder.getItem(DatabaseStatementSection.this.statementsFolder.getSelectionIndex());
            if (currentItem.getControl() instanceof DatabaseStatementComposite) {
                DatabaseStatementComposite statementComposite = (DatabaseStatementComposite)currentItem.getControl();
                statementComposite.getStatementText().insert(templateToInsert);
            }
            DatabaseStatementSection.this.writeCurrentStatementsToProperties();
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }

    private final class OutputSelectionChangedListener
    implements SelectionListener {
        private OutputSelectionChangedListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
        }

        public void widgetSelected(SelectionEvent event) {
            DatabaseStatementSection.this.writeCurrentStatementsToProperties();
        }
    }

    private final class StatementNameFocusListener
    implements FocusListener {
        private final CTabItem statementItem;
        private boolean flag;

        private StatementNameFocusListener(CTabItem statementItem) {
            this.statementItem = statementItem;
            this.flag = false;
        }

        public void focusLost(FocusEvent event) {
            if (this.flag || !((Text)event.widget).getText().equals(DatabaseStatementSection.NEW_STATEMENT_NAME)) {
                this.statementItem.setText(((Text)event.widget).getText());
                DatabaseStatementSection.this.writeCurrentStatementsToProperties();
            }
            this.flag = true;
        }

        public void focusGained(FocusEvent event) {
        }
    }

    private final class StatementsFolderMouseListener
    extends MouseAdapter {
        private StatementsFolderMouseListener() {
        }

        public void mouseDown(MouseEvent event) {
        }
    }

    private final class StatementsFolderSelectionListener
    implements SelectionListener {
        private StatementsFolderSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            CTabItem clickedItem;
            if (event.item instanceof CTabItem && (clickedItem = (CTabItem)event.item).getText().equals(DatabaseStatementSection.ADD_TAB_LABEL) && DatabaseStatementSection.this.statementsFolder.getItemCount() > 1) {
                DatabaseStatementSection.this.addNewCTabItem();
                DatabaseStatementSection.this.writeCurrentStatementsToProperties();
            }
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }
    }

    private final class WriteToOutputSelectionChangedListener
    implements SelectionListener {
        private WriteToOutputSelectionChangedListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        public void widgetSelected(SelectionEvent event) {
            CTabItem currentItem;
            boolean selected = false;
            if (event.getSource() instanceof Button) {
                Button clickedButton = (Button)event.getSource();
                selected = clickedButton.getSelection();
            }
            if ((currentItem = DatabaseStatementSection.this.statementsFolder.getItem(DatabaseStatementSection.this.statementsFolder.getSelectionIndex())).getControl() instanceof DatabaseStatementComposite) {
                DatabaseStatementComposite statementComposite = (DatabaseStatementComposite)currentItem.getControl();
                if (statementComposite.getOutputCombo().getItemCount() == 0) {
                    statementComposite.getOutputCombo().setEnabled(false);
                } else if (statementComposite.getOutputCombo().getItem(0).equals("< no outputs defined >")) {
                    statementComposite.getOutputCombo().setEnabled(false);
                } else {
                    statementComposite.getOutputCombo().setEnabled(selected);
                }
            }
            DatabaseStatementSection.this.writeCurrentStatementsToProperties();
        }
    }
}

